/***************************************************************************
    file	         : kb_wizfields.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_WIZFIELDS_H
#define	__KB_WIZFIELDS_H


#include	"kb_classes.h"
#include	"kb_database.h"
#include	"kb_wizard.h"
#include	"kb_listboxpair.h"

#include	"libwizard_exports.h"


/*  KBWizFieldSpecList/KBWizFieldSpec					*/
/*  ---------------------------------					*/
/*  The list boxes used for this class contain KBWizFieldSpec objects	*/
/*  which store the full field specification, so that the main wizard	*/
/*  code can recover this later. The KBWizFieldSpecList class is used	*/
/*  to provide the "replicate" method for this type.			*/

class	LIBWIZARD_API KBWizFieldSpec : public QListBoxText, public KBFieldSpec
{
public	:

	KBWizFieldSpec	(QListBox *, KBFieldSpec *) ;
}	;

class	KBWizFieldSpecList : public KBListBoxPair
{
public	:

	KBWizFieldSpecList
	(	QListBox    *, QListBox    *,
		QPushButton *, QPushButton *,
		QPushButton *, QPushButton *,
		QPushButton *,
		bool = false
	)	;

	virtual	QListBoxItem	*replicate (QListBoxItem *) ;

}	;


/*  KBWizardCtrlFields							*/
/*  ------------------							*/
/*  Wizard control used to allow selection of fields, either from a	*/
/*  table or a (rekall-level) query. Uses the KBListBoxPair class to	*/
/*  handle addition/removal and ordering.				*/

class	LIBWIZARD_API KBWizardCtrlFields : public KBWizardCtrl
{
	Q_OBJECT

	QString		m_sourceName	;

	QWidget		*m_widget	;
	QListBox	*m_source	;
	QListBox	*m_dest		;
	QPushButton	*m_bAdd		;
	QPushButton	*m_bAddAll	;
	QPushButton	*m_bRemove	;
	QPushButton	*m_bMoveUp	;
	QPushButton	*m_bMoveDown	;
	KBWizFieldSpecList
			*m_lbPair	;


public	:

	KBWizardCtrlFields
	(	KBWizardPage		*,
		const QDomElement	&
	)	;

	virtual	~KBWizardCtrlFields	()	;

	virtual	void	pageShown	(bool)	;
	virtual	bool	ok		()	;

	virtual	QVariant
			attribute	(const QString &) ;
	virtual	void	setValue	(const QString &) ;
	virtual	QString	value		()	;		

	void		fields		(QList<KBFieldSpec> &)	;
}	;

#endif	// __KB_WIZFIELDS_H
