/*
    Copyright (C) 2001-2002 by theKompany.com <www.thekompany.com>
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    See COPYING.GPL file.

    In addition, as a special exception, theKompany.com gives permission
    to link the code of this program with the tkwidgets library (or with
    modified versions of tkwidgets that use the same license as tkwidgets),
    and distribute linked combinations including the two.  You must obey
    the GNU General Public License in all respects for all of the code used
    other than tkwidgets.  If you modify this file, you may extend this
    exception to your version of the file, but you are not obligated to do so.
    If you do not wish to do so, delete this exception statement from your
    version.

    This license grants you the ability to use tkwidgets with Rekall only
    and may not be used outside of Rekall.
    See also http://www.rekall.a-i-s.co.uk/products/license.txt for details.
*/


#ifndef TKTEXTVIEV_H
#define TKTEXTVIEV_H

#ifdef _WIN32
#pragma warning(disable : 4251)
#endif

#include <qwidget.h>
#include <qscrollbar.h>
#include <qstringlist.h>

#include "libtkwidgets_exports.h"

class LIBTKWIDGETS_API  TKTextEditorManager;
class LIBTKWIDGETS_API  TKTextEditor;
class LIBTKWIDGETS_API  TKTextDocument;
class LIBTKWIDGETS_API  TKTextView;
class LIBTKWIDGETS_API  TKTextLine;
class LIBTKWIDGETS_API  QListBox;

class LIBTKWIDGETS_API  LineRegion
{
public:
  LineRegion() { clear(); }

  void clear() { start = -1; end = -1; }
  void expand(int , int = -1);
  void expand(const LineRegion &);

  void intersect(int, int);

  bool isEmpty() const { return start == -1; }

  int start;
  int end;
};
/****************************************************************************/
class LIBTKWIDGETS_API  TKMargin : public QWidget
{ Q_OBJECT
public:
  TKMargin(QWidget *parent, TKTextView *);
  ~TKMargin();

  void resizeBuffer();

protected:
  virtual void resizeEvent(QResizeEvent *);

protected:
  TKTextView *view;
  TKTextDocument *document;
  TKTextEditorManager *manager;
  QPixmap *buffer;
};
/****************************************************************************/
class LIBTKWIDGETS_API  TKIndicatorMargin : public TKMargin
{ Q_OBJECT
public:
  TKIndicatorMargin(QWidget *parent, TKTextView *);
  ~TKIndicatorMargin();

  virtual QSize sizeHint() const;

protected:
  virtual void paintEvent(QPaintEvent *);
};
/****************************************************************************/
class LIBTKWIDGETS_API  TKLinuNumberMargin : public TKMargin
{ Q_OBJECT
public:
  TKLinuNumberMargin(QWidget *parent, TKTextView *);
  ~TKLinuNumberMargin();

  virtual QSize sizeHint() const;

protected:
  virtual void paintEvent(QPaintEvent *);
};
/****************************************************************************/
class LIBTKWIDGETS_API  TKSelectionMargin : public TKMargin
{ Q_OBJECT
public:
  TKSelectionMargin(QWidget *parent, TKTextView *);
  ~TKSelectionMargin();

  virtual QSize sizeHint() const;

protected:
  virtual void mousePressEvent(QMouseEvent *);
  virtual void mouseMoveEvent(QMouseEvent *);
  virtual void mouseReleaseEvent(QMouseEvent *);
  virtual void paintEvent(QPaintEvent *);

private:
  bool doSelect;
  int start;
  int last;
  bool upOrDown;
};
/****************************************************************************/
class LIBTKWIDGETS_API  TKEditorCursor : public QObject
{ Q_OBJECT
public:
  TKEditorCursor(TKTextView *);
  ~TKEditorCursor();

  enum CursorAction {
    MoveBackward,
    MoveForward,
    MoveWordBackward,
    MoveWordForward,
    MoveUp,
    MoveDown,
    MoveLineStart,
    MoveLineEnd,
    MoveHome,
    MoveEnd,
    MovePgUp,
    MovePgDown
  };

  void paint();
  void move(CursorAction, bool select);
  void set(int line, int column, bool update);

  int column() const;
  int line() const;
  class QPoint position();

  void setEnabled(bool=true);
  void activate();
  void deactivate();

protected:
  virtual void timerEvent(QTimerEvent *);

private:
  TKTextView *view;
  TKTextDocument *document;
  TKTextEditorManager *manager;
  int timer;
  int xpos;
  int ypos;
  bool visible;
  bool active;
  int stack;
};

inline int TKEditorCursor::column() const
{ return xpos; }

inline int TKEditorCursor::line() const
{ return ypos; }
/****************************************************************************/
class LIBTKWIDGETS_API  TKTextView : public QWidget
{ Q_OBJECT
friend class TKTextDocument;
friend class TKTextEditor;

signals :
  void mouseRightClick (QPoint, int) ;

public:
  TKTextView(TKTextEditor *);
  ~TKTextView();

  virtual void setFocus() ;
  virtual bool event(QEvent *);
  virtual bool eventFilter(QObject *, QEvent *);

  void setSelection(const QPoint &from, const QPoint &to);
  bool hasSelection(bool withSelection=true, bool withFound=true);
  QString selectedText();
  QRect selection();
  bool inSelected(int line, int column);
  void clearSelection();

  void clearFound();
  void setFound(int line, int pos, int length);

  void setCursorPosition(int line, int column, bool select=false);
  void ensureCursorVisible();

  QString currentWord();
  QString wordIn(int line, int column, int *start=0, int *end=0);

  int contentsX();
  int contentsY();

  void updateView(bool newDocGeometry);
  void updateMarginsState();

  void lineHeightChanged();

  TKEditorCursor *Cursor() const { return cursor; }
  TKTextEditor *textEditor() const { return editor; }
  TKTextDocument *textDocument() const { return document; }
  TKTextEditorManager *textManager() const { return manager; }

  void completeWord();
  void centerCursor(int line, int column);

  void lockSeletion(bool);
  bool isSelectionFixed() const;
  void repaintMargins();

	void repaintIndicatorMargin();

protected slots:
  void applyCompleteWord();
  void stopMouseScroll();

protected:
  bool inRect(const QRect &, int, int, bool);
  void finishCompletion();
  void scrollX(int);
  void scrollY(int);
  QCursor mouseCursor(int id);

  virtual void focusInEvent(QFocusEvent *);
  virtual void focusOutEvent(QFocusEvent *);
  virtual void keyPressEvent(QKeyEvent *);
  virtual void wheelEvent( QWheelEvent * );
  virtual void mousePressEvent(QMouseEvent *);
  virtual void mouseMoveEvent(QMouseEvent *);
  virtual void mouseReleaseEvent(QMouseEvent *);
  virtual void mouseDoubleClickEvent(QMouseEvent *);
  virtual void paintEvent(QPaintEvent *);
  virtual void resizeEvent(QResizeEvent *);
  virtual void showEvent(QShowEvent *);
  virtual void timerEvent(QTimerEvent *);
  virtual void dragEnterEvent(QDragEnterEvent *);
  virtual void dropEvent(QDropEvent *);

  void translatePos (QPoint, int &, int &) ;

private slots:
  void hslide(int);
  void vslide(int);

private:
  TKTextEditor *editor;
  TKTextDocument *document;
  TKTextEditorManager *manager;

  QListBox *popupBox;
  QScrollBar hbar;
  QScrollBar vbar;
  TKEditorCursor *cursor;
  int cursorLine;

  int xPos;
  int yPos;

  QRect selected;
  QRect found;
  QPoint selectionStart;
  LineRegion update;

  QString completionWord;
  QStringList completionGrep;
  QStringList completionWords;

  TKIndicatorMargin *indicatorMargin;
  TKSelectionMargin *selectionMargin;
  TKLinuNumberMargin *linuNumberMargin;

  bool mousePressed;
  bool selectionFixed;

  bool mouseScrollMode;
  bool mouseScrollModeDone;
  QPoint mouseScrollPos;
  QPoint mouseScrollDist;
  int mouseScrollTimer;
  QWidget *mouseCenter;
};

inline int TKTextView::contentsX()
{
  return xPos;
}

inline int TKTextView::contentsY()
{
  return yPos;
}

#endif
