/***************************************************************************
    file	         : tk_dialogs.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qnamespace.h>
#include	<qmessagebox.h>
#include	<qcolordialog.h>
#include	<qfontdialog.h>

#include	"tk_filedialog.h"
#include	"tk_colordialog.h"
#include	"tk_fontdialog.h"
#include	"tk_messagebox.h"

int	TKMessageBox::questionYesNo
	(	QWidget		*parent,
		const QString	&text,
		const QString	&caption,
		const QString	&buttonYes,
		const QString	&buttonNo,
		bool		
	)
{
	QString	bYes	= buttonYes	;
	QString	bNo	= buttonNo	;

	if (bYes.isEmpty()) bYes = "Yes" ;
	if (bNo .isEmpty()) bNo  = "No " ;

	QMessageBox mb
		(	caption,
			text,
			QMessageBox::Information,
        		QMessageBox::Yes | QMessageBox::Default,
        		QMessageBox::No,
			0L,
			parent
		)	;

	mb.setButtonText(QMessageBox::Yes, bYes);
	mb.setButtonText(QMessageBox::No, bNo);

	return	mb.exec() ==  QMessageBox::Yes ?
			     TKMessageBox::Yes : TKMessageBox::No ;
}


void	TKMessageBox::sorry
	(	QWidget		*parent,
		const QString	&text,
		const QString	&caption,
		bool		
	)
{
	QMessageBox::information
	(	parent,
		caption,
		text
	)	;
}

void	TKMessageBox::information
	(	QWidget		*parent,
		const QString	&text,
		const QString	&caption,
		const QString	&,
		bool		
	)
{
	QMessageBox::information
	(	parent,
		caption,
		text
	)	;
}

TKColorDialog::TKColorDialog
	(	QWidget		*parent,
		const char 	*name,
		bool
	)
	:
	m_parent (parent),
	m_name	 (name)
{
	m_color	= Qt::black	;
}

void	TKColorDialog::setColor
	(	const QColor	&color
	)
{
	m_color	 = color ;
}

bool	TKColorDialog::exec ()
{
	m_color	= QColorDialog::getColor (m_color, m_parent, m_name) ;
	return	m_color != QColor () ;
}

QColor	TKColorDialog::color ()
{
	return	m_color	;
}

int	TKColorDialog::getColor
	(	QColor		&color,
		QWidget		*parent
	)
{
	color	= QColorDialog::getColor (color, parent) ;
	return	color == QColor() ? Rejected : Accepted  ;
}


TKFontDialog::TKFontDialog
	(	QWidget			*parent,
		const char		*name,
		bool			,
		bool			,
		const QStringList	&,
		bool
	)
	:
	m_parent	(parent),
	m_name		(name)
{
}

void	TKFontDialog::setFont
	(	const QFont	&font,
		bool
	)
{
	m_font	= font	;
}

bool	TKFontDialog::exec ()
{
	bool	ok	;
	m_font	= QFontDialog::getFont (&ok, m_font, m_parent, m_name) ;
	return	ok	;
}

QFont	TKFontDialog::font ()
{
	return	m_font	;
}



