/***************************************************************************
    file	         : tk_action.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__TK_ACTION_H
#define	__TK_ACTION_H

#ifdef _WIN32
#pragma warning(disable : 4251)
#endif

#include	<qobject.h>
#include	<qstring.h>
#include	<qlist.h>
#include	<qdict.h>
#include	<qwidget.h>
#include	<qurl.h>
#include	<qpopupmenu.h>

#include "libtkkde_exports.h"

class	TKConfig		;

class	TKAction		;
class	TKActionCollection	;
class	TKActionPlugin		;

class LIBTKKDE_API TKURL : public QUrl
{
public	:

	TKURL	(const QUrl	&) ;
	TKURL	(const QString	&) ;
}	;

class LIBTKKDE_API TKStdAccel
{
public	:

	enum	StdAccel
	{	Open,
		Close,
		Save,
		Cut,
		Copy,
		Paste,
		NoAccel
	}	;

	static	int	key	(StdAccel)	;
}	;

/*  TKAction								*/
/*  --------								*/
/*  Basic action class. Looks much like KAction/QAction. There are a	*/
/*  couple of extensions, (a) a code which is used as an argument to	*/
/*  the activated signals and (b) a group so that (for instance) groups	*/
/*  of actions can be (dis)enabled in one go.				*/

class LIBTKKDE_API TKAction : public QObject
{
	Q_OBJECT

protected :

	QString			m_text		;
	QString			m_iconName	;
	int			m_accel		;

	TKActionCollection	*m_collection	;
	bool			m_enabled	;
	QList<TKActionPlugin>	m_plugins	;

	int			m_code		;
	int			m_group		;

signals	:

	void	activated	(int) ;

protected slots :

	virtual	void	slotActivated	()	;
	virtual	void	pluginDestroyed	()	;

public	:

	TKAction
	(	const QString	&text,
		const QString	&iconName,
		int		accel,
		const QObject	*receiver,
		const char	*slot,
		QObject		*parent,
		const char 	*name = 0
	)	;

	TKAction
	(	const QString	&text,
		int		accel,
		QObject		*parent,
		const char	*name
	)	;

	virtual	~TKAction () ;

	virtual	int	plug		(QWidget *, int = -1)	;
	virtual	void	unplug		(QWidget *)		;
	virtual	void	unplugAll	()			;
	virtual	void	setEnabled	(bool)			;
	virtual	void	setEnabled	(int, bool)		;
	virtual	void	setToolTip	(const QString &)	;
	virtual void	setIcon		(const QString &)	;

	inline	void	setCollection
		(	TKActionCollection	*collection
		)
	{
		m_collection = collection ;
	}
	inline	TKActionCollection *collection ()
	{
		return	m_collection ;
	}
	inline	void	setCode
		(	int	code
		)
	{
		m_code	= code	;
	}
	inline	void	setGroup
		(	int	group
		)
	{
		m_group	= group	;
	}

	inline	TKAction *getAction ()
	{
		return	this	;
	}
	inline	int	getGroup ()
	{
		return	m_group ;
	}
	inline	const	QString	&text ()
	{
		return	m_text	;
	}
}	;


/*  TKToggleAction							*/
/*  --------------							*/
/*  Action which toggles between on and off states. Can be set to	*/
/*  either state programatically.					*/

class LIBTKKDE_API TKToggleAction : public TKAction
{
	Q_OBJECT

	bool		m_checked	;

signals	:

	void	toggled	(bool, int)	;

protected slots :

	virtual	void	slotActivated	() ;

public	:

	TKToggleAction
	(	const QString	&text,
		const QString	&iconName,
		int		accel,
		const QObject	*receiver,
		const char	*slot,
		QObject		*parent,
		const char 	*name = 0
	)	;

	virtual	~TKToggleAction () ;

	virtual	int	plug		(QWidget *, int = -1) ;
	virtual	void	setChecked	(bool)		;
	virtual	void	setChecked	(int, bool)	;

	inline	bool	isChecked	() { return m_checked ; }

	inline	TKAction *getToggleAction ()
	{
		return	this	;
	}
}	;


/*  TKActionMenu							*/
/*  ------------							*/
/*  This is basically a place-holder for submenus which can be built	*/
/*  dynamically at runtime						*/

class LIBTKKDE_API TKActionMenu : public TKAction
{
	Q_OBJECT

protected :

	QPopupMenu	*m_popup		;

protected slots :

	virtual	void	slotActivated	()	;

public	:

	TKActionMenu
	(	const QString	&text,
		QObject		*parent		= 0,
		const char	*name		= 0
	)	;

	virtual	~TKActionMenu () ;

	virtual	int	plug		(QWidget  *, int = -1) ;
	void		insert		(TKAction *, int = -1) ;
	void		remove		(TKAction *) ;

	QPopupMenu 	*popup		() ;
}	;


class LIBTKKDE_API TKSelectAction : public TKActionMenu
{
	Q_OBJECT

	QList<TKAction>		m_select	;

signals	:

	void	selected	(const QString &url)	;

protected slots :

	virtual	void	slotActivated	()	;

public	:

	TKSelectAction
	(	const QString	&text,
		const QString	&iconName,
		int		accel,
		const QObject	*receiver,
		const char	*slot,
		QObject		*parent,
		const char 	*name = 0
	)	;

	virtual	int	plug		(QWidget *, int = -1)	;
	void		setItems	(const QStringList &) ;	
	void		setCurrentItem	(int) ;
	QPopupMenu	*popupMenu	() ;
}	;

/*  TKRecentFilesAction							*/
/*  -------------------							*/
/*  Action which handles recent files.					*/

class LIBTKKDE_API TKRecentFilesAction : public TKActionMenu
{
	Q_OBJECT

	QList<TKAction>		m_files	;

signals	:

	void	urlSelected	(const TKURL &url)	;

protected slots :

	virtual	void	slotActivated	() ;

public	:

	TKRecentFilesAction
	(	const QString	&text,
		const QString	&iconName,
		int		accel,
		const QObject	*receiver,
		const char	*slot,
		QObject		*parent,
		const char 	*name = 0
	)	;

	virtual	~TKRecentFilesAction () ;

	virtual	int	plug		(QWidget *, int = -1)	;
	void	loadEntries		(TKConfig *) ;
	void	saveEntries		(TKConfig *) ;
	void	addURL			(const TKURL &)	;
	void	removeURL		(const TKURL &) ;
	void	setCurrentItem		(int) ;
}	;

class LIBTKKDE_API	TKWidgetAction : public TKAction
{
	QWidget		*m_widget	;

public	:

	TKWidgetAction	(QWidget *, QObject *, const char *)	;

	virtual	int	plug		(QWidget *, int = -1)	;
}	;

/*  TKActionCollection							*/
/*  ------------------							*/
/*  Class used to hold a set of actions. The main use is with the XML	*/
/*  builder, but also supports operations by group.			*/

class LIBTKKDE_API TKActionCollection : public QObject
{
	Q_OBJECT

	QDict<TKAction>		m_actions	;

public	:

	TKActionCollection (QObject * = 0, const char * = 0) ;
	virtual	~TKActionCollection () ;

	virtual	void		insert	(TKAction *) ;
	virtual	void		remove	(TKAction *) ;
	virtual	void		take	(TKAction *) ;
	virtual	TKAction	*action (const char *) ;

	void	setEnabled	(int, bool) ;
}	;

#endif	// __TK_ACTION_H
