/***************************************************************************
    file	         : tk_part.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/



#include	<kmenubar.h>

#include	"tk_part.moc"
#include	"tk_mainwindow.moc"



TKPartManager::TKPartManager
	(	QWidget		*parent,
		const char	*name
	)
	:
	KParts::PartManager (parent, name)
{
	connect
	(	this,
		SIGNAL(activePartChanged(KParts::Part *)),
		this,
		SLOT  (      partChanged(KParts::Part *))
	)	;
}


void	TKPartManager::partChanged
	(	KParts::Part	*part
	)
{
	emit	activePartChanged ((TKPart *)(part)) ;
}

TKPart::TKPart
	(	QObject		*parent,
		const char	*name
	)
	:
	KParts::ReadWritePart (parent, name)
{
}

TKMainWindow::TKMainWindow
	(	QWidget		*,
		const char	*name,
		WFlags		flags
	)
	:
	KParts::MainWindow (name, flags)
{
}

void	TKMainWindow::createGUI
	(	TKPart		*part
	)
{
	KParts::MainWindow::createGUI (part) ;
}

int	TKMainWindow::menuBarHeight()
{
	return	menuBar()->height() ;
}

int	TKMainWindow::toolBarHeight()
{
	return	toolBar()->height() ;
}

void	TKMainWindow::showMenuToolBars
	(	bool	showMenuBar,
		bool	showToolBar
	)
{
	if (menuBar() != 0)
		if (showMenuBar)
			menuBar()->show() ;
		else	menuBar()->hide() ;

	if (toolBar() != 0)
		if (showToolBar)
			toolBar()->show() ;
		else	toolBar()->hide() ;
}

