/***************************************************************************
    file	         : tk_config.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<kapp.h>
#include	<kconfig.h>

#include	"tk_config.h"


static	TKConfig *p_appConfig	;



TKConfig::TKConfig
	(	KConfig	*config
	)
	:
	m_config (config)
{
}

TKConfig*TKConfig::getConfig ()
{
	if (p_appConfig == 0) p_appConfig = new TKConfig (kapp->config ()) ;
	return	p_appConfig	;
}

void	TKConfig::setGroup
	(	const QString	&group
	)
{
	m_config->setGroup (group) ;
}

void	TKConfig::writeEntry
	(	const QString	&key,
		int		value
	)
{
	m_config->writeEntry (key, value) ;
}

void	TKConfig::writeEntry
	(	const QString	&key,
		unsigned int	value
	)
{
	m_config->writeEntry (key, value) ;
}

void	TKConfig::writeEntry
	(	const QString	&key,
		const QSize	&value
	)
{
	m_config->writeEntry (key, value) ;
}

void	TKConfig::writeEntry
	(	const QString		&key,
		const QValueList<int>	&value
	)
{
	m_config->writeEntry (key, value) ;
}

void	TKConfig::writeEntry
	(	const QString		&key,
		const QStringList	&value,
		char			sep
	)
{
	m_config->writeEntry (key, value, sep) ;
}

QString	TKConfig::readEntry
	(	const QString		&key,
		const QString		&def
	)
{
	return	m_config->readEntry (key, def) ;
}

unsigned
int	TKConfig::readUnsignedNumEntry
	(	const QString	&key,
		unsigned int	def
	)
	const
{
	return	m_config->readUnsignedNumEntry (key, def) ;
}

int	TKConfig::readNumEntry	
	(	const QString	&key,
		int		def
	)
	const
{
	return	m_config->readNumEntry	 (key, def) ;
}

bool	TKConfig::readBoolEntry	
	(	const QString	&key,
		bool		def
	)
	const
{
	return	m_config->readBoolEntry	 (key, def) ;
}

QSize	TKConfig::readSizeEntry	
	(	const QString	&key,
		const QSize	*def
	)
	const
{
	return	m_config->readSizeEntry	 (key, def) ;
}

QValueList<int>
	TKConfig::readIntListEntry
	(	const QString	&key
	)
	const
{
	return	m_config->readIntListEntry (key) ;
}

QStringList
	TKConfig::readListEntry
	(	const QString	&key,
		char		sep
	)
	const
{
	return	m_config->readListEntry (key, sep) ;
}

KConfig	*TKConfig::config ()
{
	return	m_config ;
}

void	TKConfig::sync ()
{
	m_config->sync () ;
}
