/***************************************************************************
    file	         : kb_tabber.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_TABBER_H
#define	__KB_TABBER_H

#include	"kb_classes.h"
#include	"kb_framer.h"
#include	"kb_qttabber.h"

#include	"libkbase_exports.h"

class	KBTabber	;
class	KBTabberBar	;

class	KBTabberTab	;

/*  KBTabberBar								*/
/*  -----------								*/
/*  This class is the KBObject-level representation of the tab bar in	*/
/*  a tabbed form widget. Note that it never appears in the XML form	*/
/*  definition; instances are created as needed by the KBTabber class.	*/

class	LIBKBASE_API	KBTabberBar : public KBObject
{
	Q_OBJECT

	KBTabber		*m_tabber	;
	KBCtrlTabberBar		*m_tabBar	;
	QList<KBTabberTab>	m_tabList	;

public	:

	KBTabberBar (KBTabber *) ;
	KBTabberBar (KBNode *, KBTabberBar *) ;
	virtual	 ~KBTabberBar () ;

	virtual	void		buildCtrls	(uint, int, int ) ;
	virtual	KBNode		*replicate	(KBNode *) ;

	virtual	void		showAs		(KB::ShowAs)	;
	virtual	void		designPopup	(QMouseEvent *, uint) ;

	uint	getNumTabs	()			;
	int	getCurrentTab	(KBTabberPage  *&)	;
	void	setCurrentTab	(KBTabberPage   *)	;
	void	setPageEnabled	(KBTabberPage   *, bool);

	int	addTab		(const QString &, KBTabberPage *, bool = false) ;
	void	setTabText	(const QString &, KBTabberPage *) ;
	void	removeTab	(KBNode *)		;
	void	printPages  	(QString   &, int) 	;

public	slots :

	void	tabSelected	(int)	;
}	;


/*  KBTabber								*/
/*  This class is used for tabbed form widgets. It is a container,	*/
/*  which (implicitely) contains a tabbar, plus a further number of	*/
/*  containers which are the tabbed pages.				*/

class	LIBKBASE_API	KBTabber : public KBFramer
{
	Q_OBJECT

	KBAttrStr		m_initPage	;
	KBTabberBar		*m_tabberBar	;

protected slots :

	void			newPage		() ;
	void			setPageOrder	() ;

public	:

	KBTabber (KBNode *, const QDict<QString> &, bool * = 0) ;
	KBTabber (KBNode *, KBTabber *) ;
	virtual	 ~KBTabber () ;

	virtual	KBTabber	*isTabber	() { return this ; }

	virtual	KBNode		*replicate	(KBNode *) ;
	virtual	void		printNode	(QString &, int) ;
	virtual	void		designPopup	(QMouseEvent *, uint) ;
	virtual	void		showAs		(KB::ShowAs)	;
	virtual	bool		framerSetup	(KBQryBase *, uint, KBBlockInfo *) ;
	virtual	void		buildCtrls	(uint, int, int) ;
	virtual	bool		write		(KBWriter *, QPoint, bool, int &, bool = false) ;

	virtual	void		remChild   	(KBNode   *) ;

#if	! __KB_RUNTIME
	virtual	bool		playerAdd	(const QStringList &, KBError &) ;
#endif
	void	tabSelected	(KBTabberPage	*) ;
	void	setTabText	(KBTabberPage	*, QString) ;
	void	setPageEnabled	(KBTabberPage	*, bool   ) ;
	void	setCurrentPage	(KBTabberPage   *) ;
}	;

#endif	// __KB_TABBER_H
