/***************************************************************************
    file	         : kb_pixmap.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_PIXMAP_H
#define	_KB_PIXMAP_H


#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_item.h"
#include	"kb_attrframe.h"

#include	"libkbase_exports.h"


/*  KBPixmap								*/
/*  -----------								*/
/*  This class is used to represent a KBPixmap element in the XML	*/
/*  form description. Note that it may map onto more than one actual	*/
/*  image.								*/

class LIBKBASE_API	KBPixmap : public KBItem
{
	Q_OBJECT

	KBAttrFrame	frame	 	;	/* Frame style		*/
	KBAttrUInt	m_autosize	;
	KBEvent		onChange 	;

	uint		popupRow 	;

protected :

	virtual	KBControl *makeCtrl   (uint)	;

#if	! __KB_RUNTIME
	virtual	bool	 propertyDlg () ;
#endif

public	:

	KBPixmap (KBNode  *, const QDict<QString> &, bool * = 0) ;
	KBPixmap (KBNode  *, KBPixmap *) ;
virtual~KBPixmap () ;

	virtual	KBNode		*replicate      (KBNode *)  ;
	void			userChange	(uint)	;

	virtual	void		setTabOrder	(int)	;
	virtual	int		getTabOrder	()	;
	virtual	KBValue::VTrans	getVTrans	()	;

	virtual	void		contextMenu	(QMouseEvent *, uint) ;

	inline	uint	autoSize ()
	{
		return	m_autosize.getIntValue() ;
	}

protected slots :

	void			loadImage 	() ;
	void			saveImage 	() ;
	void			clearImage	() ;
}	;



#if	! __KB_RUNTIME
extern	LIBKBASE_API	bool	pixmapPropDlg
			(	KBPixmap	*,
				cchar		*,
				QList<KBAttr>	&
			)	;
#endif
#endif	// _KB_PIXMAP_H
