/***************************************************************************
    file	         : kb_overridedlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<time.h>
#include	<qlistbox.h>

#ifndef 	_WIN32
#include	"kb_overridedlg.moc"
#else
#include 	"kb_overridedlg.h"
#endif

#include	"kb_override.h"
#include	"kb_config.h"
#include	"kb_object.h"
#include	"kb_noobjdlg.h"
#include	"kb_font.h"

#include	"tk_colordialog.h"
#include	"tk_fontdialog.h"


/*  KBOverrideItem							*/
/*  KBOverrideItem Constructor for configuration dialog parameter item	*/
/*  listView	: QListView *	  : Parent list view			*/
/*  path	: const QString & : Linked component path		*/
/*  name	: const QString & : Targetconfiguration name		*/
/*  value	: const QString & : Default value			*/
/*  enabled	: bool		  : Item is enabled			*/
/*  embed	: QWidget *	  : Widget into which to embed		*/
/*  (returns)	: KBOverrideItem  :					*/

KBOverrideItem::KBOverrideItem
	(	QListView	*listView,
		KBObject	*parent,
		const QString	&path,
		const QString	&attrib,
		const QString	&value,
		bool		enabled,
		QWidget		*embed
	)
	:
	QListViewItem
	(	listView,
		path,
		attrib,
		value,
		enabled ? TR("Yes") : TR("No")
	)
{
	KBObject *obj		;

	m_attr	   = 0		;
	m_attrDlg  = 0		;
	m_value	   = value	;
	m_enabled  = enabled	;

	if ((obj = parent->getNamedObject(path, false)) == 0)
		return	;

	if ((m_attr = obj->getAttr(attrib)) == 0)
		return	;

	static	QDict<KBAttrItem> dummy  ;
	if ((m_attrDlg  = m_attr->getAttrDlg (embed, 0, dummy)) != 0)
	{
		_KBDialog::setupLayout	(m_attrDlg, -1, -1) ;
		m_attrDlg->init		(m_value) ;
	}

	update	()	;
}

/*  KBOverrideItem							*/
/*  KBOverrideItem~: Destructor for parameter dialog parameter item	*/
/*  (returns)	:		:					*/

KBOverrideItem::~KBOverrideItem ()
{
}

void	KBOverrideItem::update ()
{
	if (m_attr != 0)
		setText (2, m_attr->displayValue(m_value)) ;
	else	setText (2, m_value) ;

	setText (3, m_enabled ? TR("Yes") : TR("No")) ;
}


/*  KBOverrideItem							*/
/*  save	: Save updated value					*/
/*  textEdit	: QTextEdit &	: Used when no special dialog		*/
/*  (returns)	: void		:					*/

void	KBOverrideItem::save
	(	QTextEdit	&textEdit
	)
{
	if (m_attrDlg != 0)
	{	m_attrDlg->verify() ;
		m_value = m_attrDlg->value() ;
	}
	else	m_value = textEdit.text() ;

	update	() ;
}

/*  KBOverrideItem							*/
/*  setValue	: Set to specified value				*/
/*  value	: const QString & : Specified value			*/
/*  (returns)	: void		  :					*/

void	KBOverrideItem::setValue
	(	const QString	&value
	)
{
	m_value	= value	;
	if (m_attrDlg != 0) m_attrDlg->init (m_value) ;
	update	()	;
}

void	KBOverrideItem::setEnabled
	(	bool		e
	)
{
	m_enabled = e	;
	update ()	;
}

/*  KBOverrideItem								*/
/*  getOverride	: Get override object					*/
/*  node	: KBNode *	: Parent node				*/
/*  ident	: uint		: Identifier value			*/
/*  (returns)	: KBOverride *	:					*/

KBOverride
	*KBOverrideItem::getOverride
	(	KBNode		*node,
		uint		ident
	)
{
	return	new KBOverride
		(	node,
			QString("%1.%2").arg(time(0)).arg(ident),
			text(0),
			text(1),
			m_value,
			m_enabled
		)	;
}


/*  ------------------------------------------------------------------  */

/*  KBOverrideDlg								*/
/*  KBOverrideDlg							*/
/*		: Constructor for override object dialog		*/
/*  parent	: QWidget *	: Parent widget				*/
/*  object	: KBObject *	: Owning object				*/
/*  (returns)	: KBOverrideDlg	:					*/

KBOverrideDlg::KBOverrideDlg
	(	QWidget		*parent,
		KBObject	*object
	)
	:
	QWidget		(parent),
	m_object	(object),
	m_stack		(this),
//	m_bAdd		(this),
//	m_bRemove	(this),
	m_bEdit		(this),
	m_bSave		(this),
	m_bCancel	(this),
	m_bToggle	(this),
	m_lvOverride	(&m_stack),
	m_textEdit	(&m_stack)
{
//	m_bAdd	   .setText    (TR("Add"      )) ;
//	m_bRemove  .setText    (TR("Remove"   )) ;
	m_bSave	   .setText    (TR("Save"     )) ;
	m_bEdit	   .setText    (TR("Edit"     )) ;
	m_bCancel  .setText    (TR("Cancel"   )) ;

#if	__KB_EMBEDDED
	m_lvOverride.addColumn (TR("Path"     ),  90) ;
	m_lvOverride.addColumn (TR("Property" ),  50) ;
	m_lvOverride.addColumn (TR("Value"    ),  90) ;
	m_lvOverride.addColumn (TR("On"       ),  20) ;
#else
	m_lvOverride.addColumn (TR("Path"     ), 150) ;
	m_lvOverride.addColumn (TR("Property" ),  80) ;
	m_lvOverride.addColumn (TR("Value"    ), 200) ;
	m_lvOverride.addColumn (TR("Enabled"  ),  60) ;
#endif
	QHBoxLayout	*layMain = new QHBoxLayout (this   ) ;
	layMain->addWidget (&m_stack,1) ;
	QVBoxLayout	*layButt = new QVBoxLayout (layMain) ;

//	layButt->addWidget (&m_bAdd   ) ;
	layButt->addWidget (&m_bEdit  ) ;
	layButt->addWidget (&m_bSave  ) ;
//	layButt->addWidget (&m_bRemove) ;
	layButt->addWidget (&m_bCancel) ;
	layButt->addWidget (&m_bToggle) ;
	layButt->addStretch()		;

	m_stack.raiseWidget(&m_lvOverride) ;

	_KBDialog::setupLayout (this, -1, 0)  ;

//	connect	(&m_bAdd,	SIGNAL(clicked()), SLOT(clickAdd   ())) ;
//	connect	(&m_bRemove,	SIGNAL(clicked()), SLOT(clickRemove())) ;
	connect	(&m_bEdit,	SIGNAL(clicked()), SLOT(clickEdit  ())) ;
	connect	(&m_bSave,	SIGNAL(clicked()), SLOT(clickSave  ())) ;
	connect	(&m_bCancel,	SIGNAL(clicked()), SLOT(clickCancel())) ;
	connect	(&m_bToggle,	SIGNAL(clicked()), SLOT(clickToggle())) ;

	connect (&m_lvOverride,	SIGNAL(selectionChanged(QListViewItem *)),
				SLOT  (selectionChanged(QListViewItem *))) ;

	connect (&m_lvOverride,	SIGNAL(doubleClicked   (QListViewItem *)),
				SLOT  (clickEdit       ())) ;
	connect (&m_lvOverride,	SIGNAL(returnPressed   (QListViewItem *)),
				SLOT  (clickEdit       ())) ;

	m_curItem	= 0	;
	m_editItem	= 0	;
	m_adding	= false	;
	m_attrDlg	= 0	;

	TITER
	(	Override,
		m_object->getChildren(),
		o,

		new KBOverrideItem
		(	&m_lvOverride,
			m_object,
			o->path   (),
			o->attrib (),
			o->value  (),
			o->enabled(),
			&m_stack
		)	;
	)

//	m_bRemove.setEnabled (false) ;
	m_bEdit  .setEnabled (false) ;
	m_bSave  .setEnabled (false) ;
	m_bCancel.setEnabled (false) ;
	m_bToggle.setEnabled (false) ;
}


/*  KBOverrideDlg							*/
/*  ~KBOverrideDlg							*/
/*		: Destructor for override object dialog			*/
/*  (returns)	:		:					*/

KBOverrideDlg::~KBOverrideDlg ()
{
	DELOBJ	(m_editItem)	;
}


void	KBOverrideDlg::startUp ()
{
	clickCancel () ;
	m_stack.raiseWidget(&m_lvOverride) ;
}

/*  KBOverrideDlg							*/
/*  getText	: Get text to display in properties dialog		*/
/*  (returns)	: QString	: Text					*/

QString	KBOverrideDlg::getText ()
{
	QString		res	;
	KBOverrideItem	*item	= (KBOverrideItem *)m_lvOverride.firstChild() ;

	while (item != 0)
	{
		if (!res.isEmpty()) res += ", " ;

		res += item->path () + ":" + item->attrib () ;
		item = (KBOverrideItem *)item->nextSibling() ;
	}

	if (m_editItem != 0)
	{
		if (!res.isEmpty()) res += ", " ;
		res += m_editItem->path() + ":" + m_editItem->attrib() ;
	}

	return	res	;
}

/*  KBOverrideDlg							*/
/*  fixUp	: Fix up on acceptance					*/
/*  (returns)	: void		:					*/

void	KBOverrideDlg::fixUp ()
{
	fprintf
	(	stderr,
		"KBOverrideDlg::fixUp: called ....\n"
	)	;

	saveCurrent () ;

	QList<KBOverride>   old	 ;
	old.setAutoDelete (true) ;

	TITER
	(	Override,
		m_object->getChildren(),
		o,
		old.append(o)
	)

	old.clear () ;

	QListViewItem	*item	= m_lvOverride.firstChild() ;
	uint		ident	= 0x000ffffff & (uint)(void *)item ;

	while (item != 0)
	{
		((KBOverrideItem *)item)->getOverride (m_object, ident) ;
		item   = item->nextSibling()  ;
		ident += 1 ;
	}
}

/*  KBOverrideDlg							*/
/*  getAttrDlg	: Get specialised attribute dialog, if any		*/
/*  over	: KBOverrideItem * : Item to be edited			*/
/*  (returns)	: DlgRC		   : Result				*/

KBOverrideDlg::DlgRC
	KBOverrideDlg::getAttrDlg
	(	KBOverrideItem	*over
	)
{
	/* See if the item to be edited provides a specialised dialog	*/
	/* in which case use that.					*/
	if ((m_attrDlg = over->getAttrDlg()) != 0)
	{
		m_stack.raiseWidget (m_attrDlg) ;
		return	Dialog	;
	}

	/* Next check for special cases that are handled via assorted	*/
	/* modal dialogs.						*/
	QString	attrib	= over->attrib() ;

	if ((attrib == "fgcolor") || (attrib == "bgcolor"))
	{
		TKColorDialog cDialog (this, TR("Colour"), true) ;
		cDialog.setColor (QColor (strtol(over->value(), 0, 0))) ;

		if (cDialog.exec ())
		{
			QString	rv ;
			rv.sprintf ("0x%06x", cDialog.color().rgb() & 0x00ffffff) ;
			over->setValue (rv) ;
			return	SyncOK	;
		}

		return	SyncFail ;
	}

	if (attrib == "font")
	{
		TKFontDialog  fDialog (this, TR("Font"), false, true) ;
		fDialog.setFont (KBFont::specToFont (over->value())) ;

		if (fDialog.exec())
		{
			over->setValue (KBFont::fontToSpec (fDialog.font())) ;
			return	SyncOK ;
		}

		return	SyncFail ;
	}

	/* No dialog available so return. The called will use the	*/
	/* default text editor dialog instead.				*/
	return	None	;
}

/*  KBOverrideDlg							*/
/*  saveCurrent	: Save currently edited item if any			*/
/*  (returns)	: void		:					*/

void	KBOverrideDlg::saveCurrent ()
{
	if (m_editItem != 0)
	{
		m_editItem->save	(m_textEdit) ;
		m_editItem = 0		;
		m_adding   = false	;
	}
}

/*  KBOverrideDlg							*/
/*  clickSave	: User clicks save button				*/
/*  (returns)	: void		:					*/

void	KBOverrideDlg::clickSave ()
{
	if (m_editItem != 0)
	{
		m_curItem = m_editItem	;
		m_lvOverride.setCurrentItem (m_curItem) ;
		m_curItem->setEnabled (true) ;

		saveCurrent ()	;
	}

	clickCancel ()	;
}

/*  KBOverrideDlg							*/
/*  clickAdd	: User clicks add button				*/
/*  (returns)	: void		:					*/

// void	KBOverrideDlg::clickAdd ()
// {
// 	if (m_editItem != 0)
// 	{
// 		m_curItem = m_editItem	;
// 		m_lvOverride.setCurrentItem (m_curItem) ;
// 		m_curItem->setEnabled (true) ;
// 
// 		saveCurrent ()	;
// 		clickCancel ()	;
// 		return		;
// 	}
// 
// 	KBConfigFindDlg	cfDlg
// 			(	m_object,
// 				m_object,
// 				QString::null
// 			)	;
// 
// 	if (!cfDlg.exec ()) return ;
// 
// 	QString	 path	;
// 	QString	 attrib	;
// 	KBObject *obj	= cfDlg.selectedConfig (path, attrib) ;
// 	if (obj  == 0) return ;
// 
// //	fprintf
// //	(	stderr,
// //		"KBOverrideDlg::clickAdd: add [%s] [%s]\n",
// //		(cchar *)path,
// //		(cchar *)attrib
// //	)	;
// 
// 	m_adding   = true ;
// 	m_editItem = new KBOverrideItem
// 			 (	&m_lvOverride,
// 			 	m_object,
// 				path,
// 				attrib,
// 				QString::null,
// 				true,
// 				&m_stack
// 			 )	;
// 
// 	switch (getAttrDlg (m_editItem))
// 	{
// 		case Dialog	:
// 			break	;
// 
// 		case SyncOK	:
// 			return	;
// 
// 		case SyncFail	:
// 			DELOBJ	(m_editItem) ;
// 			return	;
// 
// 		default		:
// 			m_textEdit.clear     ()	;
// 			m_stack.raiseWidget  (&m_textEdit) ;
// 			break	;
// 	}
// 
//	m_bAdd   .setText    (TR("Save")) ;
// 	m_bCancel.setEnabled (true ) ;
// 	m_bEdit  .setEnabled (false) ;
//	m_bRemove.setEnabled (false) ;
// 	m_bToggle.setEnabled (false) ;
// }

/*  KBOverrideDlg							*/
/*  clickRemove	: User clicks remove button				*/
/*  (returns)	: void		:					*/

// void	KBOverrideDlg::clickRemove ()
// {
// 	DELOBJ (m_curItem) ;
// 	m_bEdit  .setEnabled (false) ;
// 	m_bRemove.setEnabled (false) ;
// 	m_bToggle.setEnabled (false) ;
// }

/*  KBOverrideDlg							*/
/*  clickCancel	: User clicks canel button				*/
/*  (returns)	: void		:					*/

void	KBOverrideDlg::clickCancel ()
{
	if (m_editItem != 0)
	{	if (m_adding) delete m_editItem ;
		m_editItem = 0 ;
	}

//	m_bAdd   .setText    (TR("Add")) ;
	m_bCancel.setEnabled (false) ;
	m_bEdit  .setEnabled (m_curItem != 0) ;
	m_bSave  .setEnabled (false) ;
//	m_bRemove.setEnabled (true ) ;

	m_stack  .raiseWidget(&m_lvOverride) ;
}

/*  KBOverrideDlg								*/
/*  clickEdit	: User clicks edit button				*/
/*  (returns)	: void		:					*/

void	KBOverrideDlg::clickEdit ()
{
	if (m_curItem == 0)
		return ;

	switch (getAttrDlg (m_curItem))
	{
		case Dialog	:
			break	;

		case SyncOK	:
			m_curItem->setEnabled (true) ;
			return	;

		case SyncFail	:
			return	;

		default	:
			m_textEdit.setText     (m_curItem->value()) ;
			m_stack.raiseWidget    (&m_textEdit) ;
			break	;
	}

	m_adding    = false	;
	m_editItem  = m_curItem	;
	m_curItem   = 0		;

//	m_bAdd   .setText    (TR("Save")) ;
	m_bCancel.setEnabled (true ) ;
	m_bEdit  .setEnabled (false) ;
	m_bSave  .setEnabled (true ) ;
//	m_bRemove.setEnabled (false) ;
}

void	KBOverrideDlg::clickToggle ()
{
	if (m_curItem != 0)
	{
		m_curItem->setEnabled (!m_curItem->enabled()) ;
		m_bToggle .setText    ( m_curItem->enabled()  ? TR("Disable") : TR("Enable")) ;
	}
}

/*  KBOverrideDlg							*/
/*  selectionChanged							*/
/*		: Current item selection changes			*/
/*  item	: QListViewItem * : Newly selected item			*/
/*  (returns)	: void		  :					*/

void	KBOverrideDlg::selectionChanged
	(	QListViewItem	*item
	)
{
	m_curItem = (KBOverrideItem *)item ;
//	m_bRemove .setEnabled  (item != 0) ;
	m_bEdit   .setEnabled  (item != 0) ;
	m_bToggle .setEnabled  (item != 0) ;
	if (item != 0)
		m_bToggle.setText (m_curItem->enabled() ? TR("Disable") : TR("Enable")) ;
}
