/***************************************************************************
    file	         : kb_helper.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<qstringlist.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"

#ifndef 	_WIN32
#include 	"kb_helper.moc"
#else
#include 	"kb_helper.h"
#endif

#include	"kb_formatdlg.h"


static	KBHelperReg	*helperList	;
static	QStringList 	helperSet	;

/*  getHelperSet: Get set of available helpers				*/
/*  (returns)	: const QStringList & : List of helpers			*/

QStringList	&getHelperSet()
{
	return	helperSet	;
}

/*  ------------------------------------------------------------------  */

/*  KBHelperReg								*/
/*  KBHelperReg	: Helper registration class				*/
/*  helperName	: cchar *	: Helper name				*/
/*  helperFN	: MKHELPER	: Helper creation function		*/
/*  (returns)	: KBHelperReg	:					*/

KBHelperReg::KBHelperReg
	(	cchar		*helperName,
		MKHELPER	helperFN
	)
	:
	helperName	(helperName),
	helperFN	(helperFN)
{
	next		= helperList	;
	helperList	= this		;

	if (helperName[0] != '_') helperSet.append (helperName) ;
}

bool	KBHelperReg::helperExists
	(	const QString	&helper
	)
{
	for (uint idx = 0 ; idx < helperSet.count() ; idx += 1)
		if (helper == helperSet[idx])
			return	true	;

	return	helper[0] == '_'	;
}

/*  ------------------------------------------------------------------  */

/*  KBFormatHelper							*/
/*  KBFormatHelper: Constructor for helper for field formats		*/
/*  parent	  : QWidget *	   	: Parent widget			*/
/*  dbInfo	  : const KBLocation &	: Owning document location	*/
/*  (returns)	  : KBFormatHelper 	:				*/

KBFormatHelper::KBFormatHelper
	(	QWidget			*parent,
		const KBLocation	&
	)
	:
	KBFormatDlg  (parent),
	KBHelperBase (this)
{
}

/*  KBFormatHelper							*/
/*  setValue	: Set initial format value				*/
/*  value	: const QString & : The value				*/
/*  (returns)	: void		  :					*/

void	KBFormatHelper::setValue
	(	const QString	&value
	)
{
	showFormats (value, KB::ITUnknown) ;
}

/*  KBFormatHelper							*/
/*  getValue	: Get the current format value				*/
/*  (returns)	: QString	: Format				*/

QString	KBFormatHelper::getValue ()
{
	return	KBFormatDlg::getValue () ;
}



static	KBHelperBase	*makeFormatHelper
	(	QWidget			*parent,
		const KBLocation	&location
	)
{
	return	new	KBFormatHelper (parent, location) ;
}

static	KBHelperReg	_mkFormatHelper	("format",	&makeFormatHelper) ;


/*  ------------------------------------------------------------------  */

#if	__KB_KDE

/*  KBDateHelper							*/
/*  KBDateHelper: Constructor for helper for dates			*/
/*  parent	: QWidget *    		: Parent widget			*/
/*  dbInfo	: const KBLocation &	: Owning document location	*/
/*  (returns)	: KBDateHelper 		:				*/

KBDateHelper::KBDateHelper
	(	QWidget			*parent,
		const KBLocation	&
	)
	:
	KDatePicker  (parent),
	KBHelperBase (this)
{
}

/*  KBDateHelper							*/
/*  setValue	: Set initial date value				*/
/*  value	: const QString & : The value				*/
/*  (returns)	: void		  :					*/

void	KBDateHelper::setValue
	(	const QString	&value
	)
{
	setDate (KBDateTime(value).getDate()) ;
}

/*  KBDateHelper							*/
/*  getValue	: Get the current format value				*/
/*  (returns)	: QString	: Format				*/

QString	KBDateHelper::getValue ()
{
	return	getDate().toString() ;
}

static	KBHelperBase	*makeDateHelper
	(	QWidget			*parent,
		const KBLocation	&location
	)
{
	return	new	KBDateHelper   (parent, location) ;
}

static	KBHelperReg	_mkDateHelper	("date",	&makeDateHelper  ) ;

#endif	// __KB_KDE


/*  ------------------------------------------------------------------  */
/*  KBHelperDlg								*/
/*  KBHelperDlg	: Constructor for helper dialog				*/
/*  helper	: const QString & 	: Required helper		*/
/*  dbInfo	: const KBLocation &	: Owning document location	*/
/*  (returns)	: KBHelperDlg	  	:				*/

KBHelperDlg::KBHelperDlg
	(	const QString		&helper,
		const KBLocation	&location
	)
	:
	_KBDialog  ("Helper", true),
	topLayout  (this),
	butLayout  (&topLayout),
	bOK	   (this),
	bCancel	   (this)
{
	dialog	=  0	;

	for (KBHelperReg *reg = helperList ; reg != 0 ; reg = reg->next)
		if (helper == reg->helperName)
		{	dialog	= (reg->helperFN) (this, location) ;
			break	;
		}

	if (dialog == 0)
	{	KBError::EError
		(	QString(TR("Helper %1 not known")).arg(helper),
			QString::null,
			__ERRLOCN
		)	;
		return	;
	}

	topLayout.setDirection (QBoxLayout::BottomToTop) ;
	topLayout.setMargin    (5) ;

	topLayout.addWidget    (dialog->widget()) ;
	butLayout.addStretch   ()	  ;
	butLayout.addWidget    (&bOK    ) ;
	butLayout.addWidget    (&bCancel) ;
	bOK	 .setText      ("OK"	) ;
	bCancel  .setText      ("Cancel") ;

	connect (&bOK,	     SIGNAL(clicked  ()),    this, SLOT(clickOK    ()   )) ;
	connect (&bCancel,   SIGNAL(clicked  ()),    this, SLOT(clickCancel()   )) ;
}

/*  KBHelperDlg								*/
/*  ~KBHelperDlg: Destructor for helper dialog				*/
/*  (returns)	:		:					*/

KBHelperDlg::~KBHelperDlg ()
{
	DELOBJ	(dialog) ;
}

/*  KBHelperDlg								*/
/*  clickOK	: OK button clicked					*/
/*  (returns)	: void		:					*/

void	KBHelperDlg::clickOK ()
{
	done	(true) ;
}

/*  KBHelperDlg								*/
/*  clickCancel	: Cancel button clicked					*/
/*  (returns)	: void		:					*/

void	KBHelperDlg::clickCancel ()
{
	done	(false) ;
}


/*  KBHelperDlg								*/
/*  run		: Create and run helper					*/
/*  helper	: const QString & : Helper name				*/
/*  initval	: const QString & : Initial (ie., current) value	*/
/*  dbInfo	: KBDBInfo *	  : Database connection information	*/
/*  (returns)	: QString	  : New value or QString::null		*/

QString	KBHelperDlg::run
	(	const QString		&helper,
		const QString		&initval,
		const KBLocation	&location
	)
{
	KBHelperDlg hDialog (helper, location) ;
	hDialog.setValue    (initval) ;
 
	if (hDialog.exec ()) return hDialog.getValue() ;

	return	 QString::null ;
}
