/***************************************************************************
    file	         : kb_gui.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef  _KB_GUI_H
#define  _KB_GUI_H


#include	<qdict.h>
#include	<qdom.h>

#include	"libkbase_exports.h"
#include	"tk_action.h"

#if	__KB_KDE

#include	<kapp.h>
#include	<kstdaccel.h>
#include	<kxmlguiclient.h>

typedef	KStdAccel::StdAccel	GUIAccel	;
#define	ACCEL(x)		KStdAccel::x
#define	NoAccel			AccelNone

#endif
#if	__KB_TKC

typedef	TKStdAccel::StdAccel	GUIAccel	;
#define	ACCEL(x)		TKStdAccel::x

#endif



/*  GUIElement								*/
/*  ----------								*/
/*  This structure contains information for a specific menu or toolbar	*/
/*  GUI element, and is fed to a KAction constructor on demand to	*/
/*  create an action for a particular GUI.				*/

enum GType
{
	GTAction,
	GTToggle,
	GTCoded,
	GTNone
}	;

struct	LIBKBASE_API	GUIElement
{
	GType		m_gtype		;	/* GUI action type	*/
	int		m_ggroup	;	/* GUI action group	*/
	bool		m_enable	;	/* Initial enable state	*/
	const char	*m_text		;	/* Menu text		*/
	const char	*m_icon		;	/* Menu/toolbar icon	*/
	GUIAccel	m_accel		;	/* Accelerator key	*/
	const char	*m_slot		;	/* Slot to attatch to	*/
	const char	*m_name		;	/* GUI element name	*/
	uint		m_code		;	/* Operation code	*/
	const char	*m_tip		;	/* Tool tip		*/
}	;


/*  KBaseGUI								*/
/*  --------								*/
/*  This class encapsulates a particular menu/toolbar GUI. KBase uses	*/
/*  an instance of this for each MDI child, eg., there is a different	*/
/*  GUI for form data view and form design view.			*/

class	LIBKBASE_API KBaseGUI : public QObject
{
	QDict<TKAction>	m_actions   	;	/* Instantiated actions	*/
	const QObject	*m_receiver 	;	/* Signal receiver	*/
	QString		m_guiName   	;	/* Name of the GUI	*/
	bool		m_hasStatusBar	;	/* Show status bar	*/
#if	__KB_KDE
	KXMLGUIClient	*m_proxy	;	/* Proxy client		*/
#endif

	TKAction	*makeAction	(const GUIElement    *) ;

public	:

	KBaseGUI (QObject *, const QObject *, const QString  &) ;

	virtual~KBaseGUI () ;

	inline	const QString	&getXMLFile  ()
	{
		return	m_guiName	;
	}

	inline	bool	hasStatusBar ()
	{
		return	m_hasStatusBar	;
	}
	inline	void	setStatusBar
		(	bool	has
		)
	{
		m_hasStatusBar = has	;
	}

	TKAction	*getAction	(const QString       &) ;
	TKAction	*getAction	(const QDomElement   &, const GUIElement * = 0) ;

	void		addAction	(const QString &, TKAction *) ;

	void		setChecked	(const QString &, bool) ;
	void		setEnabled	(const QString &, bool) ;
	void		setEnabled	(KB::GGroup,	  bool) ;

	static	void	setAllChecked	(const QString &, bool) ;
	static	void	setAllEnabled	(const QString &, bool) ;
	static	void	setAllEnabled	(KB::GGroup,	  bool) ;
}	;

#endif // _KB_GUI_H
