/***************************************************************************
    file	         : kb_formcopier.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdarg.h>

#include	<qlist.h>
#include	<qdict.h>
#include	<qevent.h>
#include	<qwidget.h>


#include	"kb_classes.h"
#include	"kb_node.h"
#include	"kb_gui.h"
#include	"kb_formcopier.h"



static	QString	typeToString
	(	KB::ObjType	type
	)
{
	switch (type)
	{
		case KB::ObjForm   :
			return	TR("form")	;

		case KB::ObjReport :
			return	TR("report")	;

		default	:
			break	;
	}

	return	TR("unknown")	;
}

/*  KBFormCopier							*/
/*  clearCopy	: Clear the copied node list				*/
/*  (returns)	: void		:					*/

void	KBFormCopier::clearCopy ()
{
	m_copied.clear () ;
	m_type = KB::ObjUnknown ;

	KBaseGUI::setAllEnabled ("KB_pasteObjects", false) ;
}

/*  KBFormCopier							*/
/*  addToCopy	: Add a node to the copied list				*/
/*  node	: KBNode *	: Node in question			*/
/*  type	: KB::ObjType	: Node type				*/
/*  (returns)	: void		:					*/

void	KBFormCopier::addToCopy
	(	KBNode		*node,
		KB::ObjType	type
	)
{
	if (node != 0)
	{
		if (type != m_type)
		{
			m_copied.clear ();
			m_type	= type	 ;
		}

		m_copied.append   (node) ;
		KBaseGUI::setAllEnabled ("KB_pasteObjects", true) ;
	}
}

/*  KBFormCopier							*/
/*  getCopied	: Get the copy list					*/
/*  type	: KB::ObjType	: Node type				*/
/*  (returns)	: QList<KBNode> & : List of copied stuff		*/

QList<KBNode>
	&KBFormCopier::getCopied
	(	KB::ObjType	type
	)
{
	static	QList<KBNode>	empty	;

	if (m_type != type)
	{
		KBError::EWarning
		(	QString	(TR("Cannot copy %1 objects into %2"))
				.arg(typeToString(m_type))
				.arg(typeToString(type  )),
			QString::null,
			__ERRLOCN
		)	;

		return	empty	;
	}

	return	m_copied	;
}

/*  KBFormCopier							*/
/*  anyCopied	: See if there are any copied nodes			*/
/*  node	: KBNode *&	: Return if there is a single node	*/
/*  (returns)	: bool		: Copied nodes				*/
bool	KBFormCopier::anyCopied
	(	KBNode		*&node
	)
{
	node	= m_copied.count() == 1 ? m_copied.at(0) : 0 ;
	return	m_copied.count() > 0  ;
}


KBFormCopier *KBFormCopier::self ()
{
	static	KBFormCopier *kbFormCopier = 0 ;
	if (kbFormCopier == 0) kbFormCopier = new KBFormCopier () ;
	return	kbFormCopier ;
}
