/***************************************************************************
    file	         : kb_form.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/



#ifndef		_WIN32
#include	"kb_form.moc"
#else
#include	"kb_form.h"
#endif

#include	"kb_framer.h"
#include	"kb_blockevents.h"
#include	"kb_script.h"
#include	"kb_import.h"
#include	"kb_param.h"
#include	"kb_display.h"
#include	"kb_popupmenu.h"
#include	"kb_sizer.h"
#include	"kb_ctrl.h"


/*  KBForm								*/
/*  KBForm	: Constructor for form root class for extant form	*/
/*  location	: KBLocation &	 : Form location			*/
/*  aList	: const QDict<QString> &				*/
/*				 : List of attributes			*/
/*  (returns)	: KBForm	 :					*/

KBForm::KBForm
	(	KBLocation		&location,
		const QDict<QString>	&aList
	)
	:
	KBFormBlock	(0,     aList, "KBForm"),
	KBLayout	(this),
	KBPlayer	("form", getElement(), 0, this),
	m_language	(this,  "language",	  		aList),
	m_caption	(this,  "caption",   			aList),
	m_stretch	(this,  "stretch",			aList),
	m_modal		(this,  "modal",			aList),
	m_hideBars	(this,  "hidebars",			aList),
	m_hasStatusBar	(this,  "statusbar",			aList),
	m_onLoad	(this,  "onload",	 "onForm",	aList),
	m_onOpened	(this,  "onopened",	 "onForm",	aList),
	m_onUnload	(this,  "onunload",	 "onForm",	aList),
	m_onClose	(this,  "onclose",	 "onForm",	aList),
	m_docRoot	(this,  children, location)
{
	root		= this	;
	m_display	= 0	;
	m_formCurItem	= 0	;
	m_formCurQRow	= 0	;
	m_accel		= 0	;
}

#if	! __KB_RUNTIME
/*  KBForm								*/
/*  KBForm	: Constructor for form root class for new form		*/
/*  location	: KBLocation &	 : Form location			*/
/*  aList	: const QDict<QString> &				*/
/*				 : List of attributes			*/
/*  _ok		: bool &	 : Success				*/
/*  (returns)	: KBForm	 :					*/

KBForm::KBForm
	(	KBLocation		&location,
		const QDict<QString>	&aList,
		bool			&_ok
	)
	:
	KBFormBlock	(0,	  aList, "KBForm"),
	KBLayout	(this),
	KBPlayer	("form", getElement(), 0, this),
	m_language	(this,  "language",  			aList),
	m_caption	(this,  "caption",   			aList),
	m_stretch	(this,  "stretch",			aList),
	m_modal		(this,  "modal",			aList),
	m_hideBars	(this,  "hidebars",			aList),
	m_hasStatusBar	(this,	"statusbar",			aList),
	m_onLoad	(this,  "onload",	 "onForm",	aList),
	m_onOpened	(this,  "onopened",	 "onForm",	aList),
	m_onUnload	(this,  "onunload",	 "onForm",	aList),
	m_onClose	(this,  "onclose",	 "onForm",	aList),
	m_docRoot	(this,  children, location)
{
	root		= this	;
	m_display	= 0	;
	m_formCurItem	= 0	;
	m_formCurQRow	= 0	;
	m_accel		= 0	;

	if (!propertyDlg  (0))
	{	_ok	= false ;
		return	;
	}

	if (!blockPropDlg ( ))
	{	_ok	= false ;
		return	;
	}

	_ok	= true	;
	KBLayout::setChanged ()	;
}
#endif

/*  KBForm								*/
/*  ~KBForm	: Destructor for form root class			*/
/*  (returns)	:		:					*/

KBForm::~KBForm ()
{
	showMonitor ((QListView *)0) ;
}

/*  KBForm								*/
/*  moveFocusOK	: Query focus movement					*/
/*  item	: KBItem *	: Target item				*/
/*  qrow	: uint		: Query row				*/
/*  (returns)	: bool		: Focus allowed				*/

bool	KBForm::moveFocusOK
	(	KBItem	*item,
		uint	qrow
	)
{
//	fprintf
//	(	stderr,
//		"KBForm::moveFocusOK [%p][%p][%d]->[%p][%d]\n",
//		(void *)formCurItem,
//		(void *)item->getFormBlock()->getCurItem(),
//		formCurQRow,
//		(void *)item,
//		qrow
//	)	;

	/* If the item gaining focus is the current item and the same	*/
	/* row (for instance after a dialog box has been displayed)	*/
	/* then there are no problems.					*/
	if ((item == m_formCurItem) && (qrow == m_formCurQRow))
		return	true  ;

	/* If there is no current item then again no problems.		*/
	if (m_formCurItem == 0)
		return	true  ;

	/* Control is moving out of an item, so we need to check that	*/
	/* this is OK. Call the block which owns the item to verify	*/
	/* this.							*/
	KBFormBlock *cBlk = m_formCurItem->getFormBlock() ;
	KBFormBlock *nBlk = item         ->getFormBlock() ;

	if (!cBlk->focusOutOK ((qrow != m_formCurQRow) || (nBlk != cBlk)))
		return	false  ;

	m_formCurItem = 0 ;
	m_formCurQRow = 0 ;
	setUnMorphedItem(0, 0) ;
	if (nBlk != cBlk) nBlk->enterBlock(false, 0) ;

	return	true	;
}

/*  KBForm								*/
/*  focusInEvent: Note new item focus					*/
/*  item	: KBItem *	: Item which has gained focus		*/
/*  qrow	: uint		: Query row number			*/
/*  (return)	: void		:					*/

void	KBForm::focusInEvent
	(	KBItem	*item,
		uint	qrow
	)
{
//	fprintf
//	(	stderr,
//		"KBForm::focusInEvent: [%s][%d]\n",
//		(cchar *)item->getName(),
//		qrow
//	)	;

	if ((m_formCurItem != 0) && (m_formCurItem->getBlock() != item->getBlock()))
		m_formCurItem->getBlock()->setCurrent(false) ;

	bool	delta	= (m_formCurItem != item) || (m_formCurQRow != qrow) ;

//	fprintf
//	(	stderr,
//		"KBForm::focusInEvent: now at [%s][%s][%d]\n",
//		(cchar *)item->getElement(),
//		(cchar *)item->getName(),
//		qrow
//	)	;

	m_formCurItem	= item	;
	m_formCurQRow	= qrow	;

	item->getBlock()->setCurrent(true) ;

	if (delta) item->doEnter (m_formCurQRow) ;
}


/*  KBForm								*/
/*  printNode	: Output node XML					*/
/*  text	: QString &	: Resulting text			*/
/*  indent	: int		: Indent level of this node		*/
/*  (returns)	: void		:					*/

void	KBForm::printNode
	(	QString	&text,
		int	indent
	)
{
	/* Implement this specially, since we need to output the XML	*/
	/* header. Also output script stuff and paramaters near the	*/
	/* front.							*/
	extern	QString	kbXMLEncoding  () ;
	QString		nodeText ;

	text	+= QString
		   (	"<?xml version=\"1.0\" encoding=\"%1\"?>\n"
			"<!DOCTYPE KBaseForm SYSTEM \"kbaseform.dtd\">\n"
		   )
		   .arg	(kbXMLEncoding()) ;

	text	+= QString("%1<%2").arg("", indent).arg(getElement()) ;
	for (uint idx = 0 ; idx < attribs .count () ; idx += 1)
		attribs.at(idx)->printAttr(text, nodeText, indent + 2) ;
	text	+= ">\n" ;

	CITER	(Script, s, s->printNode (text, indent+2))
	CITER	(Param,  p, p->printNode (text, indent+2))

	LITER
	(	KBNode,
		KBNode::children,
		child,
		{
			if (child->isScript ()) continue ;
			if (child->isParam  ()) continue ;
			child->printNode (text, indent+2)  ;
		}
	)

	text	+= nodeText ;
	text	+= QString("%1</%2>\n").arg("", indent).arg(getElement()) ;
}


/*  KBForm								*/
/*  requery	: Rerun form queries					*/
/*  (returns)	: bool		  : Success				*/

bool	KBForm::requery ()
{
	uint	cdRow	= curDRow 	;
	uint	cqRow	= curQRow 	;

	if (!KBFormBlock::requery ()) return false ;
	if (!KBFormBlock::showData()) return false ;

	scrollToRow (cdRow) ;
	enterBlock  (true, cqRow ) ;

	KBValue	arg ((int)curQRow) ;
	KBValue	resval	;
	bool	evRc	;

	if (!eventHook (events->onCurrent, 1, &arg, evRc))
		return false ;

	/* Success .....						*/
	return	true	;
}

/*  KBForm								*/
/*  finish	: End form operation					*/
/*  (returns)	: void		:					*/

void	KBForm::finish ()
{
	KBValue	resval	;

	switch (m_onUnload.execute (resval, 0, 0))
	{
		case KB::ScriptInlineError :
			propertyDlg (m_onUnload.getName()) ;
			return	;

		case KB::ScriptGlobalError :
			return	;

		default	:
			break	;
	}

}

/*  KBForm								*/
/*  resize	: Handle resize in design mode				*/
/*  size	: QSize		: Raw size				*/
/*  (returns)	: void		:					*/

void	KBForm::resize
	(	QSize	size
	)
{
#if	! __KB_RUNTIME
	if (showingDesign())
	{
		KBObject::resize (size.width(), size.height ()) ;
		getDisplay ()->resize (size.width(), size.height()) ;
		KBLayout::setChanged () ;
	}
#endif
}

/*  KBForm								*/
/*  formAction	: Handle various query actions				*/
/*  action	: KBAction	: Action required			*/
/*  (returns)	: bool		: Success				*/

bool	KBForm::formAction
	(	KB::Action	action
	)
{
	/* This routine is called by the parent viewer in response to	*/
	/* or menu or toolbar request. With the exception of the Save	*/
	/* action. the action is passed to the block in which the	*/
	/* current item resides; if there is no such item then apply	*/
	/* the action to the top-level block.				*/
	KBFormBlock	*block	;

//	fprintf
//	(	stderr,
//		"KBForm::formAction: action=%d form=%p fci=%p blk=%p\n",
//		(int)action,
//		(void *)this,
//		(void *)m_formCurItem,
//		m_formCurItem == 0 ? 0 : (void *)m_formCurItem->getFormBlock()
//	)	;

	if ((action != KB::Save) && (m_formCurItem != 0))
		if ((block = m_formCurItem->getFormBlock()) != 0)
		{
			bool	rc = block->doAction
					(	action,
						m_formCurItem->getNavigator()->getTabList()
					)	;

			/* If there was an error and the action is	*/
			/* being applied to other than this block then	*/
			/* we need to propogate the error back here.	*/
			if (!rc && (block != this))
				setError (block->lastError()) ;

			return	rc ;
		}

	return	doAction (action) ;
}

/*  KBForm								*/
/*  showData	: Show form in data mode				*/
/*  parent	: QWidget *	  : Parent widget			*/
/*  pDict	: QDict<QString>& : Paramater dictionary		*/
/*  key		: const KBValue	& : Parent key				*/
/*  size	: QSize &	  : Return required size		*/
/*  (returns)	: KB::ShowRC	  : Startup return code			*/

KB::ShowRC
	KBForm::showData
	(	QWidget			*parent,
		const QDict<QString>	&pDict,
		const KBValue		&key,
		QSize			&size
	)
{
	/* In the event of any error while starting up, we switch to	*/
	/* design mode, and indicate this to the called via the return	*/
	/* code.							*/
	bool		ok	 ;
	KB::ShowRC	rc	 ;
	KBError		error	 ;
	KBValue		resval	 ;
	QScrollView	*scroller;
	bool		showProp = false ;

	m_parentKey	= key	 ;
	fprintf
	(	stderr,
		"KBForm::showData: key=[%s]\n",
		(cchar *)m_parentKey.getRawText()
	)	;

	/* Reset the document root object (which, for instance, clears	*/
	/* an extant scripting interface), then load any scripting for	*/
	/* the report.							*/
	m_docRoot.reset		()	    ;
	m_docRoot.loadScripting (ok, error) ;

	if (!ok)
	{	setError (error)   ;
		goto	 showError ;
	}

	/* We can now set the parameter dictionary (which may invoke	*/
	/* scripts for default values). This may return indicating an	*/
	/* error or that the user cancelled.				*/
	if ((rc = m_docRoot.setParamDict (pDict, error)) != KB::ShowRCOK)
	{
		if (rc == KB::ShowRCCancel)
			return	rc ;

		setError (error)   ;
		goto	 showError ;
	}


	/* Next run the block setup. This may pick up parameter values	*/
	/* that are now set.						*/
	if (!blockSetup ())
		goto	showError ;


	/* If this is the first time the form is displayed, create the	*/
	/* top-level display and build the form GUI.			*/
	if (m_display == 0)
	{
		m_display = new KBDisplay
			  (	parent,
				this,
				showbar.getFlags(),
				m_stretch.getBoolValue()
			  )	;

		buildTopDisplay (m_display) ;
		buildCtrls	(0, 0, 0)   ;
	}

	if (m_accel != 0)
	{
		m_accel  ->clear () ;
		m_accelMap.clear () ;
	}
	else
	{
		m_accel	= new QAccel (getDisplay()->getTopWidget()) ;

		connect
		(	m_accel,
			SIGNAL(activated  (int)),
			this,
			SLOT  (accelerator(int))
		)	;
	}

	if (!connectLinks (error))
	{
		setError (error)   ;
		goto	 showError ;
	}

	/* Initialize the layout object and set data mode. We can then	*/
	/* pick up the size required by the form			*/
#if	! __KB_RUNTIME
	KBLayout   ::clear      (false) ;
	KBLayout   ::initSizer  ()	;
#endif
	KBFormBlock::showAs 	(KB::ShowAsData) ;

	scroller = m_display->getScroller    () ;
	size	 = m_display->getSizeNeeded  (geometry().size()) ;
	scroller->resizeContents (size.width(), size.height()) ;


	/* Add all items in the form into the queries ...		*/
	if (!addAllItems())
	{
		setError
		(	KBError::Error,
			TR
			(	"Form contains blocks which retrieve no values"
			),
			TR
			(	"At least one field in each block should "
				"have a non-empty display expression"
			),
			__ERRLOCN
		)	;
		goto	showError ;
	}

	m_formCurItem	= 0 ;
	m_formCurQRow	= 0 ;

	/* Scripting is up and ready if required, and blocks know	*/
	/* what is going on, so start the form off by executing the	*/
	/* onLoad event, if any.					*/
	switch (m_onLoad.execute (resval, 0, 0))
	{
		case KB::ScriptInlineError :
			/* Inline execution error, so we will show the	*/
			/* appropriate property dialog and set an error	*/
			/* message.					*/
			setError
			(	KBError::Error,
				TR("Event execution error in inline script"),
				QString(TR("Event: %1")).arg(m_onLoad.getLegend()),
				__ERRLOCN
			)	;

			showProp = true ;
			goto showError  ;

		case KB::ScriptGlobalError :
			/* Error while executing a script. Set an error	*/
			/* message and return failure.			*/
			setError
			(	KBError::Error,
				TR("Script execution error in event"),
				QString(TR("Event: %1")).arg(m_onLoad.getLegend()),
				__ERRLOCN
			)	;
			goto showError  ;

		default	:
			break	;
	}

	/* Prepare all controls prior to displaying any data. This	*/
	/* will be used by links, for instance, to load their value	*/
	/* sets.							*/
	prepare () ;
	if (!requery ()) goto showError ;


	switch (m_onOpened.execute (resval, 0, 0))
	{
		case KB::ScriptInlineError :
			/* Inline execution error, so we will show the	*/
			/* appropriate property dialog and set an error	*/
			/* message.					*/
			setError
			(	KBError::Error,
				TR("Event execution error in inline script"),
				QString(TR("Event: %1")).arg(m_onOpened.getLegend()),
				__ERRLOCN
			)	;

			showProp = true ;
			goto showError  ;

		case KB::ScriptGlobalError :
			/* Error while executing a script. Set an error	*/
			/* message and return failure.			*/
			setError
			(	KBError::Error,
				TR("Script execution error in event"),
				QString(TR("Event: %1")).arg(m_onOpened.getLegend()),
				__ERRLOCN
			)	;
			goto showError  ;

		default	:
			break	;
	}

	return	KB::ShowRCData ;


	showError :

#if	! __KB_RUNTIME
		if (showDesign (parent, size) == KB::ShowRCDesign)
		{
			if (showProp)
				propertyDlg (m_onLoad.getName()) ;

			return	KB::ShowRCDesign  ;
		}
#endif
		return	KB::ShowRCError	  ;
}

#if	! __KB_RUNTIME

/*  KBForm								*/
/*  showPreview	: Show form preview					*/
/*  parent	: QWidget *	  : Parent widget			*/
/*  size	: QSize &	  : Return required size		*/
/*  (returns)	: KB::ShowRC	  : Startup return code			*/

KB::ShowRC
	KBForm::showPreview
	(	QWidget			*parent,
		QSize			&size
	)
{

	m_docRoot.reset	() ;

	if (!blockSetup ())
		return	KB::ShowRCError	;


	if (m_display == 0)
	{
		m_display = new KBDisplay
			  (	parent,
				this,
				showbar.getFlags    (),
				m_stretch.getBoolValue()
			  )	;

		buildTopDisplay (m_display) ;
		buildCtrls	(0, 0, 0) ;
	}


	KBLayout   ::clear      (false) ;
	KBLayout   ::initSizer  ()	;
	KBFormBlock::showAs 	(KB::ShowAsData) ;

	QScrollView	*scroller = m_display->getScroller  () ;

	size   = m_display->getSizeNeeded  (geometry().size()) ;
	scroller->resizeContents (size.width(), size.height()) ;

	m_formCurItem	= 0	;
	m_formCurQRow	= 0 	;
	return	KB::ShowRCData 	;
}


/*  KBForm								*/
/*  showDesign	: Show form in design mode				*/
/*  parent	: QWidget *	  : Parent widget			*/
/*  size	: QSize &	  : Return required size		*/
/*  (returns)	: KB::ShowRC	  : Startup return code			*/

KB::ShowRC
	KBForm::showDesign
	(	QWidget		*parent,
		QSize		&size
	)
{
	/* Start with the block setup. This links blocks to queries and	*/
	/* such. Any error here is a real problem.			*/
	if (!blockSetup ())
		return	KB::ShowRCError  ;

	/* If this is the first time the form is displayed, create the	*/
	/* top-level display and build the form GUI.			*/
	if (m_display == 0)
	{
		m_display = new KBDisplay
			  (	parent,
				this,
				showbar.getFlags(),
				m_stretch.getBoolValue()
			  )	;

		buildTopDisplay (m_display) ;
		buildCtrls      (0, 0, 0) ;
	}

	KBLayout   ::clear      (true)  ;
	KBLayout   ::initSizer  ()	;
	KBFormBlock::showAs 	(KB::ShowAsDesign) ;

	QScrollView *scroller = m_display->getScroller ()      ;
	size	= m_display->getSizeNeeded (geometry().size()) ;

	scroller->resizeContents (1600, 1600) ;
	size	+= QSize (100, 100) ;

	KBLayout::setChanged (false);
	return	KB::ShowRCDesign ;
}

/*  KBForm								*/
/*  makeFramerPopup							*/
/*		: Make popup menu for a framer				*/
/*  framer	: KBFramer *	    : Framer in question		*/
/*  bState	: QT::ButtonState & : Button state return location	*/
/*  (returns)	: KBPopupMenu *	    : Popup menu			*/

KBPopupMenu
	*KBForm::makeFramerPopup
	(	KBFramer	*framer,
		Qt::ButtonState	*bState
	)
{
	extern void 	makeFormMenu   (QPopupMenu *, QObject *, uint) ;

	KBPopupMenu	*newPopup = new KBPopupMenu (bState) ;
	KBPopupMenu	*blkPopup = new KBPopupMenu (bState) ;

	blkPopup->insertEntry     (false,    TR("&Menu Block" ), framer, SLOT(newNullBlock ())) ;
	blkPopup->insertEntry     (false,    TR("&Table Block"), framer, SLOT(newTableBlock())) ;
	blkPopup->insertEntry     (false,    TR("&Query Block"), framer, SLOT(newQueryBlock())) ;
	blkPopup->insertEntry     (false,    TR("&SQL Block"  ), framer, SLOT(newSQLBlock  ())) ;
	blkPopup->insertEntry     (false,    TR("&Container"),   framer, SLOT(newContainer ())) ;

	newPopup->insertItem      (TR("New B&lock"),   blkPopup) ;
	newPopup->insertSeparator () ;


	makeFormMenu   (newPopup, framer, KF_FRAMER|KF_STATIC|KF_DATA) ;

	newPopup->insertSeparator () ;
	newPopup->insertEntry     (false,  TR("Paste component"), framer, SLOT(pasteComponent())) ;
	newPopup->insertEntry     (false,  TR("Link component"),  framer, SLOT(linkComponent ())) ;

	return	newPopup ;
}

/*  KBForm								*/
/*  playerAdd	: Perform addition from a score				*/
/*  action	: const QString		: Action			*/
/*  args	: const QStringList &	: Arguemnts			*/
/*  pError	: KBError &		: Error return			*/
/*  (returns)	; bool			: Success			*/

bool	KBForm::playerAdd
	(	const QStringList	&args,
		KBError			&pError
	)
{
	if (args[1] == "KBImport")
	{
		KBAttrDict aDict;
		aDict.addValue ("module", args[2]) ;
		new KBImport   (this, aDict, 0) ;
		return	true	;
	}

	if (args[1] == "KBScript")
	{
		KBAttrDict aDict;
		aDict.addValue ("module", args[2]) ;
		new KBScript   (this, aDict, 0) ;
		return	true	;
	}

	return	KBFormBlock::playerAdd (args, pError) ;
}

/*  KBForm								*/
/*  playerPerform							*/
/*		: Perform a stanza from a score				*/
/*  action	: const QString		: Action			*/
/*  args	: const QStringList &	: Arguemnts			*/
/*  pError	: KBError &		: Error return			*/
/*  (returns)	; bool			: Success			*/

bool	KBForm::playerPerform
	(	const QString		&action,
		const QStringList	&args,
		KBError			&pError
	)
{
	if ((action == "pick") && showingDesign())
	{
		KBObject *object = getNamedObject (args[0], pError) ;
		if (object == 0) return false ;

		getLayout()->addSizer	(object->getSizer(), args[1].toInt()) ;

		return	true	;
	}

	if ((action == "properties") && showingDesign())
	{
		KBObject *object = getNamedObject (args[0], pError) ;
		if (object == 0) return false ;

		getLayout()->addSizer	(object->getSizer(), args[1].toInt()) ;
		object->propertyDlg	() ;

		return	true	;
	}

	if ((action == "add") && showingDesign ())
	{
		fprintf
		(	stderr,
			"KBObject::playerPerform/add: %s, %s\n",
			(cchar *)args[0],
			(cchar *)args[1]
		)	;

		KBObject    *object  = getNamedObject (args[0], pError) ;
		if (object == 0) return false ;

		if (object->isFormBlock() != 0)
			return	object->isFormBlock()->playerAdd (args, pError) ;

		if (object->isFramer   () != 0)
			return	object->isFramer   ()->playerAdd (args, pError) ;

		pError	= KBError
			  (	KBError::Error,
				"Attempt to add outside suitable object",
				QString	("%1: %2")
					.arg(object->getElement())
					.arg(object->getName   ()),
				__ERRLOCN
			  )	;
		return	false	;
	}

	return	KBPlayer::playerPerform (action, args, pError) ;
}

/*  KBForm								*/
/*  playerName	: Return player object name				*/
/*  (returns)	: QString	: Name					*/

QString	KBForm::playerName()
{
	return	getName	() ;
}

#endif

/*  KBForm								*/
/*  setFocusAtRow: Set focus row information for current block		*/
/*  block	 : KBFormBlock *: Block in question			*/
/*  (returns)	 : void		:					*/

void	KBForm::setFocusAtRow
	(	KBFormBlock		*block
	)
{
//	fprintf
//	(	stderr,
//		"KBForm::setFocusAtRow: fi=%d cr=%d nr=%d inq=%d\n",
//		block->firstItem () != 0,
//		block->getCurQRow(),
//		block->getNumRows(),
//		block->isInQuery ()
//	)	;

	emit	focusAtRow
		(	block->firstItem () != 0,
			block->getCurQRow(),
			block->getNumRows(),
			block->isInQuery ()
		)	;

}

/*  KBForm								*/
/*  objType	: Get object type for this node				*/
/*  (returns)	: KB::ObjType	: Object type				*/

KB::ObjType KBForm::objType ()
{
	return	KB::ObjForm	;
}

/*  KBForm								*/
/*  queryClose	: Query close						*/
/*  (returns)	: bool		: True to allow close			*/

bool	KBForm::queryClose ()
{
	/* Actually what this does is to execute the close event, if	*/
	/* any, and return the value from that.				*/
	if (!m_onClose.getValue().isEmpty())
	{
		bool	evRc 	;

		/* If the event itself throws an error then return true	*/
		/* otherwise it would be impossible to close a form	*/
		/* with a duff onClose event.				*/
		if (!eventHook (m_onClose, 0, 0, evRc)) return true ;

		return	evRc	;
	}

	return	true	;
}

/*  KBForm								*/
/*  getBlockVal	: Get block value pointer				*/
/*  (returns)	: KBValue *	: Value pointer or null at top level	*/

KBValue	*KBForm::getBlockVal ()
{
	if (!cexpr.getValue().isEmpty() && !m_parentKey.isNull())
	{
		fprintf
		(	stderr,
			"KBForm::getBlockVal: returns [%s]\n",
			(cchar *)m_parentKey.getRawText()
		)	;
		return	&m_parentKey ;
	}

	return	KBFormBlock::getBlockVal() ;
}

/*  KBFormBlock								*/
/*  focusInBlock: See if focus is in specified block			*/
/*  block	: KBBlock *	: Block in question			*/
/*  (returns)	: bool		: True if in block			*/

bool	KBForm::focusInBlock
	(	KBBlock		*block
	)
{
	return	(m_formCurItem != 0) && (m_formCurItem->getFormBlock() == block) ;
}

void	KBForm::addAccelerator
	(	const QKeySequence	&keySeq,
		KBItem			*item
	)
{
	if (m_accel != 0)
	{
		static	int	accelMapID ;

		accelMapID += 1	;
		m_accel->insertItem (keySeq, accelMapID) ;

		m_accelMap.insert (accelMapID, item) ;
	}
}

void	KBForm::accelerator
	(	int		id
	)
{
	KBItem	*item	= m_accelMap.find (id) ;
	if (item == 0)
	{
		fprintf
		(	stderr,
			"KBForm::accelerator: no mapping for id=%d\n",
			id
		)	;
		return	;
	}

	KBControl *ctrl = item->ctrlAtQRow (m_formCurQRow) ;
	if (ctrl == 0)
	{
		KBBlock	*block	= item ->getBlock	() ;
		uint	drow	= block->getCurDRow	() ;
		uint	nrows	= block->getDisplayRows	() ;

		fprintf
		(	stderr,
			"KBForm::accelerator: row out of range %d->%d+%d\n",
			m_formCurQRow,
			drow,
			nrows
		)	;
		return	;
	}

	ctrl->mainWidget()->setFocus () ;
}


#if	! __KB_RUNTIME

/*  KBForm								*/
/*  propertyDlg	: Run root property dialog				*/
/*  iniAttr	: cchar *	: Initial attribute			*/
/*  (returns)	: bool		: Success					*/

bool	KBForm::propertyDlg
	(	cchar	*iniAttr
	)
{
	QList<KBModule>	scripts	;
	QList<KBModule>	imports	;
	QList<KBParam > params  ;

	cchar		*btstr	= getBlkType() == KBBlock::BTNull  ? "null"  :
				  getBlkType() == KBBlock::BTTable ? "table" :
				  getBlkType() == KBBlock::BTSQL   ? "sql"   :
				  getBlkType() == KBBlock::BTQuery ? "query" : "" ;

	KBAttrStr	mattr	(this, "modlist",    "", KAF_SYNTHETIC) ;
	KBAttrStr	iattr	(this, "implist",    "", KAF_SYNTHETIC) ;
	KBAttrStr	pattr	(this, "paramlist",  "", KAF_SYNTHETIC) ;
	KBAttrStr	tattr	(this, "blktype", btstr, KF_REQD) ;

	CITER
	(	Script,
		s,
		scripts.append (s)
	)
	CITER
	(	Import,
		i,
		imports.append (i)
	)
	CITER
	(	Param,
		p,
		params .append (p)
	)

	if (!::formPropDlg (this, "Form", attribs, scripts, imports, params, iniAttr))
		return false ;

	if (tattr.getValue() != btstr)
	{
		bool	rc = false ;

		if	(tattr.getValue() == "null" ) rc = setBlkType (KBBlock::BTNull ) ;
		else if	(tattr.getValue() == "table") rc = setBlkType (KBBlock::BTTable) ;
		else if	(tattr.getValue() == "sql"  ) rc = setBlkType (KBBlock::BTSQL  ) ;
		else if	(tattr.getValue() == "query") rc = setBlkType (KBBlock::BTQuery) ;

		if (!rc) return false ;
	}

	if (blkDisp != 0) blkDisp->setStretchable (m_stretch.getBoolValue()) ;

	KBLayout::setChanged ()	;
	return	true	;
}
#endif
