/***************************************************************************
    file	         : kb_component.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_COMPONENT_H
#define	_KB_COMPONENT_H

#include	"libkbase_exports.h"

#include	"kb_framer.h"
#include	"kb_layout.h"
#include	"kb_conductor.h"
#include	"kb_docroot.h"



/*  KBComponent								*/
/*  ----------								*/
/*  This node is the root of a particular XML component definition. It	*/
/*  handles things which are global to the component, as well as	*/
/*  representing the top-most block.					*/

class	LIBKBASE_API	KBComponent : public KBBlock, public KBNavigator, public KBLayout
{
	Q_OBJECT

	KBAttrUInt	m_type		;	/* Type (form, ...)	*/
	KBAttrStr	m_language	;	/* Script language	*/

	KBDocRoot	m_docRoot	;	/* Common document	*/
	KBDisplay	*m_display	;	/* Top-level display	*/
	QRect		m_newRect	;	/* New object area	*/
	QPoint		m_insertAt	;	/* Insertion position	*/

protected :

#if	! __KB_RUNTIME
	QRect			newCtrlRect	()	  ;
	virtual	bool		propertyDlg	(cchar *) ;
#endif

public	:

	KBComponent	(KBLocation &, const QDict<QString> &) ;
	KBComponent	(KBLocation &, const QDict<QString> &, bool &) ;
	KBComponent	(KBNode     *, KBComponent *) ;
virtual~KBComponent	() ;


	virtual	KBComponent	*isComponent	() { return this       ; }
	virtual	KBLayout	*isLayout	() { return this       ; }
	virtual	KBDocRoot	*isDocRoot 	() { return &m_docRoot ; }

	virtual	KB::ObjType	objType		() ;

	virtual	KBNode		*replicate	(KBNode *) ;

	virtual	KBValue		getValue	(uint)	;
	virtual	bool		setValue	(uint, const KBValue &) ;
	virtual	KBValue		*getBlockVal	()	;
	virtual	uint		rowsInBlock	()	;
	virtual void		docPropDlg	()	;

#if	! __KB_RUNTIME
	virtual	void		designPopup	(QMouseEvent *, uint) ;
	virtual	KBPopupMenu	*makeNewPopup	(bool, QRect) ;
	KBPopupMenu		*makeFramerPopup(KBFramer *, Qt::ButtonState *) ;
#endif

	virtual	void		printNode	(QString &, int)    ;

	virtual	bool		resize		(int, int) ;

#if	! __KB_RUNTIME
	KB::ShowRC		showDesign	(QWidget *, QSize &) ;
	KB::ShowRC		showData	(QWidget *, QSize &) ;
	KB::ShowRC		showPrint	(KBWriter *) ;
#endif

	inline	KBDisplay	*getDisplay	()
	{
		return	m_display ;
	}
	inline	KB::ObjType	getType	()
	{
		return	(KB::ObjType)m_type.getIntValue() ;
	}


public	slots	:

	virtual	void		newContainer	()	;
	virtual KBNode		*newNode	(int)	;

	virtual void		pasteObjects	()	;
	virtual void		pasteHere	()	;
	virtual void		pasteComponent	()	;
	virtual void		linkComponent	()	;

public	:

	friend	class		KBBlock	;
}	;


extern	LIBKBASE_API	bool	componentPropDlg
			(	KBComponent	*,
				cchar		*,
				QList<KBAttr  > &,
				QList<KBParam > &,
				cchar		* = 0
			)	;
#endif	// _KB_COMPONENT_H
