/***************************************************************************
    file	         : kb_tablechooser.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_TABLECHOOSER_H
#define	__KB_TABLECHOOSER_H

#include	<qlayout.h>
#include	<qlabel.h>
#include	<qcombobox.h>
#include	<qpushbutton.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_location.h"
#include	"kb_dialog.h"

#include	"kb_dblink.h"
#include	"kb_dbinfo.h"

#include	"libkbase_exports.h"

/*  KBTableChooser							*/
/*  --------------							*/
/*  This is a simple helper class which controls a pair of combo boxes	*/
/*  which allow server and table selection. Emits a "changed()" signal	*/
/*  each time something changes.					*/
/*  NOTE: This class does not handle GUI layout, the constructor is	*/
/*	  passed the server and table combo boxes.			*/

class LIBKBASE_API	KBTableChooser : public QObject
{
	Q_OBJECT

	KBLocation	&location	;
	QComboBox	&cbServer	;
	QComboBox	&cbTable	;

signals	:

	void		serverChanged	()	;
	void		tableChanged	()	;

protected slots :

	void		serverSelected	(const QString &) ;
	void		tableSelected	(const QString &) ;

public	:

	KBTableChooser	(KBLocation &, QComboBox &, QComboBox &) ;

	bool		setServer	(const QString &) ;
	bool		setTable	(const QString &) ;
}	;


/*  KBTableChooserDlg							*/
/*  -----------------							*/
/*  This class provies a simple server/table selection dialog, based on	*/
/*  the table chooser class above.					*/

class LIBKBASE_API	KBTableChooserDlg : public _KBDialog
{
	Q_OBJECT

	KBLocation	location	;
	QComboBox	cbServer	;
	QComboBox	cbTable		;
	QLabel		lServer		;
	QLabel		lTable		;
	KBTableChooser	chooser		;
	QPushButton	bOK		;
	QPushButton	bCancel		;
	QGridLayout	*layMain	;

protected slots :

	void		changed	    ()	;
	void		clickOK	    ()	;
	void		clickCancel ()	;

public	:

	KBTableChooserDlg (KBLocation &);

	inline	QString	getServer   () { return cbServer.currentText() ; }
	inline	QString	getTable    () { return cbTable .currentText() ; }
}	;

#endif	// __KB_TABLECHOOSER_H
