/***************************************************************************
    file	         : kb_rowmark.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<ctype.h>

#include	<qpopupmenu.h>
#include	<qcursor.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"

#include	"kb_sizer.h"
#include	"kb_display.h"

#include	"kb_ctrl.h"
#include	"kb_formblock.h"

#ifndef 	_WIN32
#include 	"kb_rowmark.moc"
#else
#include 	"kb_rowmark.h"
#endif

#include	"kb_qtrowmark.h"
#include	"kb_nodereg.h"
#include	"kb_layout.h"



/*  KBRowMark								*/
/*  KBRowMark	: Constructor for simple form field			*/
/*  parent	: KBNode *	: Parent node				*/
/*  aList	: const QDict<QString> &				*/
/*				: List of attributes			*/
/*  ok		: bool *	: Success				*/
/*  (returns)	: KBNode	:					*/

KBRowMark::KBRowMark
	(	KBNode			*parent,
		const QDict<QString>	&aList,
		bool			*ok
	)
	:
	KBItem		(parent, "KBRowMark", "expr", 		aList),
	bgcolor		(this,   "bgcolor",			aList),
	frame		(this,   "frame",			aList),
	showRow		(this,   "showrow",			aList),
	dblClick	(this,	 "dblclick",  "onRowMark",	aList)
{
	tabOrd.setValue (0) ;
	if (frame.getValue().isEmpty()) frame.setValue("34,1") ;

#if	! __KB_RUNTIME
	if (ok != 0)
	{
		if (!::rowMarkPropDlg (this, "Rowmark", attribs))
		{	delete	this	;
			*ok	= false	;
			return	;
		}

		*ok	= true ;
	}
#endif
}

/*  KBRowMark								*/
/*  KBRowMark	: Constructor for simple form field			*/
/*  _parent	: KBNode *	: Parent node				*/
/*  _rowmark	: KBRowMark *	: Extant rowmark			*/
/*  (returns)	: KBNode	:					*/

KBRowMark::KBRowMark
	(	KBNode		*_parent,
		KBRowMark	*_rowmark
	)
	:
	KBItem		(_parent, "expr", 			_rowmark),
	bgcolor		(this,    "bgcolor",			_rowmark),
	frame		(this,    "frame",			_rowmark),
	showRow		(this,    "showrow",			_rowmark),
	dblClick	(this,	  "onRowMark",	"onRowMark",	_rowmark)
{
	tabOrd.setValue (0) ;
	if (frame.getValue().isEmpty()) frame.setValue("34,1") ;
}

/*  KBRowMark								*/
/*  ~KBRowMark	: Destructor for simple form field			*/
/*  (returns)	:		:					*/

KBRowMark::~KBRowMark ()
{
//	fprintf	(stderr, "Delete rowmark: %s\n", (cchar *)expr.getValue()) ;
}

/*  KBRowMark								*/
/*  makeCtrl	: Make a row marker control				*/
/*  drow	: uint		: Display row number			*/
/*  (returns)	: KBControl *	: New control				*/

KBControl
	*KBRowMark::makeCtrl
	(	uint		drow
	)
{
	return	new KBCtrlRowMark (getDisplay(), this, drow) ;
}

/*  KBRowMark								*/
/*  setCurrent	: Set current status					*/
/*  qrow	: uint		: Query row				*/
/*  value	: bool		: Current				*/
/*  (returns)	: void		:					*/

void	KBRowMark::setCurrent
	(	uint	qrow,
		bool	
	)
{
	KBRowMarkData	data	;
	data.type	= KBRowMarkData::Current ;

	for (uint idx = 0 ; idx < nCtrls ; idx += 1)
	{	data.current = getBlock()->getCurDRow() + idx == qrow ;
		ctrls[idx]->setData ((void *)&data) ;
	}
}

/*  KBRowMark								*/
/*  setState	: Set state						*/
/*  qrow	: uint		: Query row				*/
/*  state	: KB::RState	: New state				*/
/*  (returns)	: void		:					*/

void	KBRowMark::setState
	(	uint		qrow,
		KB::RState	state
	)
{
	KBRowMarkData	data			;
	data.type	= KBRowMarkData::State	;
	data.state	= state			;
	setData	(qrow, (void *)&data)		;
}

/*  KBRowMark								*/
/*  setInBlock	: Set whether user currently in associated block	*/
/*  inBlock	: bool		: True if in block			*/
/*  (returns)	: void		:					*/

void	KBRowMark::setInBlock
	(	bool	inBlock
	)
{
	for (uint idx = 0 ; idx < nCtrls ; idx += 1)
	{
		KBRowMarkData	data			 ;
		data.type	= KBRowMarkData::InBlock ;
		data.inBlock	= inBlock		 ;
		ctrls[idx]->setData ((void *)&data)	 ;
	}
}

/*  KBRowMark								*/
/*  deleteRow	: Request deletion of current row			*/
/*  (returns)	: void		:					*/

void	KBRowMark::deleteRow ()
{
	if (!getFormBlock()->deleteRow (getFormBlock()->getCurDRow() + rcRow))
		getFormBlock()->lastError().DISPLAY() ;
}

/*  KBRowMark								*/
/*  insertRow	: Request insertion before current row			*/
/*  (returns)	: void		:					*/

void	KBRowMark::insertRow ()
{
	if (!getFormBlock()->insertRow (getFormBlock()->getCurDRow() + rcRow))
		getFormBlock()->lastError().DISPLAY() ;
}

/*  KBRowMark								*/
/*  markSetAll	: Mark all rows						*/
/*  (returns)	: void		:					*/

void	KBRowMark::markSetAll ()
{
	setRowMarked (0, KB::MarkOpSetAll) ;
}

/*  KBRowMark								*/
/*  markClearAll: Mark all rows						*/
/*  (returns)	: void		:					*/

void	KBRowMark::markClearAll ()
{
	setRowMarked (0, KB::MarkOpClear) ;
}

/*  KRowMark								*/
/*  contextMenu	: Handler for context menu requests			*/
/*  e		: QMouseEvent *	: Mouse event				*/
/*  drow	: uint		: Display row				*/
/*  (returns)	: void		:					*/

void	KBRowMark::contextMenu
	(	QMouseEvent	*,
		uint		drow
	)
{
	rcRow	= drow	;

	QPopupMenu pop ;
	pop.insertItem (TR("Cancel")) ;
	pop.insertItem (TR("&Insert"),		this, SLOT(insertRow   ())) ;
	pop.insertItem (TR("&Delete"),		this, SLOT(deleteRow   ())) ;
	pop.insertItem (TR("Mark &all rows"),	this, SLOT(markSetAll  ())) ;
	pop.insertItem (TR("&Clear all marks"),	this, SLOT(markClearAll())) ;
	pop.exec       (QCursor::pos()) ;
}

/*  KRowMark								*/
/*  setRowMarked: Set row marking state					*/
/*  qrow	: uint		: Query row affected			*/
/*  op		: KB::MarkOp	: Mark operation			*/
/*  (returns)	: void		:					*/

void	KBRowMark::setRowMarked
	(	uint		qrow,
		KB::MarkOp	op
	)
{
	getFormBlock()->setRowMarked (qrow, op) ;
}

/*  KBRowMark								*/
/*  replicate	: Replicate this rowmark				*/
/*  _parent	: KBNode *	: Parent of replicant			*/
/*  (returns)	: KBNode *	: New RowMark node			*/

KBNode	*KBRowMark::replicate
	(	KBNode	*_parent
	)
{
	return	new KBRowMark (_parent, this) ;
}

/*  KBRowMark								*/
/*  setTabOrder	: Set tabbing order value				*/
/*  order	: int		: Order value				*/
/*  (returns)	: void		:					*/

void	KBRowMark::setTabOrder
	(	int
	)
{
	/* Null operation, users cannot tab into a row mark		*/
}

/*  KBRowMark								*/
/*  getTabOrder	: Get tabbing order value				*/
/*  (returns)	: int		: Order value				*/

int	KBRowMark::getTabOrder ()
{
	/* Always return a negative value; this keeps the row mark from	*/
	/* over being show in the tab order dialog			*/
	return	-1 ;
}

/*  KBRowMark								*/
/*  doubleClick	: User double clicks					*/
/*  qrow	: uint		: Order value				*/
/*  (returns)	: void		:					*/

void	KBRowMark::doubleClick
	(	uint		qrow
	)
{
	if (showingData ())
	{
		KBValue	arg	= (int)qrow ;
		bool	evRc	;
		eventHook (dblClick, 1, &arg, evRc) ;
	}
}

#if	! __KB_RUNTIME
/*  KBRowMark								*/
/*  propertyDlg	: Show property dialog					*/
/*  (returns)	: bool		: Success				*/

bool	KBRowMark::propertyDlg ()
{
	if (!::rowMarkPropDlg (this, "Rowmark", attribs)) return false ;

	updateProps  ()	;
	redraw	     ()	;
	return	true  ;
}
#endif


NEWNODE(RowMark, __TR("New &Rowmark"), KF_FORM|KF_BLOCK|KF_DATA)
