/***************************************************************************
    file	         : kb_reportdlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qprinter.h>

#ifndef		_WIN32
#include	"kb_reportdlg.moc"
#else
#include	"kb_reportdlg.h"
#endif

#include	"kb_report.h"
#include	"kb_param.h"
#include	"kb_dbdociter.h"

#include	"tk_messagebox.h"
#include	"tk_print.h"


static	IntChoice	choiceResolution[] =
{
	{	TKPrinter::ResScreen,		"Screen (Y-axis)"	},
	{	TKPrinter::ResPrinter,		"Printer (75 dpi)"	},
	{	TKPrinter::ResHigh,		"High (600 dpi)"	},
	{	-1,				0			}
}	;



/*  KBReportPropDlg							*/
/*  KBReportPropDlg: Constructor for root properties dialog		*/
/*  root	 : KBReport *	   : Root node				*/
/*  caption	 : cchar *	   : Caption text			*/
/*  attribs	 : QList<KBAttr  >&:Attributes list			*/
/*  scripts	 : QList<KBModule>&: List of script modules		*/
/*  imports	 : QList<KBModule>&: List of import modules		*/
/*  params	 : QList<KBParam >&: List of parameters modules		*/
/*  (returns)	 : KBReportPropDlg :					*/

KBReportPropDlg::KBReportPropDlg
	(	KBReport	*root,
		cchar		*caption,
		QList<KBAttr  >	&attribs,
		QList<KBModule>	&scripts,
		QList<KBModule>	&imports,
		QList<KBParam > &params 
	)
	:
	KBPropDlg (root, caption, attribs),
	scriptDlg (&topWidget, root, scripts),
	importDlg (&topWidget, root, imports),
	paramDlg  (&topWidget, root, params ),
	root	  (root)
{
	scriptDlg.hide() ;
	importDlg.hide() ;
	paramDlg .hide() ;
}

/*  KBReportPropDlg							*/
/*  ~KBReportPropDlg: Constructor for root properties dialog		*/
/*  (returns)	  :		:					*/

KBReportPropDlg::~KBReportPropDlg ()
{
}

/*  KBReportPropDlg							*/
/*  hideProperty : Check whether to hide attribute property		*/
/*  attr	 : KBAttr *	: Attribute in question			*/
/*  (returns)	 : bool		: True to hide				*/

bool	KBReportPropDlg::hideProperty
	(	KBAttr	*attr
	)
{
	/* Since KBReport is derived from KBBlock there are a whole lot	*/
	/* of properties which we must ignore; so check just for those	*/
	/* of our own.							*/
	if (qstrcmp (attr->getOwnerName(), "KBReport") == 0)
		return	false	;

	return	true	;
}


/*  KBReportPropDlg							*/
/*  getAttrItem	: Get attribute item for attribute			*/
/*  attr	: KBAttr *	: Attribute				*/
/*  (returns)	: KBAttrItem *	: Associated attribute item		*/

KBAttrItem
	*KBReportPropDlg::getAttrItem
	(	KBAttr	*attr
	)
{
	if (attr->getName() == "resolution")
		return	new KBAttrIntChoice (attr, choiceResolution) ;

	return	KBPropDlg::getAttrItem (attr) ;
}

/*  KBReportPropDlg							*/
/*  showProperty: Show property						*/
/*  item	: KBAttrItem *	: Associated item			*/
/*  (returns)	: bool		: Property on show			*/

bool	KBReportPropDlg::showProperty
	(	KBAttrItem	*item
	)
{
	QString	aName	= item->attr()->getName () ;

	/* The script module list is handled entirely locally, with	*/
	/* none of the default KBPropDlg controls.			*/
	if (aName == "modlist")
	{
		setUserWidget (&scriptDlg) ;
		return	true	 ;
	}
	if (aName == "implist")
	{
		setUserWidget (&importDlg) ;
		return	true	 ;
	}
	if (aName == "paramlist")
	{
		setUserWidget (&paramDlg ) ;
		return	true	 ;
	}

	/* Block type options are shown using the KBPropDlg combobox,	*/
	/* initialised with the set of possibilities. Also, the first	*/
	/* time round, make a note of the current report setting.		*/
	if (aName == "blktype")
	{
		comboBox.clear	     () ;
		comboBox.insertItem  (TR("Menu-only block" )) ;
		comboBox.insertItem  (TR("Table block"     )) ;
		comboBox.insertItem  (TR("SQL block"       )) ;
		comboBox.insertItem  (TR("Query block"     )) ;

		QString	value = item->value() ;
		if	(value == "null" ) comboBox.setCurrentItem (0) ;
		else if (value == "sql"  ) comboBox.setCurrentItem (2) ;
		else if (value == "query") comboBox.setCurrentItem (3) ;
		else			   comboBox.setCurrentItem (1) ;

		comboBox.show () ;

		if (ibtype.isNull()) ibtype = value ;
		return	true	 ;
	}

	if (aName == "printer")
	{
		KBDBDocIter docIter	;
		KBError	    error	;

		if (!docIter.init
			(	root->getDocRoot()->getLocation().dbInfo,
				root->getDocRoot()->getLocation().docLocn,
				"print",
				"prn",
				error
			))
		{
			error.DISPLAY() ;
			return	false	;
		}

		QString	name	;
		QString	stamp	;
		int	aIdx	= -1	;

		comboBox.insertItem ("");

		while (docIter.getNextDoc (name, stamp))
		{
			if (name == item->value()) aIdx = comboBox.count() ;
			comboBox.insertItem (name) ;
		}

		if (aIdx >= 0) comboBox.setCurrentItem (aIdx) ;
		comboBox.show	() ;
		return	true	;
	}

	if (aName == "resolution")
	{
		showChoices (item, choiceResolution, item->value()) ;
		return	true ;
	}

	return	KBPropDlg::showProperty (item) ;
}

/*  KBReportPropDlg								*/
/*  saveProperty: Check and save attribute				*/
/*  item	: KBAttrItem *	: Associated item			*/
/*  (returns)	: bool		: Attribute OK				*/

bool	KBReportPropDlg::saveProperty
	(	KBAttrItem	*item
	)
{
	QString	aName	= item->attr()->getName() ;

	/* As for showing the script module list, saving the results is	*/
	/* handled locally.						*/
	if (aName == "modlist"  )
	{
		setProperty  ("modlist",   scriptDlg.getText()) ;
		return	true ;
	}
	if (aName == "implist"  )
	{
		setProperty  ("implist",   importDlg.getText()) ;
		return	true ;
	}
	if (aName == "paramlist")
	{
		setProperty  ("paramlist", paramDlg .getText()) ;
		return	true ;
	}

	/* Similarly handle the block type here ...			*/
	if (aName == "blktype")
	{
		static	cchar	*vals[] =
		{	"null",
			"table",
			"sql",
			"query"
		}	;

		/* Get the selected type. If this is a change from the	*/
		/* current block type then warn the user that a change	*/
		/* will trash the report contents.			*/
		cchar	*newTyp	= vals[comboBox.currentItem()] ;

		if (!ibtype.isEmpty() && (newTyp != ibtype))
			if (TKMessageBox::questionYesNo
			   	(	0,
					TR("Changing block type will reset report contents; continue?"),
					TR("Change block type")
				)
				!= TKMessageBox::Yes) return false ;

		setProperty (item, newTyp) ;
		return	true ;
	}

	if (aName == "printer")
	{
		setProperty (item, comboBox.currentText()) ;
		return	true ;
	}

	if (aName == "resolution")
	{
		saveChoices (item, choiceResolution) ;
		return	true	;
	}

	return	KBPropDlg::saveProperty (item) ;
}

/*  KBReportPropDlg:							*/
/*  clickOK	 : Handle OK button click				*/
/*  (returns)	 : void		:					*/

void	KBReportPropDlg::clickOK ()
{
	scriptDlg.fixUp () ;
	importDlg.fixUp () ;
	paramDlg .fixUp () ;

	KBPropDlg::clickOK () ;
}

/*  KBReportPropDlg:							*/
/*  preExec	  : Called immediately before QDialog::exec		*/
/*  (returns)	  : void	:					*/

void	KBReportPropDlg::preExec ()
{
	/* Trap this and load the notional hidden attribute. We have to	*/
	/* do this here since it is not until "KBPropDlg::exec" has	*/
	/* been called that "setProperty" will work.			*/
	setProperty  ("modlist",   scriptDlg.getText()) ;
	setProperty  ("implist",   importDlg.getText()) ;
	setProperty  ("paramlist", paramDlg .getText()) ;
}


/*  reportPropDlg: Run the root properties dialog box			*/
/*  report	: KBReport *	  : Report node				*/
/*  caption	: cchar *	  : Caption text			*/
/*  attribs	: QList<KBAttr  >&:Attributes list			*/
/*  scripts	: QList<KBModule>&: List of script modules		*/
/*  imports	: QList<KBModule>&: List of import modules		*/
/*  params	: QList<KBParam >&: List of parameters			*/
/*  (returns)	: bool		  : Success				*/

bool	reportPropDlg
	(	KBReport	*report,
		cchar		*caption,
		QList<KBAttr  >	&attribs,
		QList<KBModule>	&scripts,
		QList<KBModule>	&imports,
		QList<KBParam >	&params
	)
{
	KBReportPropDlg rDlg (report, caption, attribs, scripts, imports, params) ;
	return	rDlg.exec  () ;
}
