/***************************************************************************
    file	         : kb_qtlabel.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/


#include	<qobjectlist.h>
#include	<qaccel.h>

#include	"kb_label.h"
#include	"kb_display.h"
#include	"kb_writer.h"
#include	"kb_attralign.h"
#include	"kb_form.h"


/*  KBCtrlLabel								*/
/*  KBCtrlLabel	: Constructor for label wrapper				*/
/*  display	: KBDisplay *	: Parent display			*/
/*  label	: KBLabel 	: Parent label				*/
/*  (returns)	: KBLabel	:					*/

KBCtrlLabel::KBCtrlLabel
	(	KBDisplay	*display,
		KBLabel		*label
	)
	:
	QLabel	 (display->getDisplayWidget()),
	KBControl(this, display, label),
	label	 (label)
{
	redraw	 () ;
}

/*  KBCtrlLabel								*/
/*  ~KBCtrlLabel: Destructor for label widget				*/
/*  (returns)	 :		:					*/

KBCtrlLabel::~KBCtrlLabel ()
{
}

/*  KBCtrlLabel								*/
/*  showAs	: Set or clear design mode				*/
/*  mode	: KB::ShowAs	: Design mode				*/
/*  (returns)	: void		:					*/

void	KBCtrlLabel::showAs
	(	KB::ShowAs	mode
	)
{
	KBControl::showAs (mode) ;

	int	align	= label->getAlign() ;

	if (align == RICHTEXT)
	{
		setTextFormat (Qt::RichText) ;
		setAlignment  (Qt::WordBreak) ;
		return	;
	}

	setTextFormat(Qt::PlainText	  ) ;
	setAlignment (Qt::ShowPrefix|align) ;
}

/*  KBLabel								*/
/*  redraw	: Redraw to get profile and frame correct		*/
/*  (returns)	: bool		:					*/

void	KBCtrlLabel::redraw ()
{
	ctrlSetFrame (this) ;
}

/*  KBCtrlLabel								*/
/*  setValue	: Set label text					*/
/*  value	: const KBValue &: Value for text			*/
/*  (returns)	: void		 :					*/

void	KBCtrlLabel::setValue
	(	const KBValue	&value
	)
{
	QString	text	= value.getRawText() ;
	setText (text) ;


	/* Now for a load of mucking about. We need to handle buddying	*/
	/* ourselves, but the QLabel class does not expose the right	*/
	/* methods, so here goes .... if there is no shortcut key then	*/
	/* nothing to do.						*/
	int	ak	= QAccel::shortcutKey (text) ;
	if (ak == 0) return ;


	/* If there is an accelerator key then we should be able to	*/
	/* find the QAccel object that the label creates. We need this	*/
	/* since we must clear it and handle the accelerator ourselves.	*/
	const QObjectList *cl = QLabel::children() ;
	if (cl == 0) return ;

	QObjectListIt	iter (*cl) ;
	QAccel		*accel = 0 ;
	QObject		*obj	   ;

	while ((obj = iter.current()) != 0)
	{
		if (obj->isA("QAccel"))
		{
			accel = (QAccel *)obj ;
			break	;
		}
		*++iter ;
	}

	if (accel == 0) return	;
	accel->clear()	;

	/* Get the name of the buddy (and exit if not set), then locate	*/
	/* it. If not found or the buddy is not an item then we do	*/
	/* nothing.							*/
	QString	 bname	= label->getAttrVal("buddy") ;
	if (bname.isEmpty ()) return ;

	KBObject *buddy	= label->getParent()->isObject()->getNamedObject (bname) ;
	if ((buddy == 0) || (buddy->isItem() == 0))
	{
		fprintf
		(	stderr,
			"KBCtrlLabel::setValue: no buddy or not item [%s][%p]\n",
			(cchar *)bname,
			(void  *)buddy
		)	;
		return	;
	}

	/* Got it! The accelerator is installed by the form object,	*/
	/* which handles stuff line current row (since if there are	*/
	/* multiple rows displayed then the buddy is really one of the	*/
	/* controls for the buddy item).				*/
	label->getRoot()->isForm()->addAccelerator(ak, buddy->isItem()) ;
}

/*  KBCtrlLabel								*/
/*  getValue	: Get button text					*/
/*  (returns)	: KBValue	: Button text				*/

KBValue	KBCtrlLabel::getValue ()
{
	return	KBValue(text()) ;
}

/*  KBCtrlLabel								*/
/*  write	: Write field 						*/
/*  writer	: KBWriter *	: Output writer				*/
/*  rect	: QRect		: Field area				*/
/*  value	: KBValue &	: Value for reports			*/
/*  fSubs	: bool		: Substitution flag			*/
/*  extra	: int &		: Return extra space			*/
/*  (returns)	: bool		: Success				*/

bool	KBCtrlLabel::write
	(	KBWriter	*writer,
		QRect		rect,
		const KBValue	&value,
		bool		fSubs,
		int		&extra
	)
{
	if (writer->asReport())
	{
		new KBWriterText
		(	writer,
			rect,
			label->getPalette(true),
			label->getFont   (true),
			text(),
			label->getAlign  (),
			false
		) 	;

		extra	= 0	;
		return	true	;
	}

	return	KBControl::write (writer, rect, value, fSubs, extra) ;
}

