/***************************************************************************
    file	         : kb_qtchoice.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_QTCHOICE_H
#define	_KB_QTCHOICE_H


#include	<qstringlist.h>

#include	"kb_classes.h"
#include	"kb_ctrl.h"
#include	"kb_combobox.h"

#include	"libkbase_exports.h"

#define	CHOICE_NOCHANGE(s)	\
	{	m_inSetValue = true  ;	\
		s ;			\
		m_inSetValue = false ;	\
	}


/*  KBCtrlChoice							*/
/*  ------------							*/
/*  Wrapper class for choice combo box control				*/

class LIBKBASE_API	KBCtrlChoice : public KBComboBox, public KBControl
{
	Q_OBJECT

	KBChoice	*m_choice	;
	bool		m_inSetValue	;

private slots :

	void		slotChanged	() ;

protected :

        virtual void    giveFocus     	() ;

public	:

	KBCtrlChoice (KBDisplay *, KBChoice *, uint) ;
virtual~KBCtrlChoice () ;

	virtual	void	showName	() ;
	virtual	void	redraw		() ;
	virtual	void	setData		(void *) ;
	virtual	void	showAs		(KB::ShowAs) ;
	virtual	void	setValue   	(const KBValue &) ;
	virtual	KBValue	getValue   	() ;
	virtual	void	clearValue	(bool) ;
	virtual	bool	changed    	() ;
	virtual	bool	isEmpty		() ;
	virtual	bool	isValid		(bool) ;

	virtual	QString	morphText	() ;

	SETFOCUS
	SIZEHINT
}	;

#endif	// _KB_QTCHOICE_H
