/***************************************************************************
    file	         : kb_parsereport.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<stdarg.h>


#include	<qxml.h>
#include	<qpopupmenu.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"

#include	"kb_report.h"
#include	"kb_nodereg.h"
#include	"kb_parse.h"


static /*LIBKBASE_API*/ uint pNodeFns	;
static /*LIBKBASE_API*/	QDict<NodeSpec>	reportNodeDict	;



/*  KBReporthandler							*/
/*  -------------							*/
/*  Handler for parsing reports.					*/

class LIBKBASE_API	KBReportHandler : public KBSAXHandler
{
	KBReport	*m_kbReport ;		/* Parsed report root	*/

public	:

	KBReportHandler (KBLocation &, KBNode *) ;

	virtual	bool	startElement	(const QString &, const QString &, const QString &, const QXmlAttributes &) ;

	KBReport	*parseFile (const QString &) ;
	KBReport	*parseText (QByteArray	  &) ;
}	;


/*  KBReportHandler							*/
/*  KBReportHandler							*/
/*		: Constructor for report parser				*/
/*  location	: KBLocation *    : Database location			*/
/*  parent	: KBNode *	  : Initial parent node			*/
/*  (returns)	: KBReportHandler :					*/

KBReportHandler::KBReportHandler
	(	KBLocation	&location,
		KBNode		*parent
	)
	:
	KBSAXHandler ("report", location, parent)
{
	m_kbReport = 0 ;
}

/*  KBReportHandler							*/
/*  startElement: Handle start of element				*/
/*  URI		: const QString &	: Namespace URI			*/
/*  localName	: const QString &	:				*/
/*  qName	: const QString &	: Element name			*/
/*  attribs	: const QXmlAttributes &: Attribute list		*/
/*  (returns)	: bool			:				*/

bool	KBReportHandler::startElement
	(	const	QString		&,
		const	QString		&,
		const	QString		&qName,
		const	QXmlAttributes	&attribs
	)
{
	/* The QXmlAttributes are converted to a QDict<QString>		*/
	/* dictionary. This is done since by passing attributes in this	*/
	/* way, it is easy to construct reports on the fly.		*/
	QDict<QString>	aList	   ;
	aList.setAutoDelete (true) ;
	for (int idx = 0 ; idx < attribs.length() ; idx += 1)
		aList.insert (attribs.qName (idx), new QString (attribs.value(idx))) ;


	/* Check for the root of the report. This is a special case, as	*/
	/* we need to construct and note the form root node.		*/
	if (qName == "KBReport")
	{
		m_kbTOS	= m_kbReport = new KBReport (m_location, aList) ;
		m_kbReport->startParse () ;
		return	true ;
	}

	/* Check also for pasting a component, in which case create a	*/
	/* dummy form object at the top level.				*/
	if (qName == "KBComponent")
	{
		m_kbTOS	= m_kbReport = new KBReport (m_location, aList) ;
		m_kbReport->startParse ()     ; 
		return	true ;
	}

	if (m_kbTOS == 0)
	{
		setErrMessage (TR("Expected KBReport element at top-most level, got %1"), qName) ;
		return	false ;
	}

	return	processNode (qName, aList, reportNodeDict) ;
}

/*  KBReportHandler							*/
/*  parseFile	: Parse report from file				*/
/*  document	: const QString &: Report document file			*/
/*  (returns)	: KBReport *	 : Report root or null on error		*/

KBReport*KBReportHandler::parseFile
	(	const QString	&document
	)
{
	/* All of the work is done by the base parse method, which	*/
	/* picks up on errors and empty documents.			*/
	if (!KBSAXHandler::parseFile (document)) return 0 ;

	return	m_kbReport ;
}

/*  KBReportHandler							*/
/*  parseText	: Parse report from text				*/
/*  document	: QByteArray &	: Report document text			*/
/*  (returns)	: KBReport *	: Report root or null on error		*/

KBReport*KBReportHandler::parseText
	(	QByteArray	&document
	)
{
	/* All of the work is done by the base parse method, which	*/
	/* picks up on errors and empty documents.			*/
	if (!KBSAXHandler::parseText (document)) return 0 ;

	return	m_kbReport ;
}


/*  RepLoadNodeFuncs							*/
/*		: Load new node definition functions			*/
/*  (returns)	: void		:					*/

static	void RepLoadNodeFuncs()
{
	pNodeFns = LoadNodeFuncs (pNodeFns, KF_REPORT, reportNodeDict) ;
}

/*  KBOpenReportText							*/
/*		: Open a report document from text			*/
/*  location	: KBLocation &	 : Report location			*/
/*  document	: QByteArray &	 : Report document text			*/
/*  pError	: KBError &	 : Error return				*/
/*  (returns)	: KBReport	 : Document root or null		*/

KBReport*KBOpenReportText
	(	KBLocation	&location,
		QByteArray	&document,
		KBError		&pError
	)
{
	RepLoadNodeFuncs () ;

	/* Create and initialise the SAX parser and the document and	*/
	/* error handlers (which are actually one and the same.		*/
	KBReportHandler  	handler (location, 0) ;
	KBReport		*report	= handler.parseText (document) ;

	if (report == 0)
	{	pError	= handler.lastError () ;
		return	0 ;
	}

	return	report	;
}


/*  makeReportMenu							*/
/*		: Insert node entries into report popup design menu	*/
/*  popup	: QPopupMenu *	: Popup menu being constructed		*/
/*  receiver	: QObject *	: Received for menu signals		*/
/*  flags	: uint		: Inclusion flags			*/
/*  (returns)	: void		:					*/

void	makeReportMenu
	(	QPopupMenu	*popup,
		QObject		*receiver,
		uint		flags
	)
{
	extern	void	 makeDesignMenu (QDict<NodeSpec> &, QPopupMenu *, QObject *, uint) ;
	RepLoadNodeFuncs () ;
	makeDesignMenu	 (reportNodeDict, popup, receiver, flags) ;
}
