/***************************************************************************
    file	         : kb_options.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_OPTIONS_H
#define	_KB_OPTIONS_H



#include	"libkbase_exports.h"
#include	"kb_dom.h"

/*  KBOptions								*/
/*  ---------								*/
/*									*/
/*  Global options class. This is effectively a namespace, and is done	*/
/*  like this so that we can split up the options themselves from the	*/
/*  configuration dialogs, which are mostly not used in the runtime	*/
/*  only version.							*/
/*									*/
class	LIBKBASE_API	KBOptions
{
public	:

	enum	ScriptType
	{
		ScriptTypeAlwaysScript	= 0,
		ScriptTypeUserChoice	= 1,
		ScriptTypeAlwaysMacro	= 2
	}	;

	enum	MacroDebug
	{
		MacroDebugOnDemand	= 0,
		MacroDebugAlwaysOff	= 1,
		MacroDebugAlwaysOn	= 2
	}	;

	enum	VerifyOption
	{
		VerifyNever		= 0,
		VerifyAlways		= 1,
		VerifyMulti		= 2
	}	;

private	:

	uint		gridX	 	;
	uint 		gridY	 	;

	uint		formW	 	;
	uint		formH	 	;
	int		defDX	 	;
	int		defDY	 	;
	uint		space 	 	;

	uint		marginL  	;
	uint		marginR  	;
	uint		marginB  	;
	uint		marginT  	;
	bool		designInches	;
	uint		dpi		;

	bool		openLast 	;
	bool		useMdi   	;
	bool		singleDBOnly	;

	bool		tablesModal	;
	bool		formsModal	;
	bool		reportsModal	;
	bool		queriesModal	;

	uint		logMaxQueries	;
	uint		logMaxEvents	;
	uint		logMaxArgs	;
	uint		logMaxArgLen	;

	ScriptType	scriptType	;
	MacroDebug	macroDebug	;

	VerifyOption	verInsert	;
	VerifyOption	verUpdate	;
	VerifyOption	verDelete	;
	bool		verMultiple	;

	QString		scriptFont	;

public	:

	static	void		loadOptions	() ;

	static	uint		getGridXStep 	() ;
	static	uint		getGridYStep	() ;
	static	uint		getFormWidth	() ;
	static	uint		getFormHeight 	() ;
	static	int		getDefaultDX 	() ;
	static	int		getDefaultDY 	() ;
	static	uint		getCtrlSpace	() ;

	static	bool		getUseMDI	() ;
	static	bool		getSingleDBOnly	() ;

	static	bool		snappingOn	() ;
	static	uint		getLeftMargin	() ;
	static	uint		getRightMargin	() ;
	static	uint		getTopMargin	() ;
	static	uint		getBottomMargin	() ;
	static	uint		getDPI		() ;

	static	int		getDlgMargin	() ;
	static	int		getDlgSpacing	() ;

	static	bool		getOpenLast	() ;
	static	bool		getDesignInches	() ;

	static	bool		getTablesModal	() ;
	static	bool		getFormsModal	() ;
	static	bool		getReportsModal	() ;
	static	bool		getQueriesModal	() ;

	static	uint		getLogMaxQueries() ;
	static	uint		getLogMaxEvents	() ;
	static	uint		getLogMaxArgs	() ;
	static	uint		getLogMaxArgLen	() ;

	static	QString		getScriptFont	() ;

	static	ScriptType	getScriptType	() ;
	static	MacroDebug	getMacroDebug	() ;

	static	VerifyOption	getVerInsert	() ;
	static	VerifyOption	getVerUpdate	() ;
	static	VerifyOption	getVerDelete	() ;
	static	bool		getVerMultiple	() ;

	static	KBOptions	&self		() ;
	static	void		loadFromXML	(QDomElement &) ;
	static	void		saveToXML	(QDomElement &) ;

	friend	class		KBInterfaceOpts	;
	friend	class		KBModalOpts	;
	friend	class		KBLayoutOpts	;
	friend	class		KBReportOpts	;
	friend	class		KBPythonOpts	;
	friend	class		KBScriptOpts	;
	friend	class		KBLoggingOpts	;
	friend	class		KBVerifyOpts	;

	friend	class		KBOptionsDlg	;
}	;

#define	KB_OPTIONS_GROUP	"Setup Options"
#endif	// _KB_OPTIONS_H
