/***************************************************************************
    file	         : kb_finddlg.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_FINDDLG_H
#define	__KB_FINDDLG_H


#include	<qwidgetstack.h>
#include	<qgroupbox.h>
#include	<qlabel.h>
#include	<qcheckbox.h>
#include	<qcombobox.h>
#include	<qpushbutton.h>
#include	<qregexp.h>


#include	"kb_classes.h"
#include	"kb_dialog.h"

#include	"tk_lineedit.h"

/*  KBFindDlg								*/
/*  ---------								*/
/*  Base class for record searching dialog. Classes are derived for	*/
/*  specific cases (text, choice, ...)					*/

class	KBFindDlg : public _KBDialog
{
	Q_OBJECT

public	:

	enum	Options
	{
		ShowRegexp	= 0x01,
		ShowSensitive	= 0x02,
		ShowWholeText	= 0x04
	}	;

protected :

	QGroupBox	m_findBox	;
	QGroupBox	m_optionsBox	;
	QGroupBox	m_statusBox	;

	QWidgetStack	m_finder	;
	QCheckBox	m_regexp	;
	QCheckBox	m_sensitive	;
	QCheckBox	m_backwards	;
	QCheckBox	m_wholeText	;
	QLabel		m_status	;

	QPushButton	m_bFind		;
	QPushButton	m_bCancel	;

	KBFormBlock	*m_block	;
	KBItem		*m_item		;
	uint		m_options	;

	void		searchFor	(const QString &) ;

protected slots	:

	void		slotClickFind	()	;
	void		slotClickCancel	()	;

protected	:

	virtual bool	matched		(uint)	= 0	;
	virtual	bool	prepare		() 	= 0	;

public	:

	KBFindDlg	(KBFormBlock *, KBItem *, uint) ;
}	;



/*  KBFindTextDlg							*/
/*  -------------							*/
/*  Derived class used to handle searching through text-based controls	*/
/*  such as fields and memos.						*/

class	KBFindTextDlg : public KBFindDlg
{
	Q_OBJECT

	TKLineEdit	m_findText	;
	QRegExp		m_srchRegexp	;

protected slots	:

	void		slotTextChanged	 (const QString &) ;
	void		slotRegexpToggled(bool)	;

protected	:

	virtual bool	matched		(uint)	;
	virtual	bool	prepare		() 	;

public	:

	KBFindTextDlg	(KBFormBlock *, KBItem *) ;
}	;

/*  KBFindChoiceDlg							*/
/*  ---------------							*/
/*  Derived class used to handle searching through selection-based	*/
/*  controls such as choices and links.					*/

class	KBFindChoiceDlg : public KBFindDlg
{
	Q_OBJECT

	QComboBox		m_findChoice	;
	const QStringList	&m_choices	;
	const QStringList	&m_values	;

	QString			m_choiceText	;

	virtual bool	matched		(uint)	;
	virtual	bool	prepare		() 	;

public	:

	KBFindChoiceDlg	(KBFormBlock *, KBItem *, const QStringList &, const QStringList &) ;
}	;


#endif	// __KB_FINDDLG_H
