/***************************************************************************
    file	         : kb_fieldchooser.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_FIELDCHOOSER_H
#define	__KB_FIELDCHOOSER_H

#include	<qlayout.h>
#include	<qlabel.h>
#include	<qcombobox.h>
#include	<qlistbox.h>
#include	<qpushbutton.h>

#include	"libkbase_exports.h"

#include	"kb_tablechooser.h"
#include	"kb_querychooser.h"
#include	"kb_listboxpair.h"


/*  KBFieldChooser							*/
/*  --------------							*/
/*  This is a simple helper class which handles various controls used	*/
/*  to allow server/table/field1,field2,... selection.			*/
/*  NOTE: This class does not handle GUI layout, the constructor is	*/
/*	  passed the controls.						*/

class	LIBKBASE_API	KBFieldChooser : public QObject
{
	Q_OBJECT

	KBLocation	&location	;
	QComboBox	&cbServer	;
	QComboBox	&cbObject	;
	KBTableChooser	*tabChooser	;
	KBQueryChooser	*qryChooser	;

	QListBox	&lbFields	;
	QListBox	&lbSelect	;
	KBListBoxPairText
			m_lbPair	;

signals	:

	void		fieldsChanged	() ;
	void		selectChanged	(bool) ;

protected slots	:

	void		setFields	() ;
	void		destChanged	(bool) ;

public	:

	KBFieldChooser	(KBLocation  &,
			 QComboBox   &, QComboBox   &,
			 QListBox    &, QListBox    &,
			 QPushButton &, QPushButton &,
			 QPushButton &, QPushButton &,
			 QPushButton &,
			 bool = true,
			 bool = false) ;

	~KBFieldChooser	() ;

	inline	bool	setServer
		(	const QString	&server
		)
	{
		if (tabChooser != 0) return tabChooser->setServer (server) ;
		if (qryChooser != 0) return qryChooser->setServer (server) ;
		return	false ;
	}
	inline	bool	setObject
		(	const QString	&object
		)
	{
		if (tabChooser != 0) return tabChooser->setTable  (object) ;
		if (qryChooser != 0) return qryChooser->setQuery  (object) ;
		return	false ;
	}
}	;


/*  KBTableChooserDlg							*/
/*  -----------------							*/
/*  This class provies a simple server/table/field... selection dialog,	*/
/*  based on the field chooser class above.				*/

class LIBKBASE_API	KBFieldChooserDlg : public _KBDialog
{
	Q_OBJECT

	KBLocation	location	;

	QVBoxLayout	*layMain	;
	QGridLayout	*layObject	;
	QHBoxLayout	*laySelect	;
	QVBoxLayout	*layButton	;
	QHBoxLayout	*layOKCancel	;

	QLabel		lServer		;
	QLabel		lObject		;
	QComboBox	cbServer	;
	QComboBox	cbObject	;

	QListBox	lbFields	;
	QListBox	lbSelect	;
	QPushButton	bAdd		;
	QPushButton	bAddAll		;
	QPushButton	bRemove		;
	QPushButton	bUp		;
	QPushButton	bDown		;

	QPushButton	bOK		;
	QPushButton	bCancel		;

	KBFieldChooser	fldChooser	;

protected slots :

	void		selectChanged	() ;
	void		clickOK		() ;
	void		clickCancel	() ;

public	:

	KBFieldChooserDlg   (KBLocation &, bool = true, bool = false) ;

	inline	QString	getServer	() { return cbServer.currentText() ; }
	inline	QString	getObject	() { return cbObject.currentText() ; }

	QStringList	getFields	() ;
}	;


#endif	// __KB_FIELDCHOOSER_H
