/***************************************************************************
    file	         : kb_docchooser.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_DOCCHOOSER_H
#define	__KB_DOCCHOOSER_H

#include "libkbase_exports.h"

#include	<qlayout.h>
#include	<qlabel.h>
#include	<qcombobox.h>
#include	<qpushbutton.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_location.h"
#include	"kb_dialog.h"

#include	"kb_dblink.h"
#include	"kb_dbinfo.h"


/*  KBDocChooser							*/
/*  -----------								*/
/*  This is a simple helper class which controls a pair of combo boxes	*/
/*  which allow server/file and document selection for a specified	*/
/*  document type and extension.					*/
/*									*/
/*  NOTE: This class does not handle GUI layout, the constructor is	*/
/*	  passed the server and table combo boxes.			*/

class	LIBKBASE_API	KBDocChooser : public QObject
{
	Q_OBJECT

	KBDBInfo	*m_dbInfo		;
	QComboBox	&m_cbServer		;
	QComboBox	&m_cbDocument		;
	QString		m_docType		;
	QString		m_docExtn		;

signals	:

	void		serverChanged	()	;
	void		documentChanged	()	;

protected slots :

	void		serverSelected	(const QString &) ;
	void		documentSelected(const QString &) ;

public	:

	KBDocChooser
	(	KBDBInfo	*,
		QComboBox	&,
		QComboBox	&,
		const QString	&,
		const QString	&,
		bool		= false
	)	;

	bool		setServer	(const QString &) ;
	bool		setDocument	(const QString &) ;
}	;


/*  KBDocChooserDlg							*/
/*  ---------------							*/
/*  This class provies a simple server/document selection dialog, based	*/
/*  on the chooser class above.						*/

class	LIBKBASE_API	KBDocChooserDlg : public _KBDialog
{
	Q_OBJECT

	KBDBInfo	*m_dbInfo	;
	QComboBox	m_cbServer	;
	QComboBox	m_cbDocument	;
	QLabel		m_lServer	;
	QLabel		m_lDocument	;
	KBDocChooser	m_chooser	;
	QPushButton	m_bOK		;
	QPushButton	m_bCancel	;

protected :

	QGridLayout	*m_layMain	;

protected slots :

	virtual	void	changed		()	;
	virtual	void	clickOK		()	;
	virtual	void	clickCancel	()	;

public	:

	KBDocChooserDlg (KBDBInfo *, const QString &, const QString &, bool = false) ;

	inline	QString	getServer   () { return m_cbServer  .currentText() ; }
	inline	QString	getDocument () { return m_cbDocument.currentText() ; }


	inline	bool	setServer
		(	const QString	&server
		)
	{
		return	m_chooser.setServer   (server  ) ;
	}
	inline	bool	setDocument
		(	const QString	&document
		)
	{
		return	m_chooser.setDocument (document) ;
	}
}	;

#endif	// __KB_DOCCHOOSER_H
