/***************************************************************************
    file	         : kb_copysql.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_COPYSQL_H
#define	__KB_COPYSQL_H

#include 	"libkbase_exports.h"

#include	"kb_dom.h"
#include	"kb_location.h"
#include	"kb_dblink.h"


class	LIBKBASE_API	KBCopySQL : public KBCopyBase
{
	bool		srce	  ;	/* Source (else error!)		*/
	KBLocation	&location ;	/* Database location		*/

	QString		server	  ;	/* Server name			*/
	QString		query	  ;	/* SQL query			*/

	KBDBLink	dbLink	  ;	/* Link to database		*/
	KBSQLSelect	*select	  ;	/* SQL execution		*/
	bool		qExec	  ;	/* Query has been executed	*/
	uint		sRow	  ;	/* Source row number		*/

public	:

	KBCopySQL		(bool, KBLocation &)	;
	virtual	~KBCopySQL	()		;

	virtual	cchar		*tag		() ;

	virtual	bool		valid		(KBError     &) ;
	virtual	bool		set		(QDomElement &, KBError &) ;
	virtual	void		def		(QDomElement &) ;

	virtual	void		getColumnNames	(QStringList &) ;
	virtual	bool		prepare		(const QDict<QString>   &, KBCopyBase *) ;
	virtual	int		getNumCols	() ;
	virtual	int		getRow		(KBValue *, uint,  bool &) ;
	virtual	bool		putRow		(KBValue *, uint  ) ;
	virtual	bool		finish		(QString &) ;

	void			setServer	(const QString &) ;
	void			setSQL		(const QString &) ;

	inline	const QString	&getServer	() { return server ; }
	inline	const QString	&getSQL		() { return query  ; }

	void			reset		() ;

}	;

#endif	// __KB_COPYSQL_H
