/***************************************************************************
    file	         : kb_blockgui.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<time.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_location.h"
#include	"kb_hidden.h"
#include	"kb_rowmark.h"
#include	"kb_display.h"
#include	"kb_options.h"
#include	"kb_event.h"
#include	"kb_attrdict.h"
#include	"kb_nodereg.h"
#include	"kb_framer.h"
#include	"kb_parse.h"

#include	"kb_block.h"
#include	"kb_formblock.h"
#include	"kb_reportblock.h"
#include	"kb_form.h"
#include	"kb_report.h"
#include	"kb_blockevents.h"
#include	"kb_qrydata.h"

#include	"kb_component.h"

#if		! __KB_RUNTIME
#include	"kb_popupmenu.h"
#include	"kb_sizer.h"
#include	"kb_formcopier.h"
#include	"kb_compaccessdlg.h"
#endif


/*  KBBlock								*/
/*  setPalette	: Set palette						*/
/*  (returns)	: void		:					*/

void	KBBlock::setPalette ()
{
	blkDisp ->setPalette (getPalette (false)) ;
	KBObject::setPalette () ;
}

/*  KBBlock								*/
/*  setFont	: Set font						*/
/*  (returns)	: void		:					*/

void	KBBlock::setFont ()
{
	blkDisp ->setFont (getFont (false)) ;
	KBObject::setFont () ;
}


/*  KBBlock								*/
/*  calcNumRows	: Calculate number of rows which can be show		*/
/*  bw		: uint		: Block display width			*/
/*  bh		: uint		: Block display height			*/
/*  dx		: int		: Control X-spacing			*/
/*  dy		: int		: Control Y-spacing			*/
/*  (returns)	: uint		: Number of rows that can be displayed	*/

uint	KBBlock::calcNumRows
	(	uint	,
		uint	,
		int	,
		int
	)
{
	/* NOTE: This refers to the number of rows which a block can	*/
	/* "display" from its parent. There is no limit on this; the	*/
	/* number of rows that the parent shows will be controlled by	*/
	/* other items in the parent.					*/
	return	999	;
}

/*  KBBlock								*/
/*  dx		: int		: Control X-spacing			*/
/*  dy		: int		: Control Y-spacing			*/
/*  limit	: uint		: Upper limit on number of rows		*/
/*  (returns)	: uint		: Number of rows that can be displayed	*/

uint	KBBlock::calcNumRows
	(	int	,
		int	,
		uint	limit
	)
{
	return	limit	;
}

/*  KBBlock								*/
/*  buildDisplay: Build display						*/
/*  display	: KBDisplay *	: Top display				*/
/*  (returns)	: void		:					*/

void	KBBlock::buildTopDisplay
	(	KBDisplay *display
	)
{
	KBItem::buildDisplay (blkDisp = display) ;

	CITER
	(	Object,
		o,
		o->buildDisplay (blkDisp)
	) ;
}

/*  KBBlock								*/
/*  buildDisplay: Build display						*/
/*  display	: KBDisplay *	: Parent display			*/
/*  (returns)	: void		:					*/

void	KBBlock::buildDisplay
	(	KBDisplay *display
	)
{
	QRect	r = geometry() ;

	blkDisp	= new KBDisplay (display, this, showbar.getFlags()) ;
	blkDisp->resize (r.width(), r.height()) ;

	KBItem::buildDisplay (display) ;

	CITER
	(	Object,
		o,
		o->buildDisplay (blkDisp)
	) ;
}

/*  KBBlock								*/
/*  buildCtrls	: Build controls for this node				*/
/*  numrows	: uint		: Number of rows in parent		*/
/*  dx		: int		: X offset between rows			*/
/*  dy		: int		: Y offset between rows			*/
/*  (returns)	: void		:					*/

void	KBBlock::buildCtrls
	(	uint		_pRows,
		int		,
		int	
	)
{
	QRect	r	= geometry 	 () ;
	int	_dx	= dx.getIntValue () ;
	int	_dy	= dy.getIntValue () ;

	blkInfo.scroll = blkDisp ;

	blkDisp->move       (r.x    (),  r.y     ()) ;
	blkDisp->resize     (r.width(),  r.height()) ;
	blkDisp->setShowbar (showbar.getFlags    ()) ;

	setPalette () ;
	setFont	   () ;

	QString	fs	= frame.getValue() ;
	int	coff	= fs.find (',')	   ;

	if (coff >= 0)
		blkDisp->setFrame
		(	fs.left(coff    ).toInt(),
			fs.mid (coff + 1).toInt()
		)	;
	else	blkDisp->setFrame (0, 0) ;

	/* Special case: If the number of rows is zero then this is	*/
	/* either the top-level block, or the block is just rebuilding	*/
	/* itself, in which case the number of rows stays unchanged.	*/
	if (_pRows != 0) pRows = _pRows ;

	/* Get the number of rows to display. This will be one for	*/
	/* reports, and variable for forms.				*/
	nRows	= rowsInBlock () ;

	/* Now build the controls for the embedded objects given the	*/
	/* number of rows to be shown.					*/
	CITER
	(	Object,
		obj,
		obj->buildCtrls (nRows, _dx, _dy) ;
	) ;

	if (isFormBlock() != 0) isFormBlock()-> fixTabOrder () ;

	/* Block is now properly set up, so show the displays for each	*/
	/* nested block. Note that ours (be is a top-level scroller or	*/
	/* an embedded simple widget) will still be hidden.		*/
	CITER
	(	Block,
		b,
		b->getContainer()->show() ;
	)
}

/*  KBBlock								*/
/*  showAs	: Set or clear design mode				*/
/*  mode	: KB::ShowAs	: Design mode				*/
/*  (returns)	: void		:					*/

void	KBBlock::showAs
	(	KB::ShowAs	mode
	)
{
	blkDisp->showAs (mode) ;

	/* A special case when creating a sizer is if there is no	*/
	/* parent, which is the case for the top-most (form or report)	*/
	/* level block.							*/
#if	! __KB_RUNTIME
	if ((mode == KB::ShowAsDesign) && (getSizer() == 0))
		setSizer (new KBSizer (this, 
				       getDisplay() == 0 ? blkDisp : getDisplay(),
				       blkDisp->getDisplayWidget())) ;

	if ((mode == KB::ShowAsData  ) && (getSizer() != 0))
		setSizer (0) ;
#endif

	anyChildBlock	= false	;
	header		= 0	;
	footer		= 0	;
	m_userSorting	= QString::null ;
	m_userFilter	= QString::null ;


	CITER
	(	Framer,
		f,

		if (f->getElement() == "KBBlockHeader") header = f ;
		if (f->getElement() == "KBBlockFooter") footer = f ;
	)

	CITER
	(	Object,
		o,
		if ((o->isFramer() != 0) && o->isFramer()->anyChildBlock())
		{	anyChildBlock = true ;
			break	;
		}
		if ((o->isBlock () != 0) && (o->isBlock()->getBlkType() != KBBlock::BTNull))
		{	anyChildBlock = true ;
			break	;
		}
	)

	/* Clear all items. This is mainly intended when switching into	*/
	/* design mode, to clear field contents.			*/
	CITER
	(	Item,
		i, 
		i->clearBelow (1) ;
	)

	/* Pass the request on down to the base class, which will in	*/
	/* turn recurse down to any children.				*/
	KBObject::showAs (mode) ;

	QRect	r = geometry () ;
	move    (r.x    (),  r.y     ()) ;
	resize  (r.width(),  r.height()) ;

	/* If we are switching out of design mode then clear the slaved	*/
	/* master values (so that the block will requery). Also a fair	*/
	/* time to ensure the tab order is sorted.			*/
	if (showingData())
	{
		curQRow	 = 0 ;
		curDRow	 = 0 ;
	}

	/* Update the display widget, so that we correctly add or	*/
	/* remove the grid and such like.				*/
	blkDisp->getDisplayWidget()->update() ;
}

#if	! __KB_RUNTIME

/*  KBBlock								*/
/*  designPopup	: Handle design menu request				*/
/*  e		: QMouseEvent *	: Associated mouse event		*/
/*  drow	: uint		: Display row				*/
/*  (returns)	: void		:					*/

void	KBBlock::designPopup
	(	QMouseEvent	*e,
		uint
	)
{
	KBPopupMenu popupMain	(&bState ) ;
	KBPopupMenu *popupEdit	= new KBPopupMenu (&bState ) ;

	KBNode	*dummy	;

	bool	noBlk	= topLevel	;
	bool	noQry	= false		;

	switch (blkType)
	{

		case BTSubBlock	:
			noBlk	= true	;
			noQry	= true	;
			break	;

		case BTNull	:
			noQry	= true	;
			break	;

		case BTTable	:
		case BTQuery	:
		case BTSQL	:
		case BTDesign	:
			break	;

		default	:
			break	;
	}


	bool	noIns	= !KBFormCopier::self()->anyCopied(dummy) ;
	bool	noItem	= true	   ;
	CITER (Item, i, noItem = false ; break )

	popupEdit->insertEntry (noBlk,	TR("C&ut block"),	this, SLOT(cutObj        ())) ;
	popupEdit->insertEntry (noBlk,	TR("&Copy block"),      this, SLOT(copyObj       ())) ;
	popupEdit->insertEntry (noIns,  TR("&Paste objects"),   this, SLOT(pasteObjects  ())) ;
	popupEdit->insertEntry (noIns,  TR("Paste &here"),	this, SLOT(pasteHere     ())) ;
	popupEdit->insertEntry (false,  TR("Paste component"),  this, SLOT(pasteComponent())) ;
	popupEdit->insertEntry (false,  TR("Link component"),	this, SLOT(linkComponent ())) ;
	popupEdit->insertEntry (noBlk,	TR("&Delete block"),    this, SLOT(deleteObj     ())) ;
 
	popupMain .insertItem  (TR("Cancel")) ;
	popupMain .insertItem  (TR("&Edit" ), popupEdit) ;
	popupMain .insertItem  (TR("&New"  ), makeNewPopup(false, QRect())) ;

	if (isFormBlock())
		popupMain .insertEntry (noItem, TR("Set tab order"), this, SLOT(newTabOrder ())) ;

	popupMain .insertItem  (TR("Block &properties"), 	this, SLOT(blockPropDlg())) ;
	popupMain .insertItem  (TR("&Document properties"),	this, SLOT(docPropDlg  ())) ;
	popupMain .insertItem  (TR("&Show query"),		this, SLOT(showQuery   ())) ;
//	popupMain .insertEntry (noQry,  TR("&Show query"),	this, SLOT(showQuery   ())) ;

	insertAt	= e->pos ()	 ;
	newRect		= QRect  ()	 ;
	popupMain .exec	(QCursor::pos()) ;
}

/*  KBBlock								*/
/*  blockPropDlg: Show block property dialog				*/
/*  iniattr	: cchar *	: Initial attribute			*/ 
/*  (returns)	: bool		: Success				*/

bool	KBBlock::blockPropDlg
	(	cchar	*iniattr
	)
{
	if (!::blockPropDlg (this, "Block", attribs, iniattr))
		return false ;

	/* Special case: This method will be called during form/report	*/
	/* creation, at which time there is no block display.		*/
	if (blkDisp != 0)
	{
		QRect	r1	= geometry() ;
		uint	ssb1	= showbar.getFlags() ;

		blkDisp->setShowbar (ssb1) ;
		blkDisp->setTitle   (title.getValue()) ;

		move	(r1.x    (), r1.y     ()) ;
		resize	(r1.width(), r1.height()) ;

		if (getSizer() != 0)
		{
			getSizer ()->setBlobs ()  ;
			getLayout()->addSizer (getSizer(), false) ;
		}

		if (isFormBlock() != 0)
			isFormBlock()->changeSizes() ;

		CITER
		(	Item,
			i,
			i->reposition()
		)

		setPalette   () ;
		setFont      () ;

		QString	fs	= frame.getValue() ;
		int	coff	= fs.find (',')	   ;

		if (coff >= 0)
			blkDisp->setFrame
			(	fs.left(coff    ).toInt(),
				fs.mid (coff + 1).toInt()
			)	;
		else	blkDisp->setFrame (0, 0) ;

	}

	getLayout()->setChanged() ;
	return	true  ;
}

/*  KBBlock								*/
/*  newCtrlRect	: Get rectangle for new control				*/
/*  (returns)	: QRect		: Rectangle				*/

QRect	KBBlock::newCtrlRect ()
{
	return	newRect == QRect() ?
		getLayout()->newCtrlRect (this, bState, QRect (10, 10, 300, 200)) :
		newRect	;
}

/*  KBBlock								*/
/*  setCtrlRect	: set rectangle for new control				*/
/*  rect	: QRect		: Rectangle				*/
/*  (returns)	: void		:					*/

void	KBBlock::setCtrlRect
	(	QRect		rect
	)
{
	newRect	= rect	;
}

#endif

/*  KBBlock								*/
/*  pasteObjects: Paste in cut or copied objects			*/
/*  (returns)	: void		:					*/

void	KBBlock::pasteObjects ()
{
#if	! __KB_RUNTIME
	insertObjects (blkDisp) ;
#endif
}

/*  KBBlock								*/
/*  pasteHere	: Paste in cut or copied objects at specified position	*/
/*  (returns)	: void		:					*/

void	KBBlock::pasteHere ()
{
#if	! __KB_RUNTIME
	insertHere
	(	KBFormCopier::self()->getCopied (objType()),
		blkDisp,
		insertAt
	)	;
#endif
}

/*  KBBlock								*/
/*  pasteComponent							*/
/*		: Paste component object				*/
/*  (returns)	: void		:					*/

void	KBBlock::pasteComponent ()
{
#if	! __KB_RUNTIME
	insertComponent
	(	blkDisp,
		insertAt,
		newRect,
		true
	)	;
#endif
}

/*  KBBlock								*/
/*  linkComponent							*/
/*		: Link component object					*/
/*  (returns)	: void		:					*/

void	KBBlock::linkComponent ()
{
#if	! __KB_RUNTIME
	insertComponent
	(	blkDisp,
		insertAt,
		newRect,
		false
	)	;
#endif
}

/*  KBBlock								*/
/*  blockPropDlg: Show block property dialog				*/
/*  (returns)	: bool		: Success				*/

bool	KBBlock::blockPropDlg ()
{
#if	__KB_RUNTIME
	return	true	;
#else
	return	blockPropDlg (0) ;
#endif
}

void	KBBlock::showQuery ()
{
#if	! __KB_RUNTIME
	addAllItems ()	;

	QString	sql	= m_query->getSQLText (qryLvl, true) ;
	QString	reason	;

	if (isFormBlock() != 0) reason = m_query->getSQLReason (qryLvl) ;

	KBQryDisplay(sql, reason).exec() ;
#endif
}

