/***************************************************************************
    file	         : kb_blockevents.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_BLOCKEVENTS_H
#define	_KB_BLOCKEVENTS_H

#include "libkbase_exports.h"

class LIBKBASE_API	KBBlockEvents
{
	KBEvent		onAction	;	/* Block action		*/
	KBEvent		onUnCurrent	;	/* Focus leaves row	*/
	KBEvent		onCurrent	;	/* Focus enters row	*/
	KBEvent		onDisplay	;	/* Row displayed	*/
	KBEvent		preQuery	;	/* Data to be retrieved	*/
	KBEvent		preInsert	;	/* Row to be inserted	*/
	KBEvent		preUpdate	;	/* Row to be updated	*/
	KBEvent		preDelete	;	/* Row to be deleted	*/
	KBEvent		postQuery	;	/* Data retrieved	*/
	KBEvent		postSync	;	/* Data synchronised	*/
	KBEvent		onChange	;	/* Any data changes	*/

public	:

	KBBlockEvents	(KBNode *, const QDict<QString> &) ;
	KBBlockEvents	(KBNode *) ;
	KBBlockEvents	(KBNode *, KBBlock *) ;

	friend	class	KBBlock		;
	friend	class	KBFormBlock	;
	friend	class	KBReportBlock	;
	friend	class	KBForm		;
	friend	class	KBReport	;
}	;

#endif	// _KB_BLOCKEVENTS_H
