/***************************************************************************
    file	         : kb_blockevents.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"

#include	"kb_attr.h"
#include	"kb_event.h"
#include	"kb_block.h"
#include	"kb_blockevents.h"
#include	"kb_nodereg.h"


/*  KBBlockEvents							*/
/*  KBBlockEvents: Constructor for block events object			*/
/*  aList	 : ...		: Attributes list			*/
/*  parent	 : KBNode *	: Parent node				*/
/*  (returns)	 : KBBlockEvents: 					*/

KBBlockEvents::KBBlockEvents
	(	KBNode			*parent,
		const QDict<QString>	&aList
	)
	:
	onAction    (parent, "onaction",    "onBlock", aList, KF_FORM),
	onUnCurrent (parent, "onuncurrent", "onBlock", aList, KF_FORM),
	onCurrent   (parent, "oncurrent",   "onBlock", aList),
	onDisplay   (parent, "ondisplay",   "onBlock", aList, KF_FORM),
	preQuery    (parent, "prequery",    "onBlock", aList),
	preInsert   (parent, "preinsert",   "onBlock", aList, KF_FORM),
	preUpdate   (parent, "preupdate",   "onBlock", aList, KF_FORM),
	preDelete   (parent, "predelete",   "onBlock", aList, KF_FORM),
	postQuery   (parent, "postquery",   "onBlock", aList),
	postSync    (parent, "postsync",    "onBlock", aList, KF_FORM),
	onChange    (parent, "onchange",    "onBlock", aList, KF_FORM)
{
}

/*  KBBlockEvents							*/
/*  KBBlockEvents: Constructor for new block events object		*/
/*  parent	 : KBNode *	: Parent node				*/
/*  (returns)	 : KBBlockEvents: 					*/

KBBlockEvents::KBBlockEvents
	(	KBNode		*parent
	)
	:
	onAction    (parent, "onaction",    "onBlock", "", KF_FORM),
	onUnCurrent (parent, "onuncurrent", "onBlock", "", KF_FORM),
	onCurrent   (parent, "oncurrent",   "onBlock", ""),
	onDisplay   (parent, "ondisplay",   "onBlock", "", KF_FORM),
	preQuery    (parent, "prequery",    "onBlock", ""),
	preInsert   (parent, "preinsert",   "onBlock", "", KF_FORM),
	preUpdate   (parent, "preupdate",   "onBlock", "", KF_FORM),
	preDelete   (parent, "predelete",   "onBlock", "", KF_FORM),
	postQuery   (parent, "postquery",   "onBlock", ""),
	postSync    (parent, "postsync",    "onBlock", "", KF_FORM),
	onChange    (parent, "onchange",    "onBlock", "", KF_FORM)
{
}

/*  KBBlockEvents							*/
/*  KBBlockEvents: Constructor for new block events object		*/
/*  parent	 : KBNode *	: Parent node				*/
/*  block	 : KBBlock *	: Block being replicated		*/
/*  (returns)	 : KBBlockEvents: 					*/

KBBlockEvents::KBBlockEvents
	(	KBNode		*parent,
		KBBlock		*block
	)
	:
	onAction    (parent, "onaction",    "onBlock", block, KF_FORM),
	onUnCurrent (parent, "onuncurrent", "onBlock", block, KF_FORM),
	onCurrent   (parent, "oncurrent",   "onBlock", block),
	onDisplay   (parent, "ondisplay",   "onBlock", block, KF_FORM),
	preQuery    (parent, "prequery",    "onBlock", block),
	preInsert   (parent, "preinsert",   "onBlock", block, KF_FORM),
	preUpdate   (parent, "preupdate",   "onBlock", block, KF_FORM),
	preDelete   (parent, "predelete",   "onBlock", block, KF_FORM),
	postQuery   (parent, "postquery",   "onBlock", block),
	postSync    (parent, "postsync",    "onBlock", block, KF_FORM),
	onChange    (parent, "onchange",    "onBlock", block, KF_FORM)
{
}

/*  KBBlockEvents							*/
/*  eventHook	 : Event execution hook					*/
/*  event	 : KBEvent &	: Event to execute			*/
/*  argc	 : uint		: Argument count			*/
/*  argv	 : KBValue *	: Argument vector			*/
/*  evRc	 : bool &	: Event return code			*/
/*  (returns)	 : bool		: No event execution error		*/

bool	KBBlock::eventHook
	(	KBEvent		&event,
		uint		argc,
		KBValue		*argv,
		bool		&evRc
	)
{
	KBValue	resval	;

	switch (event.execute (resval, argc, argv))
	{
		case KB::ScriptInlineError :
			/* Error in an inline script. Display the	*/
			/* properties dialog for the block, starting at	*/
			/* the event.					*/
#if	! __KB_RUNTIME
			blockPropDlg (event.getName()) ;
#endif
			/* Set a generally descriptive error message	*/
			/* and return failure.				*/
			setError
			(	KBError::Error,
				TR("Event execution error in inline script"),
				QString(TR("Event: %1")).arg(event.getLegend()),
				__ERRLOCN
			)	;
			return	false	;

		case KB::ScriptGlobalError :
			/* Error while executing a script. Set an error	*/
			/* message and return failure.			*/
			setError
			(	KBError::Error,
				TR("Script execution error in event"),
				QString(TR("Event: %1")).arg(event.getLegend()),
				__ERRLOCN
			)	;
			return	false	;

		default	:
			break	;
	}

	/* No execution errors, so result is true with "evRc" set to	*/
	/* the value returned by the script.				*/
	evRc	= resval.isTrue() ;
	return	true	;
}
