/***************************************************************************
    file	         : kb_blockdlg.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_BLOCKDLG_H
#define	_KB_BLOCKDLG_H

#if	! __KB_RUNTIME

#include 	"libkbase_exports.h"

#include	<qcombobox.h>
#include	<qspinbox.h>

#include	"kb_itemdlg.h"
#include	"kb_hiddendlg.h"


/*  KBBlockPropDlg							*/
/*  --------------							*/
/*  Wrapper class for qblock properties dialog. Handles special-case	*/
/*  properties.								*/

class	LIBKBASE_API	KBBlockPropDlg : public KBItemPropDlg
{
	Q_OBJECT

	KBHiddenDlg	m_hiddenDlg	;
	QPushButton	m_bQuery  	;
	KBBlock		*m_block 	;

	void		setHidden   	() ;

private slots :

	virtual	cchar	*findHelpMapping(const QString &)	;

protected slots :

	void		clickQuery	() ;
	virtual	void	clickOK		() ;
	virtual	void	clickCancel	() ;

protected :

	virtual	void	resizeEvent	(QResizeEvent *) ;

	virtual KBAttrItem
			*getAttrItem	(KBAttr *) ;
	virtual	void	dropProperty	()	;

	virtual	bool	showProperty	(KBAttrItem *) ;
	virtual	bool	saveProperty	(KBAttrItem *) ;
	virtual	bool	hideProperty	(KBAttr     *) ;
	virtual	bool	propertyOK	(KBAttrItem *) ;
	virtual	void	preExec	    	() ;

public	:

	KBBlockPropDlg (KBBlock *, cchar *, QList<KBAttr> &, cchar * = 0) ;
       ~KBBlockPropDlg () ;
}	;

#endif
#endif	// _KB_BLOCKDLG_H
