/***************************************************************************
    file	         : kb_svrchooser.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdlib.h>

#ifndef 	_WIN32
#include	"kb_svrchooser.moc"
#else
#include	"kb_svrchooser.h"
#endif

#include	"kb_serverinfo.h"



/*  KBSvrChooserDlg							*/
/*  KBSvrChooserDlg							*/
/*		: Simple server selection dialog			*/
/*  dbInfo	: KBDBInfo *	  : Database information		*/
/*  myserver	: const QString & : My server name			*/
/*  withFiles	: bool		  : Include "!Files"			*/
/*  (returns)	: KBSvrChooserDlg :					*/

KBSvrChooserDlg::KBSvrChooserDlg
	(	KBDBInfo	*dbInfo,
		const QString	&myserver,
		bool		withFiles
	)
	:
	_KBDialog	(TR("Select server and forms"), true),
	m_lServer	(this),
	m_cbServer	(this),
	m_cOver		(this),
	m_lbOut		(this),
	m_lbIn		(this),
	m_bAdd		(this),
	m_bAddAll	(this),
	m_bRemove	(this),
	m_bOK		(this),
	m_bCancel	(this)
{
	m_layMain	  = new QVBoxLayout (this)	;

	m_laySelect = new QHBoxLayout (m_layMain  )	;
	m_laySelect->addWidget (&m_lbOut, 1) ;
	m_layAddRem = new QVBoxLayout (m_laySelect)	;
	m_laySelect->addWidget (&m_lbIn,  1) ;
	m_layButt   = new QHBoxLayout (m_layMain  )	;

	m_laySelect->setStretchFactor (m_layAddRem, 0)	;

	m_layAddRem->addWidget (&m_bAdd    ) ;
	m_layAddRem->addWidget (&m_bAddAll ) ;
	m_layAddRem->addWidget (&m_bRemove ) ;
	m_layAddRem->addStretch( ) ;

	m_layButt  ->addWidget (&m_lServer ) ;
	m_layButt  ->addWidget (&m_cbServer) ;
	m_layButt  ->addWidget (&m_cOver   ) ;
	m_layButt  ->addStretch( ) ;

#if	__KB_EMBEDDED
	m_layAddRem->addWidget (&m_bCancel ) ;
	m_layAddRem->addWidget (&m_bOK     ) ;
#else
	m_layButt  ->addWidget (&m_bCancel ) ;
	m_layButt  ->addWidget (&m_bOK     ) ;
#endif

	m_lServer  .setText (TR("Copy to server: ")) ;

	m_cOver	   .setText (TR("Overwrite" )) ;
	m_bAdd	   .setText (TR("Add >>"    )) ;
	m_bAddAll  .setText (TR("Add All >>")) ;
	m_bRemove  .setText (TR("<< Remove" )) ;
	m_bCancel  .setText (TR("Cancel"    )) ;
	m_bOK      .setText (TR("OK"        )) ;

	connect	 (&m_bOK,     SIGNAL(clicked()), SLOT(clickOK    ())) ;
	connect	 (&m_bCancel, SIGNAL(clicked()), SLOT(clickCancel())) ;
	connect	 (&m_bAdd,    SIGNAL(clicked()), SLOT(clickAdd   ())) ;
	connect	 (&m_bAddAll, SIGNAL(clicked()), SLOT(clickAddAll())) ;
	connect	 (&m_bRemove, SIGNAL(clicked()), SLOT(clickRemove())) ;

	connect	 (&m_lbOut,   SIGNAL(doubleClicked(QListBoxItem *)), this, SLOT(clickAdd   ())) ;
	connect  (&m_lbIn,    SIGNAL(doubleClicked(QListBoxItem *)), this, SLOT(clickRemove())) ;

	connect	 (&m_lbIn,    SIGNAL(highlighted(int)), SLOT( inHighlight())) ;
	connect	 (&m_lbOut,   SIGNAL(highlighted(int)), SLOT(outHighlight())) ;

#if	__KB_EMBEDDED
	m_lbOut	 .setMinimumWidth ( 75) ;
	m_lbIn	 .setMinimumWidth ( 75) ;
#else
	m_lbOut	 .setMinimumWidth (150) ;
	m_lbIn	 .setMinimumWidth (150) ;
#endif
	m_bOK	 .setEnabled  (true ) ;
	m_bCancel.setEnabled  (true ) ;

	m_bAdd	 .setEnabled  (false) ;
	m_bAddAll.setEnabled  (false) ;
	m_bRemove.setEnabled  (false) ;

	QListIterator<KBServerInfo> *iter = dbInfo->getServerIter () ;
	KBServerInfo *server ;

	if (withFiles && (myserver != KBLocation::m_pFile))
		m_cbServer.insertItem (KBLocation::m_pFile) ;

	while ((server = iter->current()) != 0)
	{
		(*iter) += 1 ;

		QString	svName	= server->serverName() ;

		if (svName == myserver) continue ;

		KBDBLink dbLink ;
		if (!dbLink.connect (dbInfo, svName, true) )
		{
			if (!dbLink.disabled()) dbLink.lastError().DISPLAY() ;
			continue ;
		}

		m_cbServer.insertItem (svName) ;
	}

	delete	iter	;

}

/*  KBSvrChooserDlg							*/
/*  addEntry	: Add an entry to the out list				*/
/*  entru	: const QString & : Entry				*/
/*  (returns)	: void		  :					*/

void	KBSvrChooserDlg::addEntry
	(	const QString	&entry
	)
{
	m_lbOut	 .insertItem (entry) ;
	m_bAddAll.setEnabled (true ) ;
}

/*  KBSvrChooserDlg							*/
/*  clickOK	: User clicks OK					*/
/*  (returns)	: void		:					*/

void	KBSvrChooserDlg::clickOK ()
{
	done	(true)  ;
}

/*  KBSvrChooserDlg							*/
/*  clickCancel	: User clicks cancel					*/
/*  (returns)	: void		:					*/

void	KBSvrChooserDlg::clickCancel ()
{
	done	(false) ;
}

/*  KBSvrChooserDlg							*/
/*  clickAdd	: User clicks add button				*/
/*  (returns)	: void		:					*/

void	KBSvrChooserDlg::clickAdd ()
{
	int item = m_lbOut.currentItem () ;

	if (item >= 0)
	{	m_lbIn .insertItem (m_lbOut.text(item)) ;
		m_lbOut.removeItem (item) ;
	}

	m_bAdd   .setEnabled (m_lbOut.currentItem() >= 0) ;
	m_bAddAll.setEnabled (m_lbOut.count      () >  0) ;
}

/*  KBSvrChooserDlg							*/
/*  clickAddAll	: User clicks add all button				*/
/*  (returns)	: void		:					*/

void	KBSvrChooserDlg::clickAddAll ()
{
	while (m_lbOut.count() > 0)
	{
		m_lbIn .insertItem (m_lbOut.text(0)) ;
		m_lbOut.removeItem (0) ;
	}

	m_bAdd	 .setEnabled (false) ;
	m_bAddAll.setEnabled (false) ;
}

/*  KBSvrChooserDlg							*/
/*  clickRemove	: User clicks remove button				*/
/*  (returns)	: void		:					*/

void	KBSvrChooserDlg::clickRemove ()
{
	int item = m_lbIn.currentItem () ;

	if (item >= 0)
	{	m_lbOut.insertItem (m_lbIn.text(item)) ;
		m_lbIn .removeItem (item) ;
	}

	m_bRemove.setEnabled (m_lbIn.currentItem() >= 0) ;
	m_bAddAll.setEnabled (true) ;
}

/*  KBSvrChooserDlg							*/
/*  inHighlight	: User clicks on item in "in" list			*/
/*  (returns)	: void		:					*/

void	KBSvrChooserDlg::inHighlight ()
{
	m_bRemove.setEnabled (true) ;
}

/*  KBSvrChooserDlg							*/
/*  inHighlight	: User clicks on item in "out" list			*/
/*  (returns)	: void		:					*/

void	KBSvrChooserDlg::outHighlight ()
{
	m_bAdd.setEnabled (true) ;
}

/*  KBSvrChooserDlg							*/
/*  getInfo	: Get results						*/
/*  server	: QString &	: Selected server			*/
/*  entries	: QStringList &	: List of entries from "in" list	*/
/*  over	: bool &	: Overwrite option checked		*/
/*  (returns)	: void		:					*/

void	KBSvrChooserDlg::getInfo
	(	QString		&server,
		QStringList	&entries,
		bool		&over
	)
{
	server	= m_cbServer.currentText() ;
	over	= m_cOver   .isChecked  () ;

	for (uint idx = 0 ; idx < m_lbIn.count() ; idx += 1)
		entries.append (m_lbIn.text (idx)) ;
}
