/***************************************************************************
    file	         : kb_debug.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef  _KB_DEBUG_H
#define  _KB_DEBUG_H


#include	"kb_classes.h"
#include	"kb_location.h"
#include	"kb_partwidget.h"
#include	"kb_part.h"

#include "libapp_exports.h"

class	TKConfig	;

/*  KBDebug								*/
/*  --------								*/
/*  Base class for debuggers						*/

class LIBAPP_API KBDebug : public KBasePart
{
	Q_OBJECT

	TKToggleAction	*m_action	;
	QString		m_language	;
	KBaseGUI	*m_gui		;

protected :

	QSize		m_size		;
	KBScriptIF	*m_scrIface	;

public	:

		 KBDebug (TKToggleAction *, const QString &) ;
	virtual	~KBDebug () ;

	virtual	void	cleanup	   () {} ;
	virtual	void	hide	   () ;
	virtual	bool	queryClose () ;

	inline	KBScriptIF *getScriptIface ()
	{
		return	m_scrIface ;
	}

	TKConfig	*getConfig	() ;
	virtual	bool	debugScript	(KBLocation &, KBError &) = 0 ;
}	;

#endif // _KB_DEBUG_H
