/***************************************************************************
    file	         : kb_partwidget.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef  __KB_PARTWIDGET_H
#define  __KB_PARTWIDGET_H


#include	<qsizegrip.h>
#include	<qguardedptr.h>

#include	"kb_classes.h"
#include	"kb_gui.h"

#include	"tk_part.h"

#include 	"libapp_exports.h"

class	QStatusBar	;

class	KBaseApp	;
class	KBasePart	;
class	KBFormViewer	;
class	KBReportViewer	;
class	KBDBaseViewer	;
class	KBTableViewer	;
class	KBQueryViewer	;
class	KBTextLog	;
class	KBEditor	;
class	KBPartWidget	;

#include	"tk_part.h"
#include	"tk_mainwindow.h"


/*  KBSDIMainWindow							*/
/*  ---------------							*/
/*  Instances of this class are used when running in MDI top-level mode	*/

class	LIBAPP_API	KBSDIMainWindow : public TKMainWindow
{
	Q_OBJECT

	QGuardedPtr<KBasePart>
			m_part	    	;	/* Associated part	*/
	bool		m_modal	    	;	/* Runs as modal	*/
	bool		m_inModalLoop	;	/* Executing modal loop	*/

protected :

	virtual void	closeEvent	(QCloseEvent *) ;

public	:

	KBSDIMainWindow (KBasePart *, bool = false) ;
       ~KBSDIMainWindow (); 

#if	__KB_KDE
	virtual	KAction *action	        (const QDomElement &) const ;
#endif
#if	__KB_TKC
	virtual	TKAction*action	        (const QDomElement &) const ;
#endif

	void		resetGUI	() ;
	void		exitModal	() ;


#if     QT_VERSION >= 300
	inline	void	setModal	()
	{
		setWFlags   (Qt::WType_Modal ) ;
	}
	inline	void	clearModal	()
	{
		clearWFlags (Qt::WType_Modal ) ;
	}
#else	// QT_VERSION >= 300
	inline	void	setModal	()
	{
		setWFlags   (Qt::WType_Modal ) ;
		setWState   (Qt::WState_Modal) ;
	}
	inline	void	clearModal	()
	{
		clearWFlags (Qt::WType_Modal ) ;
		clearWState (Qt::WState_Modal) ;
	}
#endif	// QT_VERSION >= 300

	KB::ShowRC	goModal	(KB::ShowMode) ;
}	;


/*  KBPartWidget								*/
/*  -----------								*/
/*  This is the top-level widget for each MDI child/plugin. It is	*/
/*  used to provide some specialised handling of close and resize, and	*/
/*  also as a work-around for an XML-GUI problem (see setGUI method).	*/

class	LIBAPP_API KBPartWidget : public QWidget
{
	Q_OBJECT

	QGuardedPtr<KBasePart>		m_part		;
	QGuardedPtr<KBSDIMainWindow>	m_mainWin	;

	bool				m_connected	;

#if	! __KB_EMBEDDED
	QSizeGrip			*m_sizeGrip	;
#endif

signals	:

	void		changeGUI	(TKPart *) ;

protected :

	virtual	void	resizeEvent   	(QResizeEvent *) ;
	virtual	void	closeEvent    	(QCloseEvent  *) ;

public	:

	KBPartWidget	(QWidget *, KBasePart *, int, KBSDIMainWindow * = 0) ;
	virtual		~KBPartWidget ()	;

	void		setGUI		(KBaseGUI *gui)  ;
	void		resize		(int, int, bool, bool) ;
	void		showMaximized	()		 ;
	QSize		size		()		 ;
	QWidget		*mainWidget	()		 ;
	QStatusBar	*statusBar	()		 ;
	void		showMenuToolBars(bool, bool)	 ;

	void		deparent	()		 ;
	
	KB::ShowRC	show		(bool = false, KB::ShowMode = KB::ShowAuto) ;

	virtual	void	hide		()		 ;
	virtual	void	setCaption	(const QString &);
}	;

#endif // __KB_PARTWIDGET_H
