/***************************************************************************
    file	         : kb_serverdata.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kbase.h"
#include	"kb_serverdata.h"
#include	"kb_passdlg.h"

#include	"tk_messagebox.h"


KBServerData::KBServerData
	(	KBDBInfo 		*dbInfo
	)
	:
	KBServerInfo (dbInfo)
{
	fprintf	(stderr, "KBServerData::KBServerData (dbInfo)\n") ;
}

KBServerData::KBServerData
	(	KBDBInfo 		*dbInfo,
		const KBServerInfo	*svInfo
	)
	:
	KBServerInfo (dbInfo, svInfo)
{
	fprintf	(stderr, "KBServerData::KBServerData (svInfo)\n") ;
	m_rawSQL = 0 ;
}

KBServerData::KBServerData
	(	KBDBInfo 		*dbInfo,
		cchar 			*spec
	)
	:
	KBServerInfo (dbInfo, spec)
{
	fprintf	(stderr, "KBServerData::KBServerData (bsf)\n") ;
	m_rawSQL = 0 ;
}

KBServerData::KBServerData
	(	KBDBInfo 		*dbInfo,
		const QDomElement  	&spec
	)
	:
	KBServerInfo (dbInfo, spec)
{
	fprintf	(stderr, "KBServerData::KBServerData (xml)\n") ;
	m_rawSQL = 0 ;
}

KBServerData::KBServerData
	(	KBDBInfo 	*dbInfo,
		cchar		*serverName,
		cchar		*dbType,
		cchar		*hostName,
		cchar		*dbName,
		cchar		*userName,
		cchar		*password	
	)
	:
	KBServerInfo
	(	dbInfo,
		serverName,
		dbType,
		hostName,
		dbName,
		userName,
		password	
	)
{
	fprintf	(stderr, "KBServerData::KBServerData (explicit)\n") ;
	m_rawSQL = 0 ;
}

KBServerData::~KBServerData ()
{
	DELOBJ	(m_rawSQL) ;
}

bool	KBServerData::promptMakeDesignDict ()
{
	return	TKMessageBox::questionYesNo
		(	0,
			QString (TR("Database %1 on server %2 lacks a design dictionary: create one?"))
				.arg(m_dbName)
				.arg(m_serverName),
			TR("Create design dictionary")
		)
		== TKMessageBox::Yes ;
}

bool	KBServerData::promptMakeObjTable ()
{
	return	TKMessageBox::questionYesNo
		(	0,
			QString (TR("Database %1 on server %2 lacks a object table: create one?"))
				.arg(m_dbName)
				.arg(m_serverName),
			TR("Create ob#ject table")
		)
		== TKMessageBox::Yes ;
}

bool	KBServerData::promptUserPassword
	(	KBError		&pError
	)
{
	KBPassDlg passDlg
	(	TR("User name/Password"),
		QString
		(	TR
			(	"Connecting to server \"%1\"\n"
				"Please enter RDBMS user name\n"
				"and password"
		)	)
			.arg(m_serverName),
		m_useUserName,
		m_usePassword
	)	;

	if (!passDlg.exec())
	{
		pError	= KBError
			  (	KBError::Warning,
			  	TR("No user name or password"),
			  	TR("User cancelled password dialog"),
			  	__ERRLOCN
			  ) ;
		return	false	;
	}

	m_useUserName	= passDlg.password() ;
	m_usePassword	= passDlg.userName() ;
	return	true	;
}


void	KBServerData::showRawSQL
	(	KBaseApp	*kbaseApp
	)
{
	if (m_dbType.isEmpty())
	{
		TKMessageBox::sorry
		(	0,
			QString	(TR("Server %1 does not access a database")).arg(m_serverName),
			TR("SQL Window")
		)	;
		return	;
	}

	if (!m_rawSQL)
		m_rawSQL = kbaseApp->showRawSQL (m_dbInfo, m_serverName) ;
	else	DELOBJ	 (m_rawSQL) ;
}




/*  ------------------------------------------------------------------  */

/*  KBDBInfoData: Constructor for application KBDBInfo wrapper		*/
/*  dbName	: const QString &: Information file name		*/
/*  create	: bool		 : Create new database			*/
/*  (returns)	: KBDBInfo	 : Database information			*/

KBDBInfoData::KBDBInfoData
	(	const	QString		&dbName
	)
	:
	KBDBInfo (dbName)
{
	fprintf	(stderr, "KBDBInfoData::KBDBInfoData [%s]\n", (cchar *)dbName) ;
}


KBDBInfoData::~KBDBInfoData ()
{
}

KBServerInfo
	*KBDBInfoData::newServerInfo ()
{
	return	new KBServerData (this) ;
}

KBServerInfo
	*KBDBInfoData::newServerInfo
	(	const QString		&spec
	)
{
	return	new KBServerData (this, spec) ;
}

KBServerInfo
	*KBDBInfoData::newServerInfo
	(	const QDomElement	&elem
	)
{
	return	new KBServerData (this, elem) ;
}

KBServerData
	*KBDBInfoData::findServer
	(	const QString		&server
	)
{
	return	(KBServerData *)KBDBInfo::findServer(server) ;
}
