/***************************************************************************
    file	         : kb_querylog.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef  _KB_QUERYLOG_H
#define  _KB_QUERYLOG_H


#include	<qlistview.h>
#include	<qtextview.h>
#include 	<qsplitter.h>

#include	"kb_classes.h"
#include	"kb_part.h"


/*  KBQueryLogEntry							*/
/*  ---------------							*/
/*  QListViewItem derived class, used to store additional query		*/
/*  inforamation.							*/

class	KBQueryLogEntry : public QListViewItem
{
	QStringList	m_args	;
	QStringList	m_types	;
	bool		m_extra	;

public	:

	KBQueryLogEntry
	(	QListView	*,
		QListViewItem	*,
		uint		,
		const QString	&,
		const QString	&,
		bool		,
		uint		,
		const KBValue	*
	)	;

	inline	QString	getQuery ()
	{
		return	text (3) ;
	}

	void	showArgs	 (QListView *) ;
}	;



/*  KBQueryLog								*/
/*  ----------								*/
/*  This class provides a quwry logging window, where the number of	*/
/*  queries is limited to some value, and new queries are appended at	*/
/*  the end. It uses a QTextView to do the display so that the RTF	*/
/*  features can be used.						*/

class	KBQueryLog : public KBasePart
{
	Q_OBJECT

	QSplitter	*m_split  ;
	QTextView	*m_query  ;	/* Query display window		*/
	QListView	*m_args	  ;	/* Query arguments		*/
	QListView	*m_log	  ;	/* Query list			*/
	KBaseGUI	*m_gui	  ;	/* GUI for this window		*/
	TKToggleAction	*m_action ;	/* GUI show/hide action		*/
	uint		m_count	  ;	/* Query count			*/
	QListViewItem	*m_last	  ;	/* Last inserted item		*/

private slots :

	void		clickQuery	(QListViewItem *) ;
	void		clearLog	() ;

public	:

		 KBQueryLog (QWidget *, const QString &, TKToggleAction *) ;
	virtual	~KBQueryLog () ;

	virtual	bool	queryClose	() ;

	void		logQuery	(const QString &, const QString &, bool, uint, const KBValue *) ;
}	;

#endif // _KB_QUERYLOG_H
