/*
 * This file contains miscellaneous pieces of code which regfio.c
 * depends upon, from the Samba Subversion tree.  See:
 *   http://websvn.samba.org/cgi-bin/viewcvs.cgi/trunk/source/
 *
 * Copyright (C) 2005,2009 Timothy D. Morgan
 * Copyright (C) 1992-2005 Samba development team 
 *               (see individual files under Subversion for details.)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: smb_deps.h 134 2009-01-16 18:36:04Z tim $
 */

#ifndef _SMB_DEPS_H
#define _SMB_DEPS_H

#include <stdlib.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>

#include "byteorder.h"

#define DEBUG(lvl,body) 0

void* zalloc(size_t size);
void* zcalloc(size_t size, unsigned int count);

/* From includes.h */

#define uint8  uint8_t
#define int16  int8_t
#define uint16 uint16_t
#define int32  int32_t
#define uint32 uint32_t

#define MIN(a,b) ((a)<(b)?(a):(b))
#define MAX(a,b) ((a)>(b)?(a):(b))

extern int DEBUGLEVEL;

/* End of stuff from includes.h */

/* From smb.h */

typedef struct nttime_info
{
  uint32 low;
  uint32 high;
} NTTIME;

/* End of stuff from smb.h */

/* From lib/time.c */

#define CHAR_BIT 8
#define TIME_T_MIN ((time_t)0 < (time_t) -1 ? (time_t) 0 \
		    : ~ (time_t) 0 << (sizeof (time_t) * CHAR_BIT - 1))
#define TIME_T_MAX (~ (time_t) 0 - TIME_T_MIN)
#define TIME_FIXUP_CONSTANT (369.0*365.25*24*60*60-(3.0*24*60*60+6.0*60*60))

void unix_to_nt_time(NTTIME* nt, time_t t);
time_t nt_time_to_unix(const NTTIME* nt);

/* End of stuff from lib/time.c */

#endif /* _SMB_DEPS_H */
