/******************************************************************************
*		       							      *
* engine/debug.c (part of rcalc)				       	      *
* Copyright (C) 2000, 2001 Free Software Foundation, Inc.		      *
*								       	      *
* This program is free software; you can redistribute it and/or modify 	      *
* it under the terms of the GNU General Public License as published by 	      *
* the Free Software Foundation; either version 2 of the License, or    	      *
* (at your option) any later version.				       	      *
*								       	      *
* This program is distributed in the hope that it will be useful,      	      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       	      *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	       	      *
* GNU General Public License for more details.			       	      *
*								       	      *
* You should have received a copy of the GNU General Public License    	      *
* along with this program; if not, write to the Free Software	       	      *
* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.	       	      *
*								       	      *
******************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <debug.h>		/* This file's header	     		*/

#include <stdio.h>
#include <stdarg.h>

static RcDebug debugging = 0;

void rc_debug_add_state( RcDebug what )
{
	debugging |= what;
}

void rc_debug( RcDebug msgtype, const gchar *format, ... )
{
	gchar *prefix, *message;
	va_list args;

	/* Do we print this message?
	*/
	if(!( debugging & msgtype )) return;

	/* What prefix must we attach?
	*/
	if( msgtype == RC_DBG_TOPLEVEL )
		prefix = "toplevel";
	else if( msgtype == RC_DBG_GNOMEUI )
		prefix = "gnomeui";
	else if( msgtype == RC_DBG_ENGINE )
		prefix = "engine";
	else
		prefix = "unknown";
	
	va_start( args, format );
	message = g_strdup_vprintf( format, args );
	va_end( args );

	g_log( PACKAGE, G_LOG_LEVEL_DEBUG, "%s: %s", prefix, message );
	g_free( message );
}

/*** end of engine/debug.c ***************************************************/
