# Debug.py
# Copyright (c) 2005 Alex Revo
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Import the required system modules.
import sys
import time
import traceback
import types


class Debug:
    # To enable debugging messages set to 1 (0 to disable)
    DEBUG = 1


    def __init__(self):
        pass


    def debug(self, message):
        """
        Output message if debugging is enabled.
        """

        if (self.DEBUG):
            print("\x1b[32;02m[%s]\x1b[0m \x1b[33;01m[%s]\x1b[0m %s" %
                  (time.strftime("%Y%m%d %T"),
                  str(self.__module__),
                  str(message)))


    def handle_exception(self, error):
        """
        Print debug info about exception.
        """

        # Based on code from http://www.linuxjournal.com/article.php?sid=5821.

        (exc_class, exc_details, exc_traceback) = sys.exc_info()
        exc_name = exc_class.__name__
        exc_ftraceback = traceback.format_tb(exc_traceback, 10)

        self.debug("\x1b[31;01m[EXCEPTION]\x1b[0m %s:" % str(exc_name))
        for exception in exc_ftraceback:
            map(lambda x: self.debug("%s" % x.rstrip()),
                exception.split("\n"))
        self.debug("\x1b[31;01m[/EXCEPTION]\x1b[0m")
