# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2023 Raritan Inc. All rights reserved.
#
# This is an auto-generated file.

#
# Section generated by IdlC from "TestDisplay.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.test


# interface
class Display(Interface):
    idlType = "test.Display:2.0.0"

    # enumeration
    class Orientation(Enumeration):
        idlType = "test.Display_2_0_0.Orientation:1.0.0"
        values = ["NORMAL", "FLIPPED", "LEFT", "RIGHT"]

    Orientation.NORMAL = Orientation(0)
    Orientation.FLIPPED = Orientation(1)
    Orientation.LEFT = Orientation(2)
    Orientation.RIGHT = Orientation(3)

    # structure
    class Info(Structure):
        idlType = "test.Display_2_0_0.Info:1.0.0"
        elements = ["type", "address", "options", "orientation"]

        def __init__(self, type, address, options, orientation):
            typecheck.is_string(type, AssertionError)
            typecheck.is_string(address, AssertionError)
            typecheck.is_enum(orientation, raritan.rpc.test.Display.Orientation, AssertionError)

            self.type = type
            self.address = address
            self.options = options
            self.orientation = orientation

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                type = json['type'],
                address = json['address'],
                options = dict([(
                    elem['key'],
                    elem['value'])
                    for elem in json['options']]),
                orientation = raritan.rpc.test.Display.Orientation.decode(json['orientation']),
            )
            return obj

        def encode(self):
            json = {}
            json['type'] = self.type
            json['address'] = self.address
            json['options'] = [dict(
                key = k,
                value = v)
                for k, v in self.options.items()]
            json['orientation'] = raritan.rpc.test.Display.Orientation.encode(self.orientation)
            return json

    class _getInfo(Interface.Method):
        name = 'getInfo'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.test.Display.Info.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.test.Display.Info, DecodeException)
            return _ret_

    class _testSequence(Interface.Method):
        name = 'testSequence'

        @staticmethod
        def encode(cycleTime_ms):
            typecheck.is_int(cycleTime_ms, AssertionError)
            args = {}
            args['cycleTime_ms'] = cycleTime_ms
            return args

        @staticmethod
        def decode(rsp, agent):
            return None

    # enumeration
    class TestStatus(Enumeration):
        idlType = "test.Display_2_0_0.TestStatus:1.0.0"
        values = ["TEST_IDLE", "TEST_BUSY", "TEST_PASSED", "TEST_FAILED"]

    TestStatus.TEST_IDLE = TestStatus(0)
    TestStatus.TEST_BUSY = TestStatus(1)
    TestStatus.TEST_PASSED = TestStatus(2)
    TestStatus.TEST_FAILED = TestStatus(3)

    class _enterTestMode(Interface.Method):
        name = 'enterTestMode'

        @staticmethod
        def encode(showColorNames):
            typecheck.is_bool(showColorNames, AssertionError)
            args = {}
            args['showColorNames'] = showColorNames
            return args

        @staticmethod
        def decode(rsp, agent):
            return None

    class _getTestStatus(Interface.Method):
        name = 'getTestStatus'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.test.Display.TestStatus.decode(rsp['_ret_'])
            typecheck.is_enum(_ret_, raritan.rpc.test.Display.TestStatus, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Display, self).__init__(target, agent)
        self.getInfo = Display._getInfo(self)
        self.testSequence = Display._testSequence(self)
        self.enterTestMode = Display._enterTestMode(self)
        self.getTestStatus = Display._getTestStatus(self)

#
# Section generated by IdlC from "TestUnit.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.test


# interface
class Unit(Interface):
    idlType = "test.Unit:2.0.0"

    class _getDisplays(Interface.Method):
        name = 'getDisplays'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [Interface.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_interface(x0, raritan.rpc.test.Display, DecodeException)
            return _ret_

    class _getButtonStates(Interface.Method):
        name = 'getButtonStates'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [x0 for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_bool(x0, DecodeException)
            return _ret_

    class _setBuzzer(Interface.Method):
        name = 'setBuzzer'

        @staticmethod
        def encode(isOn):
            typecheck.is_bool(isOn, AssertionError)
            args = {}
            args['isOn'] = isOn
            return args

        @staticmethod
        def decode(rsp, agent):
            return None

    class _resetAllSubControllers(Interface.Method):
        name = 'resetAllSubControllers'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            return None

    class _triggerSubControllerWatchdog(Interface.Method):
        name = 'triggerSubControllerWatchdog'

        @staticmethod
        def encode(rs485Addr):
            typecheck.is_int(rs485Addr, AssertionError)
            args = {}
            args['rs485Addr'] = rs485Addr
            return args

        @staticmethod
        def decode(rsp, agent):
            return None
    def __init__(self, target, agent):
        super(Unit, self).__init__(target, agent)
        self.getDisplays = Unit._getDisplays(self)
        self.getButtonStates = Unit._getButtonStates(self)
        self.setBuzzer = Unit._setBuzzer(self)
        self.resetAllSubControllers = Unit._resetAllSubControllers(self)
        self.triggerSubControllerWatchdog = Unit._triggerSubControllerWatchdog(self)
