/*
 * ====================================================================
 * Copyright (c) 2002-2006 The RapidSvn Group.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (in the file GPL.txt); if not, write to 
 * the Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 *
 * This software consists of voluntary contributions made by many
 * individuals.  For exact contribution history, see the revision
 * history and logs, available at http://rapidsvn.tigris.org/.
 * ====================================================================
 */

// wxWidgets
#include "wx/wx.h"
#include "wx/valgen.h"

// app
#include "delete_dlg.hpp"

struct DeleteDlg::Data
{
public:
  bool force;

  Data (wxWindow * window)
    : force (false)
  {
    wxBoxSizer *mainSizer = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer *topSizer = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer *buttonSizer = new wxBoxSizer(wxHORIZONTAL);

    wxStaticText * label =
      new wxStaticText (window, -1, _("Do you want to delete the selected files/directories?"));
    topSizer->Add (label, 0, wxALL, 5);

    // The "force" check box:
    wxCheckBox* check = new wxCheckBox(window, -1, _("Force removal"),
      wxDefaultPosition, wxDefaultSize, 0,
      wxGenericValidator(&force));

    // The buttons:
    buttonSizer->Add(new wxButton( window, wxID_OK, _("OK" )), 0,
                     wxALL, 10);
    buttonSizer->Add(new wxButton( window, wxID_CANCEL, _("Cancel")), 0,
                     wxALL, 10);

    // Add all the sizers to the main sizer
    mainSizer->Add (topSizer, 1, wxLEFT | wxRIGHT | wxEXPAND, 5);
    mainSizer->Add (check, 0, wxALL | wxALIGN_CENTER_HORIZONTAL, 5);
    mainSizer->Add (buttonSizer, 0, wxLEFT | wxRIGHT | wxCENTER, 5);

    window->SetAutoLayout(true);
    window->SetSizer(mainSizer);

    mainSizer->SetSizeHints(window);
    mainSizer->Fit(window);
  }
};


BEGIN_EVENT_TABLE (DeleteDlg, wxDialog)
END_EVENT_TABLE ()

DeleteDlg::DeleteDlg(wxWindow* parent)
 : wxDialog(parent, -1, _("Delete"),
            wxDefaultPosition, wxDefaultSize,
            wxDEFAULT_DIALOG_STYLE | wxRESIZE_BORDER)
{
  m = new Data (this);
}

DeleteDlg::~DeleteDlg ()
{
  delete m;
}

bool
DeleteDlg::GetForce () const
{
  return m->force;
}

/* -----------------------------------------------------------------
 * local variables:
 * eval: (load-file "../rapidsvn-dev.el")
 * end:
 */
