/*
 * ====================================================================
 * Copyright (c) 2002-2006 The RapidSvn Group.  All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library (in the file LGPL.txt); if not, 
 * write to the Free Software Foundation, Inc., 51 Franklin St, 
 * Fifth Floor, Boston, MA  02110-1301  USA
 *
 * This software consists of voluntary contributions made by many
 * individuals.  For exact contribution history, see the revision
 * history and logs, available at http://rapidsvn.tigris.org/.
 * ====================================================================
 */

#ifndef _SVNCPP_URL_H_
#define _SVNCPP_URL_H_

// stl
#include <string>
#include <vector>


namespace svn
{
  class Url
  {
  public:
    /** Constructor */
    Url ();

    /** Destructor */
    virtual ~Url ();

    /**
     * Checks if @a url is valid
     *
     * Example of a valid URL:
     *   http://svn.collab.net/repos/svn
     * Example of an invalid URL:
     *   /home/foo/bar
     */
    static bool
    isValid (const char * urlToValidate);

    /**
     * returns a url with forbidden charachters like spaces escaped
     *
     * Example of input:
     *   http://rapidsvn.tigris.org/x y z.html
     * Output:
     *   http://rapidsvn.tigris.org/x%20y%20z.html
     */
    static std::string
    escape (const char * url);

    /**
     * returns a vector with url schemas that are
     * supported by svn 
     *
     * @return vector with entries like "file:", "http:"
     * @deprecated since 0.9.1 (returns an empty vector now)
     */
    static std::vector<std::string>
    supportedSchemas ();
  };
}

#endif
/* -----------------------------------------------------------------
 * local variables:
 * eval: (load-file "../../rapidsvn-dev.el")
 * end:
 */

