# Announce: Rakudo Perl 6 compiler, Release #103 (2016.09)

On behalf of the Rakudo development team, I’m very happy to announce the
September 2016 release of Rakudo Perl 6 #103. Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1].

This release implements the 6.c version of the Perl 6 specifications.
It includes bugfixes and optimizations on top of
the 2015.12 release of Rakudo, but no new features.

Upcoming releases in 2016 will include new functionality that is not
part of the 6.c specification, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of the
6.c specification will continue to work unchanged. There may be incremental
spec releases this year as well.

The tarball for this release is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] --- it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

The changes in this release are outlined below:

New in 2016.09:
 + Fixes:
    + Various improvements to the content of error messages
    + Defaults on a slurpy params now throw instead of crashing at the VM level
    + Distribution::Path now handles native libraries correctly
    + Junctions now work in .classify
    + Control statements (e.g. `next`) in toplevel REPL now show useful error
    + IO::Handle.encoding now returns correct values
    + .comb/.split on binary handles now throws X::NYI
    + Fixed filehandle leak in precompilation
    + Regex in .grep and .first on Pairs now works correctly
    + Pod parser returns proper Bool instead of Int on passed config options
    + Fixed PERL6_TEST_DIE_ON_FAIL=1 exiting the test suite too soon
        or dieing on failing tests inside TODOed subtests
    + Fixed failure to accept enums as types for optional arguments
    + Fixed blocking bug when using socket accept and threads
    + Fixed fatal bug when using Non-ASCII tokens in regex/grammars
    + Fixed missing adverbs and candidates in Cool.split; made same as Str.split
    + Fixed missing adverbs in Cool.trans; made same as Str.trans
    + Fixed NativeCall CArray hanging when created from empty list
    + Fixed various issues with reading chars from an async socket (uncatchable
        exceptions on decode errors, and mis-handling of graphemes and multi-byte
        sequences over packet boundaries)
    + Fixed "%%foo @@bar" interpolation trying to find %foo and @bar variables
    + Fixed mis-compilation and possible compiler crash when using a construct
      like /$<cap>=@(1,2)/
    + Fixed a memory leak involving EVAL
    + Fixed a multi-dispatch cache unbounded growth bug involving calls
        with many named arguments
    + Fixed warnings emitted when using hyper operators on two hashes
    + Channel.elems now returns a Failure rather than eating all values
    + Fixed type error ion IO::Path.rw
    + Fixed …, ???, and !!! yadas not working to stub classes
    + Fixed tab-completion issues with non-identifiers in REPL
 + Additions:
    + Coercions now work in return types
    + Added RAKUDO_EXCEPTIONS_HANDLER env var to control exceptions output
    + IO::Handle.slurp-rest now has :close flag
    + CompUnit::Repository::Installation now cleans up short-name
        folders when empty
    + Added support for very large numbers in :42foo colon pairs
    + Added a .Map coercer for object hashes
    + All Unicode quotes can now be used as quoters inside qqww/qww
    + LEFT/RIGHT DOUBLE PARENTHESIS characters can now be used with q and others
    + Unicode digits can now be used with Match variables ($١), quote
        pairs (:۳<12>), negative numbers (-١), and radix bases (:۳("22"))
 + Efficiency:
    + Numerous improvements in CUR, offering up to 10x faster module loading
    + Baggy.ACCEPTS(Baggy) is now about 25x faster
    + Baggy eqv Baggy is now at least 10x faster
    + Infix === now checks identicality, offering performance gains on large
        objects, such as a Bag with 1000 elements
    + Many metaops are now about 10% faster
    + Made Junction.Bool|ACCEPTS about 2x faster
    + Improvement in performance of IO::Path::child
    + Made permutations() about 5x faster
    + Made List.permutations about 40x faster
    + Made combinations() about 1.8x faster
    + Made List.combinations about 7x faster
    + Made Unix's canonpath several times faster for simple paths
    + Made Buf|Blob.reverse 1.5x faster
    + Made .IO.lines about 10% faster on large files
 + Changed APIs:
    + The operator precedence configuration rule `O()` has been changed to be
        more precompilation-friendly; rather than taking a string containing
        colonpairs, it now takes named arguments directly. This is not
        strictly a Perl 6 change, but rather a change in NQP, and thus only
        applies if you're doing fairly involved hacking on the grammar. If the
        sentences above made no sense to you, your code is not affected by
        this change.


The following people contributed to this release:

Zoffix Znet, Elizabeth Mattijsen, Jonathan Worthington, Daniel Green, 
Tom Browder, Jan-Olof Hendig, Will "Coke" Coleda, Stefan Seifert, LemonBoy, 
Pawel Murias, Timo Paulssen, Itsuki Toyota, Christian Bartolomäus, 
Arne Skjærholt, Moritz Lenz, Jonathan Stowe, Rob Hoelz, Armand Halbert, 
Brock Wilcox, Wenzel P. P. Peppmeyer, Larry Wall, Altai-man, Steve Mynott, 
Nick Logan, Aleks-Daniel Jakimenko-Aleksejev, Thor Michael Støre, 
Jonas Kramer, Douglas L. Schrag, cygx, dmaestro, Sterling Hanenkamp, 
Leon Timmermans

If you would like to contribute or find out more information, visit
<http://perl6.org>, <http://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Perl 6 development: <https://donate.perlfoundation.org/>
(put "Perl 6 Core Development Fund" in the 'Purpose' text field)

The next release of Rakudo (#104), is tentatively scheduled for 2016-10-15.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback -- get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, the most recent
incarnation of the “Using Perl 6” book, and other software that can
be used with the Rakudo compiler to enhance its utility.

