/*
  rakarrack - a guitar efects software

  global.h  -  Variable Definitions and functions
  Copyright (C) 2008 Daniel Vidal & Josep Andreu
  Author: Daniel Vidal & Josep Andreu

 This program is free software; you can redistribute it and/or modify
 it under the terms of version 2 of the GNU General Public License
 as published by the Free Software Foundation.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License (version 2) for more details.

 You should have received a copy of the GNU General Public License
 (version2)  along with this program; if not, write to the Free Software Foundation,
 Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/


#ifndef DXEMU_H
#define DXEMU_H

#include "config.h"
#include <pthread.h>
#include <signal.h>
#include <alsa/asoundlib.h>
#include <X11/xpm.h>
#include <jack/jack.h>
#include <Fl/Fl_Preferences.H>
#include "Reverb.h"
#include "Chorus.h"
#include "Echo.h"
#include "Phaser.h"
#include "Distorsion.h"
#include "EQ.h"
#include "Compressor.h"
#include "Alienwah.h"
#include "DynamicFilter.h"
#include "Pan.h"
#include "Harmonizer.h"
#include "MusicDelay.h"
#include "Gate.h"
#include "Tuner.h"
#include "MIDIConverter.h"
#include "RecognizeNote.h"
#include "RecChord.h"

#define D_PI 6.283185
#define PI 3.141598
#define LOG_10 2.302585093
#define AMPLITUDE_INTERPOLATION_THRESHOLD 0.0001
#define FF_MAX_VOWELS 6
#define FF_MAX_FORMANTS 12
#define FF_MAX_SEQUENCE 8
#define MAX_FILTER_STAGES 5
#define RND (rand()/(RAND_MAX+1.0))
#define REALTYPE float
#define F2I(f,i) (i)=((f>0) ? ( (int)(f) ) :( (int)(f-1.0) ));
#define dB2rap(dB) ((expf((dB)*LOG_10/20.0)))
#define rap2dB(rap) ((20*log(rap)/LOG_10))
#define CLAMP(x, low, high)  (((x) > (high)) ? (high) : (((x) < (low)) ? (low) : (x)))
#define INTERPOLATE_AMPLITUDE(a,b,x,size) ( (a) + ( (b) - (a) ) * (REALTYPE)(x) / (REALTYPE) (size) )
#define ABOVE_AMPLITUDE_THRESHOLD(a,b) ( ( 2.0*fabs( (b) - (a) ) / ( fabs( (b) + (a) + 0.0000000001) ) ) > AMPLITUDE_INTERPOLATION_THRESHOLD )
#define POLY 8

extern int Pexitprogram, preset;
extern int commandline, gui;
extern int exitwithhelp, nojack;
extern Pixmap p, mask;
extern XWMHints *hints;
extern int PERIOD;
extern unsigned int SAMPLE_RATE;
extern float val_sum;
extern int note_active[POLY];
extern int rnote[POLY];
extern int gate[POLY];
extern int reconota;
extern float r__ratio;
class RKR
{



public:

  RKR ();
  ~RKR ();

  void Alg (float *inl, float *inr, void *);
  void midievents (int i);
  void loadfile (char *filename);
  void savefile (char *filename);
  int loadbank (char *filename);
  int savebank (char *filename);
  void New ();
  void New_Bank ();
  void Bank_to_Preset (int Num);
  void Preset_to_Bank (int i);
  void Actualizar_Audio ();
  void init_rkr ();
  void Vol_Efx (int NumEffect, float volume);
  void Vol2_Efx ();
  void Vol3_Efx ();
  void cleanup_efx ();
  void Control_Gain ();
  void Control_Volume ();
  int Message (const char *labelwin, const char *message_text);
  char *PrefNom(const char *dato);

  int EQ1_setpreset (int func, int num, unsigned char npreset);
  int EQ2_setpreset (int func, int num, unsigned char npreset);
  int Cabinet_setpreset (unsigned char npreset);
  void miramidi ();
  void InitMIDI ();
  void ConnectMIDI ();
  void calculavol (int i);
  void Conecta ();
  void disconectaaconnect ();
  void conectaaconnect ();


  class Reverb *efx_Rev;
  class Chorus *efx_Chorus;
  class Chorus *efx_Flanger;
  class Phaser *efx_Phaser;
  class EQ *efx_EQ1;
  class EQ *efx_EQ2;
  class Echo *efx_Echo;
  class Distorsion *efx_Distorsion;
  class Distorsion *efx_Overdrive;
  class Compressor *efx_Compressor;
  class DynamicFilter *efx_WhaWha;
  class Alienwah *efx_Alienwah;
  class EQ *efx_Cabinet;
  class Pan *efx_Pan;
  class Harmonizer *efx_Har;
  class MusicDelay *efx_MusDelay;
  class Gate *efx_Gate;
  class Tuner *efx_Tuner;
  class MIDIConverter *efx_MIDIConverter;
  class Recognize *RecNote;
  class RecChord *RC;
  jack_client_t *jackclient;
  jack_options_t options;
  jack_status_t status;

  char jackcliname[64];

  int Bypass;
  int MIDIConverter_Bypass;
  int Tuner_Bypass;

  int Reverb_Bypass;
  int Chorus_Bypass;
  int Flanger_Bypass;
  int Phaser_Bypass;
  int Overdrive_Bypass;
  int Distorsion_Bypass;
  int Echo_Bypass;
  int EQ1_Bypass;
  int EQ2_Bypass;
  int Compressor_Bypass;
  int WhaWha_Bypass;
  int Alienwah_Bypass;
  int Cabinet_Bypass;
  int Pan_Bypass;
  int Harmonizer_Bypass;
  int MusDelay_Bypass;
  int Gate_Bypass;

  int Bypass_B;

  int Reverb_B;
  int Chorus_B;
  int Flanger_B;
  int Phaser_B;
  int Overdrive_B;
  int Distorsion_B;
  int Echo_B;
  int EQ1_B;
  int EQ2_B;
  int Compressor_B;
  int WhaWha_B;
  int Alienwah_B;
  int Cabinet_B;
  int Pan_B;
  int Harmonizer_B;
  int MusDelay_B;
  int Gate_B;

  int Cabinet_Preset;

  int lv[24][24];
  int saved_order[24];
  int efx_order[24];
  int new_order[24];
  int availables[14];
  int MidiCh;
  int HarCh;
  int midivol;
  int actuvol;
  int help_displayed;
  int modified;
  int aconnect_MI;
  int aconnect_JA;
  int cuan_jack;
  int IsCoIn;
  int Cyoin;
  int Pyoin;
  int Ccin;
  int Pcin;

  int estuvo;
  int Mcontrol[128];
  int Mvalue;
    

  float *efxoutl;
  float *efxoutr;
  float *smpl;
  float *smpr;
  float *denormal;

  float Master_Volume;
  float Input_Gain;


  float Log_I_Gain;
  float Log_M_Volume;

  float old_i_sum;
  float old_v_sum;
  float val_v_sum;
  float val_i_sum;
  int have_signal;

// Tunner

  int note_old;
  float nfreq_old;
  float afreq_old;
  int cents_old;

  char tmpprefname[128];

  char *Preset_Name;
  char *Data_Version;
  char *Author;
  char *Bank_Saved;
  char *UserRealName;

  char MID[128];
  char BankFilename[128];

  struct Effects_Names
  {
    char Nom[32];
  } efx_names[24];

  struct Preset_Bank_Struct
  {
    char Preset_Name[64];
    char Author[64];
    char Classe[36];
    char Type[4];
    char Reserva[64];
    char Reserva1[64];
    float Input_Gain;
    float Master_Volume;
    int Bypass;
    int lv[24][22];
  } Bank[82];


  // Alsa MIDI

  snd_seq_t *midi_in, *midi_out;

  //   Recognize

  int last;

  // Harmonizer
  int HarQual;

  struct JackPorts
  {
    char name[128];
  } jack_po[80];



};

#endif
