/* tuneit.c -- Detect fundamental frequency of a sound
* Copyright (C) 2004, 2005  Mario Lang <mlang@delysid.org>
*
* Modified for rakarrack by Daniel Vidal & Josep Andreu
* MIDIConverter.h  MIDIConverter definitions
*
* This is free software, placed under the terms of the
* GNU General Public License, as published by the Free Software Foundation.
* Please see the file COPYING for details.
*/


#ifndef MIDICONVERTER_H_
#define MIDICONVERTER_H_

#include <math.h>
#include <stdlib.h>
#include <alsa/asoundlib.h>

#define REALTYPE float

#define D_NOTE          1.059463094359
#define LOG_D_NOTE      0.057762265047
#define D_NOTE_SQRT     1.029302236643
#define LOG_2           0.693147180559
#define M_PI 3.14159265358979323846
#define MAX_PEAKS 8


class MIDIConverter
{
public:
  MIDIConverter (REALTYPE * efxoutl_, REALTYPE * efxoutr_);
  ~MIDIConverter ();


  REALTYPE *efxoutl;
  REALTYPE *efxoutr;
  signed short int *schmittBuffer;
  signed short int *schmittPointer;
  const char **notes;
  int note;
  float nfreq, afreq, freq;
  float TrigVal;
  int cents;
  void schmittFloat (int nframes, float *indatal, float *indatar);
  void setmidichannel (int channel);
  int getmidichannel (int channel);
  void panic ();
  void setTriggerAdjust (int val);
  float getTriggerAdjust (int val);
  void setVelAdjust (int val);
  float getVelAdjust (int val);

  float VelVal;
  int channel;
  snd_seq_t *port;
  int lanota;
  int nota_actual;
  int hay;
  int preparada;
  int ponla;
  int velocity;

private:


  float freqs[12];
  float lfreqs[12];
  int blockSize;
  void displayFrequency (float freq);
  void schmittInit (int size);
  void schmittS16LE (int nframes, signed short int *indata);
  void schmittFree ();
  void MIDI_Send_Note_On (int note);
  void MIDI_Send_Note_Off (int note);


};

#endif /*MIDICONVERTER_H_ */
