CREATE TABLE accounts (
  id int generated by default as identity (start with +10000),
  firm_id int default NULL,
  credit_limit int default NULL,
  PRIMARY KEY (id)
);

CREATE TABLE companies (
  id int generated by default as identity (start with +10000),
  type varchar(50) default NULL,
  ruby_type varchar(50) default NULL,
  firm_id int default NULL,
  name varchar(50) default NULL,
  client_of int default NULL,
  rating int default 1,
  PRIMARY KEY (id)
);

CREATE TABLE topics (
  id int generated by default as identity (start with +10000),
  title varchar(255) default NULL,
  author_name varchar(255) default NULL,
  author_email_address varchar(255) default NULL,
  written_on timestamp default NULL,
  bonus_time time default NULL,
  last_read date default NULL,
  content varchar(3000),
  approved smallint default 1,
  replies_count int default 0,
  parent_id int default NULL,
  type varchar(50) default NULL,
  PRIMARY KEY (id)
);

CREATE TABLE developers (
  id int generated by default as identity (start with +10000),
  name varchar(100) default NULL,
  salary int default 70000,
  created_at timestamp default NULL,
  updated_at timestamp default NULL,
  PRIMARY KEY (id)
);

CREATE TABLE projects (
  id int generated by default as identity (start with +10000),
  name varchar(100) default NULL,
  type varchar(255) default NULL,
  PRIMARY KEY (id)
);

CREATE TABLE developers_projects (
  developer_id int NOT NULL,
  project_id int NOT NULL,
  joined_on date default NULL
);

CREATE TABLE customers (
  id int generated by default as identity (start with +10000),
  name varchar(100) default NULL,
  balance int default 0,
  address_street varchar(100) default NULL,
  address_city varchar(100) default NULL,
  address_country varchar(100) default NULL,
  gps_location varchar(100) default NULL,
  PRIMARY KEY (id)
);

CREATE TABLE movies (
  movieid int generated by default as identity (start with +10000),
  name varchar(100) default NULL,
  PRIMARY KEY (movieid)
);

CREATE TABLE subscribers (
  nick varchar(100) NOT NULL,
  name varchar(100) default NULL,
  PRIMARY KEY (nick)
);

CREATE TABLE booleantests (
  id int generated by default as identity (start with +10000),
  value int default NULL,
  PRIMARY KEY (id)
);

CREATE TABLE auto_id_tests (
  auto_id int generated by default as identity (start with +10000),
  value int default NULL,
  PRIMARY KEY (auto_id)
);

CREATE TABLE entrants (
  id int NOT NULL PRIMARY KEY,
  name varchar(255) NOT NULL,
  course_id int NOT NULL
);

CREATE TABLE colnametests (
  id int generated by default as identity (start with +10000),
  references int NOT NULL,
  PRIMARY KEY (id)
);

CREATE TABLE mixins (
  id int generated by default as identity (start with +10000),
  parent_id int default NULL,
  pos int default NULL,
  created_at timestamp default NULL,
  updated_at timestamp default NULL,
  lft int default NULL,
  rgt int default NULL,
  root_id int default NULL,
  type varchar(40) default NULL,
  PRIMARY KEY (id)
);

CREATE TABLE people (
  id int generated by default as identity (start with +10000),
  first_name varchar(40) NOT NULL,
  lock_version int default 0,
  PRIMARY KEY  (id)
);

CREATE TABLE binaries (
  id int generated by default as identity (start with +10000),
  data blob(50000),
  PRIMARY KEY  (id)
);

CREATE TABLE computers (
  id int generated by default as identity (start with +10000),
  developer int NOT NULL,
  extendedWarranty int NOT NULL
);

CREATE TABLE posts (
  id int generated by default as identity (start with +10000),
  author_id int default NULL,
  title varchar(255) default NULL,
  type varchar(255) default NULL,
  body varchar(3000) default NULL
);

CREATE TABLE comments (
  id int generated by default as identity (start with +10000),
  post_id int default NULL,
  type varchar(255) default NULL,
  body varchar(3000) default NULL
);

CREATE TABLE authors (
  id int generated by default as identity (start with +10000),
  name varchar(255) default NULL
);

CREATE TABLE tasks (
  id int generated by default as identity (start with +10000),
  starting timestamp default NULL,
  ending timestamp default NULL
);

CREATE TABLE categories (
  id int generated by default as identity (start with +10000),
  name varchar(255) NOT NULL,
  type varchar(40) default NULL
);

CREATE TABLE categories_posts (
  category_id int NOT NULL,
  post_id int NOT NULL
);

CREATE TABLE fk_test_has_pk (
  id INTEGER NOT NULL PRIMARY KEY
);

CREATE TABLE fk_test_has_fk (
  id    INTEGER NOT NULL PRIMARY KEY,
  fk_id INTEGER NOT NULL,

  FOREIGN KEY (fk_id) REFERENCES fk_test_has_pk(id)
);
