#include "allegro.h"
#include "rfield.h"
#include "rmenu.h"
#include "rfont.h"
#include "defs.h"
#include <string.h>

RField::RField( bool selectable, bool perm, int return_val, RMenu * who, int number, SAMPLE * play_me ):
select( selectable ),
ret( return_val ),
next( NULL ),
prev( NULL ),
menu_next( who ),
num( number ),
smp( play_me ),
title( perm ) {
}


void RField::Add( RField * rf ) {
	next = rf;
	if ( rf != NULL )
		rf->prev = this;
}


void RField::setMenu( RMenu * nx ) {
	menu_next = nx;
}


bool RField::Ok() {
	return select;
}


bool RField::Title() {
	return title;
}


void RField::Selected() {

	if ( smp != NULL )
		//play_sample( smp, 255, 128, 1000, false );
		play_sound( smp, 255 );

}


int RField::Size() {
	return 0;
}


void RField::Draw( BITMAP * work, int x, int y, int col ) {
}


bool RField::equiv( void * obj ) {
	return false;
}


int RField::Val() {
	return ret;
}


RField * RField::Next() {
	return next;
}


RField * RField::Prev() {
	return prev;
}


int RField::Place() {
	return num;
}


RMenu * RField::NextMenu() {
	return menu_next;
}


RField::~RField() {
}


//**//
RField_Name::RField_Name( RFont * f_font, char * name, bool selectable, bool perm, int return_val, RMenu * who, int number, SAMPLE * pl ):
RField( selectable, perm, return_val, who, number, pl ) {
	handle = name;
	field_font = f_font;
}


bool RField_Name::equiv( void * obj ) {
	return ( strcasecmp( handle, (char *)obj ) == 0 );
}


int RField_Name::Size() {
	return field_font->height();
}


void RField_Name::Draw( BITMAP * work, int x, int y, int col ) {
	field_font->rtext( work, x, y, col, handle );
}


RField_Name::~RField_Name() {
	delete[] handle;
}


RField_Bitmap::RField_Bitmap( BITMAP * look, bool selectable, bool perm, int return_val, RMenu * who, int number, SAMPLE * pl ):
RField( selectable, perm, return_val, who, number, pl ) {
	scene =  look;
}


bool RField_Bitmap::equiv( void * obj ) {
	return false;
}


int RField_Bitmap::Size() {
	return scene->h;
}


void RField_Bitmap::Draw( BITMAP * work, int x, int y, int col ) {
	draw_sprite( work, scene, x, y );
}


RField_Bitmap::~RField_Bitmap() {
}
