#include "allegro.h"
#include <stdio.h>
#include "defs.h"
#include "menu.h"
#include "trigtable.h"
#include "strings.h"
#include <string.h>
#include "animation.h"
#include "spaceobj.h"
#include "shipobj.h"
#include "rfont.h"
#include "rmenu.h"
#include "rmenu_animation.h"
#include "rafkill.h"
#include "hull.h"
#include "hull_player.h"
#include "ebox.h"
#include <aldumb.h>

#include <vector>

using namespace std;

#include "gun_arc.h"
#include "gun_angle.h"
#include "gun_beam.h"
#include "gun_chain.h"
#include "gun_destruct.h"
#include "gun_edfstraight.h"
#include "gun_ednstraight.h"
#include "gun_eflarge.h"
#include "gun_efmsingle.h"
#include "gun_efsingle.h"
#include "gun_elarge.h"
#include "gun_emissle.h"
#include "gun_emlight.h"
#include "gun_eside.h"
#include "gun_estraight.h"
#include "gun_findgun.h"
#include "gun_fire.h"
#include "gun_follow.h"
#include "gun_laser.h"
#include "gun_machine.h"
#include "gun_machine_circle.h"
#include "gun_minimissle.h"
#include "gun_missle.h"
#include "gun_pulse.h"
#include "gun_shatter.h"
#include "gun_spread.h"
#include "gun_stick.h"
#include "gun_yehat.h"
#include "gun_swirl.h"
#include "gun_massive.h"
#include "gun_saber.h"
#include "gun_tractor_beam.h"
#include "gun_rotate.h"

#define MENU_BUY 7
#define MENU_QUIT 843
#define MENU_NEXT 844
#define MENU_CONTINUE 4321
#define MENU_WEAPON 9002
#define MENU_HULL 9003

#define MENU_SELL_WEAPON 30
#define MENU_UPGRADE 321
#define MENU_BUY_WEAPON 56
#define MENU_BUY_ACCESSORY 600

#define MENU_HULL_LIFE 12000
#define MENU_HULL_SHIELD 12001
#define MENU_BUY_HULL 12005
#define MENU_HULL_MAX 12006
#define MENU_SHIELD_MAX 12007

#define HULL_LIFE_WORTH 1000
#define HULL_SHIELD_WORTH 3000

#define ANIMATION_X 180

#define MENU_TITLE_COLOR (makecol(240,205,7))

menuClass::menuClass() {

	pgun[0].mgun = 4;
	pgun[0].gunz = new int[ pgun[0].mgun ];
	pgun[0].gunz[0] = GUN_MACHINE;
	pgun[0].gunz[1] = GUN_MACHINE_CIRCLE;
	pgun[0].gunz[2] = GUN_SPREAD;
	pgun[0].gunz[3] = GUN_ANGLE;

	pgun[1].mgun = 4;
	pgun[1].gunz = new int[ pgun[1].mgun ];
	pgun[1].gunz[0] = GUN_BEAM;
	pgun[1].gunz[1] = GUN_MINIMISSLE;
	pgun[1].gunz[2] = GUN_SHATTER;
	pgun[1].gunz[3] = GUN_YEHAT;

	pgun[2].mgun = 3;
	pgun[2].gunz = new int[ pgun[2].mgun ];
	pgun[2].gunz[0] = GUN_ARC;
	pgun[2].gunz[1] = GUN_LASER;
	pgun[2].gunz[2] = GUN_STICKY;

	pgun[3].mgun = 2;
	pgun[3].gunz = new int[ pgun[3].mgun ];
	pgun[3].gunz[0] = GUN_MISSLE;
	pgun[3].gunz[1] = GUN_PULSE;

	pgun[4].mgun = 3;
	pgun[4].gunz = new int[ pgun[4].mgun ];
	pgun[4].gunz[0] = GUN_FINDGUN;
	pgun[4].gunz[1] = GUN_FOLLOW;
	pgun[4].gunz[2] = GUN_TRACTOR;

	agun.mgun = 4;
	agun.gunz = new int[ agun.mgun ];
	agun.gunz[0] = GUN_SABER;
	agun.gunz[1] = GUN_SWIRL;
	agun.gunz[2] = GUN_CHAIN;
	agun.gunz[3] = GUN_MASSIVE;

	char * font_name = data_file( "vulture.fnt" );
	menu_font = new RFont( font_name );
	free( font_name );

	gun_sticky_max_collide = 40;
	gun_sticky_collide_list = new ECollide*[ gun_sticky_max_collide ];
	for ( int q = 0; q < gun_sticky_max_collide; q++ ) {
		BITMAP * temp = create_bitmap( (3 + q * 3)*2, (3 + q * 3)*2 );
		int mask = makecol( 255, 0, 255 );
		clear_to_color( temp, mask );
		circlefill( temp, 3 + q * 3, 3 + q * 3, 3 + q * 3, makecol(255,0,0) );
		gun_sticky_collide_list[q] = new ECollide( temp, 3, mask, 35.0 );
		destroy_bitmap( temp );
	}

}


menuClass::~menuClass() {
	for ( int q = 0; q < 5; q++ )
		delete[] pgun[q].gunz;
	delete[] agun.gunz;
	delete menu_font;

	for ( int q = 0; q < gun_sticky_max_collide; q++ )
		delete gun_sticky_collide_list[q];
	delete[] gun_sticky_collide_list;
}


void menuClass::vectorAdd( vector< SpaceObject * > * stable, vector< SpaceObject * > * state ) {

	for ( vector< SpaceObject * >::iterator it = state->begin();
		it != state->end(); it++ )
	stable->push_back( *it );

}


void menuClass::getAnimation( Animation * hold, SpaceObject * player, vector< SpaceObject * > * ammo, vector< SpaceObject * > * enemy ) {

	player->SetCoordXY( ANIMATION_X/2, 350 );
	player->dx = 0;
	player->dy = 0;
	//hold->clear();

	for ( int z = 0; z < USE_AMMO; z++ ) {
		for ( vector< SpaceObject * >::iterator it = ammo->begin();
		it != ammo->end(); ) {
			if ( (*it)->MoveMe( ammo, enemy, NULL, NULL ) ) {
				SpaceObject * del = *it;
				it = ammo->erase( it );
				delete del;
			} else it++;
		}

		for ( vector< SpaceObject * >::iterator it = ammo->begin();
		it != ammo->end(); ) {
			if ( (*it)->getLife() <= 0 ) {
				SpaceObject * del = *it;
				it = ammo->erase( it );
				delete del;
			} else ++it;
		}
	}

	WeaponObject ** myGun = player->hull->Guns();
	for ( int q = 0; q < player->hull->maxGuns(); q++ )
	if ( myGun[q] != NULL ) {
		if ( myGun[q]->shot_counter > 0 )
			myGun[q]->shot_counter--;
		else {
			myGun[q]->MakeShot(player->actualx,player->actualy-10,ammo,enemy);
		}
	}

	vector< SpaceObject * > * draw = new vector< SpaceObject * >();
	vectorAdd( draw, ammo );
	draw->push_back( player );
	//BITMAP * add_b = create_bitmap( ANIMATION_X, 480 );
	BITMAP * add_b = player_animate->show();
	clear( add_b );

	int total = 0;
	for ( vector< SpaceObject * >::iterator it = draw->begin();
		it != draw->end(); it++, total++ )
	(*it)->Draw( add_b, NULL, 0, (*it)->lookPlane(), 0 );

	for ( int z = 0; z < 7; z++ ) {

		int d = 11;
		int col = makecol(255-z*d,255-z*d,255-z*d);
		rect( add_b, z, z, ANIMATION_X-z-1, 480-z-1, col );

	}

	delete draw;

}


BITMAP * menuClass::menuScreen() {

	int * shade = new int[ 100 ];

	blend_palette( shade, 100, makecol( rnd(50)+20, rnd(40)+50, rnd(50)+170 ), makecol( rnd(40)+190, rnd(128)+128, rnd(30)+10 ) );
	BITMAP * rec = create_bitmap( GRAPHICS_X, GRAPHICS_Y );
	clear( rec );

	int divx = 3;
	double mmx = tsqrt( tsqr(GRAPHICS_X) + tsqr(GRAPHICS_Y) );
	for ( int x = 0; x < GRAPHICS_X/divx; x++ )
	for ( int y = 0; y < GRAPHICS_Y/divx; y++ ) {
		double ma = (double)tsqrt( tsqr(x*divx) + tsqr(y*divx) ) / mmx * 99.0;
		rectfill( rec, x*divx, y*divx, x*divx+divx-1, y*divx+divx-1, shade[(int)ma] );
	}

	delete[] shade;

	return rec;

}


int menuClass::upgradeHelper( int worth, int lev ) {

	return worth * (lev+1);

	//if ( lev == 0 ) return worth*3/2;
	//return (int)( (double)upgradeHelper( worth, lev-1 ) * 7.0/4.0 );

}


int menuClass::upgradeCost( WeaponObject * gun ) {
	//int g = (int)((double)gun->Worth() * (double)tcube(gun->strength+3)*30.0/650.0);
	return upgradeHelper( gun->Worth(), gun->strength );
}


int menuClass::sellGun( WeaponObject * gun ) {

	//int resell = ( tcube( (gun->strength+1)*6 ) + gun->Worth() ) * 4 / 12;
	int resell = upgradeCost( gun ) / 2;
	return resell;

}


int menuClass::hull_price( int z ) {
	switch( z ) {
		case 1  :       return 160000;
		case 2  :       return 485000;
		case 3  :       return 700000;
		case 4  :       return 1000000;
	}
	return 0;
}


void menuClass::GunMenu( RMenu * weap, int q, WeaponObject * current, BITMAP * intr, int score ) {
	WeaponObject ** legal = new WeaponObject*[pgun[q].mgun];
	for ( int z = 0; z < pgun[q].mgun; z++ )
		legal[z] = GetWeapon( pgun[q].gunz[z] );

	char * numnum;

	if ( current != NULL ) {
		/*
		char * numnum = int2str(current->strength+1);
		char * sub = append( current->GetName()," at strength ");
		weap->addTitle( append(sub,numnum), menu_font );
		free( numnum );
		free( sub );
		*/
		weap->addTitle( strdup( current->GetName() ), menu_font );
		char * numnum = int2str( current->strength + 1 );
		int max = current->maxPower();
		char * maxnum;
		if ( max != -1 ) maxnum = int2str( max+1 );
		else maxnum = strdup("Infinite");

		char * sub = append( "Strength ", numnum );
		char * sub2 = append( " out of ", maxnum );
		weap->addTitle( append(sub,sub2), menu_font );
		free( numnum);
		free( maxnum );
		free( sub );
		free( sub2 );

	} else  weap->addTitle( strdup("No Weapon"), menu_font );
	numnum = int2normal( score );
	weap->addTitle( append("Score ",numnum), menu_font );
	free( numnum );
	weap->addMenu( strdup("Return"), menu_font, true, 0, NULL, NULL );
	if ( current != NULL ) {

		if ( current->strength < current->maxPower() || current->maxPower() == -1 ) {
			numnum = int2normal( upgradeCost(current) );
			weap->addMenu( append("Upgrade ",numnum), menu_font, score>=upgradeCost(current), MENU_UPGRADE, weap, NULL );
			free(numnum);
		}

		numnum = int2normal( sellGun( current ) );
		weap->addMenu( append("Sell for ",numnum), menu_font, true, MENU_SELL_WEAPON, weap, NULL );
		free( numnum );
	}
	weap->addTitle( strdup("Purchase"), menu_font );
	for ( int z = 0; z < pgun[q].mgun; z++ )
	if ( !(current != NULL && strcasecmp(legal[z]->GetName(),current->GetName())==0) ) {
		numnum = int2normal( legal[z]->Worth() );
		char * sub = append(legal[z]->GetName(),":");
		char * sub2 = append(sub,numnum);
		//weap->addMenu(strdup(sub2),menu_font,score>=legal[z]->Worth(),MENU_BUY_WEAPON+z, weap, NULL );
		weap->addMenu(strdup(sub2),menu_font,true,MENU_BUY_WEAPON+z, weap, NULL );
		free( numnum );
		free( sub2 );
		free( sub );
	}

	for ( int z = 0; z < pgun[q].mgun; z++ )
		delete legal[z];
	delete[] legal;

}


void menuClass::GetAccessoryMenu( RMenu * weap, WeaponObject ** a_list, BITMAP * intr, int score ) {
	WeaponObject ** legal = new WeaponObject*[agun.mgun];
	for ( int z = 0; z < agun.mgun; z++ )
		legal[z] = GetWeapon( agun.gunz[z] );

	weap->addTitle( strdup("Accessory Bays"), menu_font );
	char * numnum;
	numnum = int2normal( score );
	weap->addTitle( append("Score ",numnum), menu_font );
	free( numnum );
	weap->addTitle( strdup("Currently have"), menu_font );
	for ( int q = 0; q < MAX_ACCESSORY; q++ )
		if ( a_list[q] != NULL )
			weap->addTitle( strdup( a_list[q]->GetName() ), menu_font );

	weap->addTitle( strdup("Purchase"), menu_font );
	for ( int q = 0; q < agun.mgun; q++ ) {
		bool cy = true;
		int total = 0;
		for ( int z = 0; z < MAX_ACCESSORY; z++ )
		if ( a_list[z] != NULL ) {
			if ( strcasecmp(a_list[z]->GetName(),legal[q]->GetName()) == 0 ) cy = false;
			total++;
		}

		if ( cy ) {
			numnum = int2normal( legal[q]->Worth() );
			char * sub = append(legal[q]->GetName(),":");
			char * sub2 = append(sub,numnum);
			weap->addMenu( strdup(sub2), menu_font, score>=legal[q]->Worth() && total < MAX_ACCESSORY, MENU_BUY_ACCESSORY+q, weap, NULL );
			free( numnum );
			free( sub2 );
			free( sub );
		}

	}

	weap->addMenu( strdup("Return"), menu_font, true, 0, NULL, NULL );

	for ( int z = 0; z < agun.mgun; z++ )
		delete legal[z];
	delete[] legal;

}


void menuClass::weaponMenu( RMenu * gun_menu, SpaceObject * player ) {
	//RMenu * gun_menu = new RMenu( intr, 1, 40, makecol(80,0,0),makecol(255,136,0), MENU_TITLE_COLOR );
	gun_menu->addTitle( strdup("Buy Weapons"), menu_font );
	char * numnum = int2normal( player->score );
	gun_menu->addTitle( append("Score ",numnum), menu_font );
	free( numnum );
	for ( int q = 0; q < player->hull->maxGuns()-1; q++ ) {
		numnum = int2str(q+1);
		gun_menu->addMenu( append("Weapon Bay ",numnum),menu_font,true,MENU_BUY+q,gun_menu,NULL );
		free( numnum );
	}
	gun_menu->addMenu( strdup("Accessories"), menu_font, true, 1, gun_menu, NULL );
	gun_menu->addMenu( strdup("Return"), menu_font, true, 0, NULL, NULL );
}


HullObject * menuClass::playerHull( int q ) {

	BITMAP ** pics = new BITMAP*[ 9 ];
	int life = 0;
	int shield = 0;
	int guns = 0;
	int hn = 0;
	switch( q ) {
		case 1  : {
			for ( int q = 0; q < 9; q++ )
				pics[q] = (BITMAP *)global_data[HULL_1_1+q].dat;
			life = 100;
			shield = 100;
			guns = 3;
			hn = 1;
			break;
		}
		case 2  : {
			for ( int q = 0; q < 9; q++ )
				pics[q] = (BITMAP *)global_data[HULL_2_1+q].dat;
			life = 150;
			shield = 150;
			guns = 4;
			hn = 2;
			break;
		}
		case 3  : {
			for ( int q = 0; q < 9; q++ )
				pics[q] = (BITMAP *)global_data[HULL_3_1+q].dat;
			life = 200;
			shield = 250;
			guns = 5;
			hn = 3;
			break;
		}
	}
	return new PlayerHull( pics, 9, life, shield, guns, hn, new ECollide( pics[4], 6, makecol(255,0,255), 52 ) );

}


void menuClass::GetHullMenu( RMenu * hull_menu, SpaceObject * human, BITMAP * intr ) {

	char * numnum;
	numnum = int2normal( human->score );
	hull_menu->addTitle(append("Score ",numnum), raptor_font );
	free( numnum );

	char * maxnum = int2str( ((PlayerHull *)human->hull)->max( 0 ) );
	numnum = int2str( (int)human->hull->life );
	char * total = append("Hull life ",numnum);
	char * sub = append( " out of ",maxnum );
	hull_menu->addTitle( append(total, sub), raptor_font );
	free( numnum );
	free( total );
	free( sub );
	free( maxnum );

	numnum = int2str( (int)((PlayerHull *)human->hull)->shield );
	maxnum = int2str( ((PlayerHull *)human->hull)->max( 1 ) );
	total = append("Hull Shield ",numnum);
	sub = append(" out of ",maxnum );
	hull_menu->addTitle( append(total,sub), raptor_font );
	free(numnum);
	free( maxnum );
	free( total );
	free( sub );
	numnum = int2normal( hull_price( ((PlayerHull *)human->hull)->rank() ) );
	hull_menu->addMenu( strdup("Buy Life 1000"), raptor_font, human->score>=HULL_LIFE_WORTH && human->hull->life<((PlayerHull *)human->hull)->max(0), MENU_HULL_LIFE, hull_menu, NULL );
	hull_menu->addMenu( strdup("Buy Shield 3000"), raptor_font, human->score>=HULL_SHIELD_WORTH && ((PlayerHull *)human->hull)->shield<((PlayerHull *)human->hull)->max(1), MENU_HULL_SHIELD, hull_menu, NULL );
	hull_menu->addMenu( strdup("Maxout life"), raptor_font, true, MENU_HULL_MAX, hull_menu, NULL );
	hull_menu->addMenu( strdup("Maxout shield"), raptor_font, true, MENU_SHIELD_MAX, hull_menu, NULL );
	if ( ((PlayerHull *)human->hull)->rank() < 3 )
		hull_menu->addMenu( append("Buy Next Hull for ", numnum), raptor_font, human->score>=hull_price( ((PlayerHull *)human->hull)->rank() ) && ((PlayerHull *)human->hull)->rank() < 3, MENU_BUY_HULL, hull_menu, NULL );
	hull_menu->addMenu( strdup("Return"), raptor_font, true, 0, NULL, NULL );

	free( numnum );

}


SpaceObject * menuClass::copySpace( SpaceObject * player ) {

	SpaceObject * who = new SpaceObject( 0, 0, 0, 0, new HullObject( player->hull->Bitmap, 1, 1, player->hull->maxGuns(), 1, 10, false, NULL ), NULL, 10, 1 );
	for ( int q = 0; q < player->hull->maxGuns(); q++ )
		who->giveWeapon( player->hull->Guns()[q], q );
	return who;

}


bool menuClass::accept_sell() {

	BITMAP * sell_screen = create_bitmap( GRAPHICS_X, GRAPHICS_Y );
	blit( screen, sell_screen, 0, 0, 0, 0, GRAPHICS_X, GRAPHICS_Y );
	set_trans_blender( 0, 0, 0, 120 );
	drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0 );
	rectfill( sell_screen, 120, 80, 450, 235, makecol(0,0,0) );
	rect( sell_screen, 120, 80, 450, 235, makecol(255,255,255) );
	drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0 );
	RMenu * sell = new RMenu( sell_screen, 130, 100, makecol(80,0,0),makecol(255,136,0), MENU_TITLE_COLOR );
	sell->addTitle( "Sell weapon", raptor_font );
	sell->addMenu( strdup("Yes"), raptor_font, true, 1, sell, NULL );
	sell->addMenu( strdup("No"), raptor_font, true, 0, sell, NULL );
	sell->init();

	int call = -1;
	while( call == -1 ) {
		call = sell->procMenu( &sell );
		if ( !sell->Selected() ) call = -1;
	}

	delete sell;
	destroy_bitmap( sell_screen );
	return call;

}


bool menuClass::activate( SpaceObject * player, AL_DUH_PLAYER * dumb_player ) {

	if ( player->getLife() <= 0 )
		player->hull->life = ((PlayerHull *)player->hull)->max( 0 )/2;

	//cheat line
	//player->score += 3500000;

	//BITMAP * intr = menuScreen();
	BITMAP * intr;
	char * buy_menu_file = data_file( "buy-scene.pcx" );
	intr = load_bitmap( buy_menu_file, NULL );
	free( buy_menu_file );
	if ( !intr ) {
		printf("Supreme error with menu screen\n");
		return true;
	}

	SpaceObject * human = player;

	SpaceObject * alias;			  //used for animation in menu
	alias = player->copy();

	vector< SpaceObject * > * ammo = new vector< SpaceObject * >;
	vector< SpaceObject * > * enemy = new vector< SpaceObject * >;
	SpaceObject * enemy_guy = new SpaceObject( 320, -800, 0, 0, new HullObject(NULL,0,0,0,0,0,false,NULL), NULL, 0, 0 );
	enemy->push_back( enemy_guy );

	int num_guns = human->hull->maxGuns()-1;

	player_animate = new Animation( 640-ANIMATION_X, 0 );
	BITMAP * pa = create_bitmap( ANIMATION_X, 480 );
	player_animate->add( pa );

	RMenu * intro_menu = new RMenu( intr, 1, 40, makecol(90,0,0),makecol(255,136,0), MENU_TITLE_COLOR );
	RMenu * gun_menu = new RMenu( intr, 1, 40, makecol(90,0,0), makecol(255,136,0), MENU_TITLE_COLOR );
	RMenu * hull_menu = new RMenu( intr, 1, 40, makecol(90,0,0), makecol(255,136,0), MENU_TITLE_COLOR );
	RMenu * accessory_menu = new RMenuAnimation( intr, 1, 40, makecol(90,0,0),makecol(255,136,0), MENU_TITLE_COLOR, player_animate );
	weaponMenu( gun_menu, human );
	gun_menu->nextMenu( gun_menu->askPos( "Accessories" ), accessory_menu );
	GetHullMenu( hull_menu, human, intr );
	GetAccessoryMenu( accessory_menu, ((PlayerHull *)human->hull)->Accessories(), intr, human->score );

	RMenu ** weapon_menu = new RMenu*[ num_guns ];
	for ( int q = 0; q < num_guns; q++ ) {
		weapon_menu[q]=new RMenuAnimation(intr,1,40,makecol(120,0,0),makecol(255,0,0),MENU_TITLE_COLOR,player_animate);
		GunMenu(weapon_menu[q], q, human->hull->Guns()[q], intr, human->score );
		gun_menu->nextMenu( q+3, weapon_menu[q] );
	}

	intro_menu->addTitle( strdup("Buy Menu"), raptor_font );
	char * numnum = int2normal( human->score );
	intro_menu->addTitle( append("Score ",numnum), raptor_font );
	intro_menu->addMenu( strdup("Weapon Menu"), raptor_font, true, MENU_WEAPON, gun_menu, NULL );
	intro_menu->addMenu( strdup("Hull Menu"), raptor_font, true, MENU_HULL, hull_menu, NULL );
	intro_menu->addMenu( strdup("Next Level"),raptor_font, true, MENU_NEXT, NULL, NULL );
	intro_menu->addMenu( strdup("Main Menu"), raptor_font, true, MENU_QUIT, NULL, NULL );
	free( numnum );

	/** END INIT **/

	RMenu * current = intro_menu;
	current->init();
	int call = -1;
	int cur_weapon = 0;
	speed_counter = 0;
	while ( call != MENU_QUIT && call != MENU_NEXT ) {

		YIELD();
		al_poll_duh( dumb_player );

		bool score_change = false;
		if ( speed_counter )
			getAnimation( player_animate, alias, ammo, enemy );
		RMenu * temp = current;
		call = current->procMenu( &current );
		if ( !temp->Selected() ) {

			if ( temp->changed() ) {

				//delete alias;
				//alias = player->copy();

				if ( call == 0 ) {
					delete alias;
					alias = player->copy();
				}

				if ( call-MENU_BUY >= 0 && call-MENU_BUY < num_guns )
					cur_weapon = call-MENU_BUY;

				if ( call == MENU_SELL_WEAPON ) {

					delete alias;
					alias = player->copy();
					alias->eraseWeapon( cur_weapon );
				}

				if ( call == MENU_UPGRADE ) {
					delete alias;
					alias = player->copy();
					WeaponObject * up = alias->hull->Guns()[cur_weapon];
					if ( up )
						up->IncreasePower( 1 );
				}

				if ( call-MENU_BUY_WEAPON >= 0 && call-MENU_BUY_WEAPON < pgun[cur_weapon].mgun ) {
					delete alias;
					alias = player->copy();
					int w_buy = call-MENU_BUY_WEAPON;

					WeaponObject * legal = GetWeapon( pgun[cur_weapon].gunz[w_buy] );
					alias->eraseWeapon( cur_weapon );
					alias->giveWeapon( GetWeapon( pgun[cur_weapon].gunz[w_buy] ), cur_weapon );

					delete legal;
				}

				if ( call-MENU_BUY_ACCESSORY >= 0 && call-MENU_BUY_ACCESSORY < agun.mgun ) {
					delete alias;
					alias = player->copy();
					int w_buy = call - MENU_BUY_ACCESSORY;
					alias->eraseWeapon( alias->hull->maxGuns()-1 );
					alias->giveWeapon( GetWeapon( agun.gunz[w_buy] ), alias->hull->maxGuns()-1 );
				}

			}

			call = -1;

		}

		if ( call-MENU_BUY >= 0 && call-MENU_BUY < num_guns )
			cur_weapon = call-MENU_BUY;

		if ( call == MENU_SELL_WEAPON ) {
			WeaponObject * sl = human->hull->Guns()[ cur_weapon ];
			if ( sl ) {

				if ( accept_sell() ) {
					human->score += sellGun( sl );
					human->eraseWeapon( cur_weapon );
					human->giveWeapon( NULL, cur_weapon );
					score_change = true;
				}
			}

			delete alias;
			alias = player->copy();
		}

		if ( call-MENU_BUY_WEAPON >= 0 && call-MENU_BUY_WEAPON < pgun[cur_weapon].mgun ) {
			int w_buy = call-MENU_BUY_WEAPON;

			WeaponObject * legal = GetWeapon( pgun[cur_weapon].gunz[w_buy] );
			WeaponObject ** guns = human->hull->Guns();
			if ( human->score >= legal->Worth() ) {
				human->score -= legal->Worth();
				if ( guns[cur_weapon] != NULL ) {
					human->score += sellGun( guns[cur_weapon] );
					human->eraseWeapon( cur_weapon );
					human->giveWeapon( NULL, cur_weapon );
				}
				WeaponObject * nw = GetWeapon( pgun[ cur_weapon].gunz[w_buy] );
				human->giveWeapon( nw, cur_weapon );
				score_change = true;
			}

			delete legal;

			delete alias;
			alias = player->copy();

		}

		if ( call-MENU_BUY_ACCESSORY >= 0 && call-MENU_BUY_ACCESSORY < agun.mgun ) {
			int w_buy = call - MENU_BUY_ACCESSORY;
			WeaponObject * a_give = GetWeapon( agun.gunz[w_buy] );
			if ( human->score >= a_give->Worth() ) {
				human->score -= a_give->Worth();
				human->giveWeapon( GetWeapon(agun.gunz[w_buy]), human->hull->maxGuns()-1 );
				score_change = true;
			}
			delete a_give;

			delete alias;
			alias = player->copy();
		}

		if ( call == MENU_HULL_LIFE ) {
			human->score -= HULL_LIFE_WORTH;
			human->hull->life += 3;
			if ( human->hull->life > ((PlayerHull *)human->hull)->max(0) )
				human->hull->life = ((PlayerHull *)human->hull)->max(0);
			score_change = true;
		}

		if ( call == MENU_HULL_SHIELD ) {
			human->score -= HULL_SHIELD_WORTH;
			((PlayerHull *)human->hull)->shield += 3;
			if ( ((PlayerHull *)human->hull)->shield > ((PlayerHull *)human->hull)->max(1) )
				((PlayerHull *)human->hull)->shield = ((PlayerHull *)human->hull)->max(1);
			score_change = true;
		}

		if ( call == MENU_BUY_HULL && ((PlayerHull *)human->hull)->rank() < 3 ) {
			if ( human->score >= hull_price( ((PlayerHull *)human->hull)->rank() ) ) {
				human->score -= hull_price( ((PlayerHull *)human->hull)->rank() );
				HullObject * bh = playerHull( ((PlayerHull *)human->hull)->rank()+1 );

				WeaponObject ** save_weapons = new WeaponObject*[ human->hull->maxGuns()-1 ];
				for ( int q = 0; q < human->hull->maxGuns()-1; q++ ) {
					save_weapons[q] = human->hull->Guns()[q];
					human->giveWeapon( NULL, q );
				}
				int old_guns = human->hull->maxGuns()-1;

				human->giveHull( bh );
				for ( int q = 0; q < old_guns; q++ )
					human->giveWeapon( save_weapons[q], q );

				score_change = true;

				delete[] save_weapons;
				for ( int q = 0; q < num_guns; q++ )
					delete weapon_menu[q];
				delete[] weapon_menu;

				num_guns = human->hull->maxGuns()-1;
				gun_menu->clear();
				weaponMenu( gun_menu, human );
				weapon_menu = new RMenu*[ num_guns ];
				for ( int q = 0; q < num_guns; q++ ) {

					weapon_menu[q]=new RMenuAnimation(intr,1,40,makecol(120,0,0),makecol(255,0,0),MENU_TITLE_COLOR,player_animate);
					GunMenu(weapon_menu[q],q,human->hull->Guns()[q], intr, human->score );
					gun_menu->nextMenu( q+3, weapon_menu[q] );
				}
				gun_menu->nextMenu( gun_menu->askPos( "Accessories" ), accessory_menu );

				delete alias;
				alias = player->copy();
			}
		}

		if ( call == MENU_HULL_MAX ) {

			PlayerHull * ph = (PlayerHull *)human->hull;
			while ( human->score > HULL_LIFE_WORTH && ph->life < ph->max(0) ) {
				if ( ph->max(0)-ph->life < 3 )
					ph->life += ph->max(0)-ph->life;
				else    ph->life+=3;
				human->score -= HULL_LIFE_WORTH;
				score_change = true;
			}

		}

		if ( call == MENU_SHIELD_MAX ) {

			PlayerHull * ph = (PlayerHull *)human->hull;

			while ( human->score > HULL_SHIELD_WORTH && ph->shield < ph->max(1) ) {
				if ( ph->max(1) - ph->shield < 3 )
					ph->shield += ph->max(1) - ph->shield;
				else    ph->shield += 3;
				human->score -= HULL_SHIELD_WORTH;
				score_change = true;
			}

		}

		if ( call == MENU_UPGRADE ) {
			WeaponObject * up = human->hull->Guns()[cur_weapon];
			if ( up ) {
				if ( human->score >= upgradeCost( up ) && (up->strength < human->hull->Guns()[cur_weapon]->maxPower() || human->hull->Guns()[cur_weapon]->maxPower() == -1) ) {
					human->score -= upgradeCost( up );
					up->IncreasePower( 1 );
					score_change = true;
				}
			}
		}

		if ( score_change ) {

			numnum = int2normal( human->score );
			intro_menu->replaceTitle( 2, append("Score ",numnum ), raptor_font );
			gun_menu->clear();
			weaponMenu( gun_menu, human );
			free( numnum );

			for ( int q = 0; q < num_guns; q++ ) {
				weapon_menu[q]->clear();
				GunMenu(weapon_menu[q],q, human->hull->Guns()[q],intr,human->score );
				gun_menu->nextMenu( q+3, weapon_menu[q] );
			}
			hull_menu->clear();
			GetHullMenu( hull_menu, human, intr );
			accessory_menu->clear();
			GetAccessoryMenu( accessory_menu, ((PlayerHull *)human->hull)->Accessories(), intr, human->score );
			gun_menu->nextMenu( gun_menu->askPos( "Accessories" ), accessory_menu );

		}

	}

	/** END  **/

	destroy_bitmap( intr );
	delete intro_menu;
	delete gun_menu;
	delete hull_menu;
	delete accessory_menu;
	for ( int q = 0; q < num_guns; q++ )
		delete weapon_menu[q];
	delete[] weapon_menu;
	delete player_animate;
	delete ammo;
	delete enemy;
	delete enemy_guy;
	delete alias;

	if ( call == MENU_QUIT ) return true;
	return false;

}


WeaponObject * menuClass::GetWeapon( int q ) {

	switch( q ) {
		case GUN_MACHINE        :       return new WeaponMachineGun( 0, -1, NULL, TEAM_PLAYER );
		case GUN_MACHINE_CIRCLE :       return new WeaponMachineCircleGun( 0, -1, NULL, TEAM_PLAYER  );
		case GUN_BEAM           :       return new WeaponBeam( 0, -1, TEAM_PLAYER  );
		case GUN_MINIMISSLE     :       return new WeaponMiniMissle( 0, -1, TEAM_PLAYER  );
		case GUN_FINDGUN        :       return new WeaponFindGun( 0, -1, TEAM_PLAYER  );
		case GUN_PULSE          :       return new WeaponPulse( 0, -1, TEAM_PLAYER  );
		case GUN_LASER          :       return new WeaponLaser( 0, -1, TEAM_PLAYER  );
		case GUN_MISSLE         :       return new WeaponMissle( 0, -1, TEAM_PLAYER  );
		case GUN_FOLLOW         :       return new WeaponFollow( 0, -1, TEAM_PLAYER  );
		case GUN_ARC            :       return new WeaponArc( 0, -1, NULL, TEAM_PLAYER  );
		case GUN_CHAIN          :       return new WeaponChainGun( 0, -1, "Iron Chain", 65500, NULL, TEAM_PLAYER, new ECollide((BITMAP *)global_data[IRON_000].dat,6,makecol(255,0,255),52)  );
		case GUN_CHAIN_FIRE     :       return new WeaponChainGun( 1, -1, "Fire Chain", 153000, NULL, TEAM_PLAYER, new ECollide((BITMAP *)global_data[IRON_000].dat,6,makecol(255,0,255),52)  );
		case GUN_SHATTER        :       return new WeaponShatter( 0, -1, NULL, TEAM_PLAYER );
		case GUN_SWIRL          :       return new WeaponSwirlGun(0,-1,NULL,TEAM_PLAYER);
		case GUN_SPREAD         :       return new WeaponSpreadGun( 0, -1, NULL, TEAM_PLAYER );
		case GUN_MASSIVE        :       return new WeaponMassiveGun( 0, -1, NULL, TEAM_PLAYER );
		case GUN_SABER          :       return new WeaponSaber( 0, -1, NULL, TEAM_PLAYER );
		case GUN_ANGLE          :       return new WeaponAngle( 0, -1, TEAM_PLAYER );
		case GUN_TRACTOR        :       return new WeaponTractorBeam( 0, -1, TEAM_PLAYER );
		case GUN_ROTATE         :       return new WeaponRotateGun( 0, -1, NULL, TEAM_PLAYER );
		//case GUN_STICKY		:	return new WeaponStick( 0, -1, TEAM_PLAYER );
		case GUN_STICKY         : {
						  //ECollide ** temp_list = new ECollide*[ gun_sticky_max_collide ];
						  //for ( int q = 0; q < gun_sticky_max_collide; q++ )
						  //	temp_list[q] = gun_sticky_collide_list[q]->copy();
						  //return new WeaponStick( 0, -1, TEAM_PLAYER, temp_list, gun_sticky_max_collide );
			return new WeaponStick( 0, -1, TEAM_PLAYER, gun_sticky_collide_list, gun_sticky_max_collide );
		}
		case GUN_YEHAT          :       return new WeaponYehatGun( 0, -1, NULL, TEAM_PLAYER );
	}
	return NULL;
}
