#include "defs.h"
#include "allegro.h"
#include "trigtable.h"
#include "hull.h"
#include "hull_ship_heli.h"
#include "spaceobj.h"
#include "rafkill.h"
#include "ebox.h"

HeliHull::HeliHull( BITMAP * look, int life, int level, ECollide * eb ):
HullObject( look, life, SHIP_DAMAGE, 1, level, 10, false, eb ),
kang( 0 ) {
}


void HeliHull::Draw( BITMAP * who, int x, int y ) {

	HullObject::Draw( who, x, y );

	#define heliX 8
	#define heliY 18
	#define kl (heliX+heliY+5)
	kang = (kang+18)%360;
	int col = makecol( 90, 90, 90 );
	for ( int z = 0; z < 360; z += 90 )
	for ( int size = 0; size < kl; size++ ) {
		int sx = (int)( x + tcos[(z+kang)%360] * size );
		int sy = (int)( y + tsine[(z+kang)%360] * size );
		circlefill( who, sx, sy, 1, col );
	}
}
