#! /usr/bin/env racket

#lang racket/base

(require "magick.ss" (for-syntax racket/base))

(define-syntax (test stx)
  (syntax-case stx ()
    [(_ (func arg ...))
     (with-syntax ([(tmp ...) (generate-temporaries #'(arg ...))])
       #'(let ([tmp arg] ...)
           (printf ">>> ~s~s\n" 'func `(,tmp ...))
           (let ([r (func tmp ...)])
             (printf "      -> ~s\n" r)
             r)))]))

;; (test (MagickGetPackageName))
;; (test (MagickGetCopyright))
;; (test (MagickGetVersion))
;; (test (MagickGetReleaseDate))
;; (test (MagickGetQuantumDepth))
;; (test (MagickQueryConfigureOptions "CO*"))
;; (test (MagickQueryFonts "Cou*"))
;; (test (MagickQueryFormats "J*"))
;; (test (MagickGetHomeURL))

;; (define w (test (NewMagickWand)))
;; (test (MagickGetImageFilename w))
;; (test (MagickReadImage w "~/html/images/eli.jpg"))

(define w (test (MagickReadImage "~/html/images/eli.jpg")))
;; (test (MagickGetImageFilename w))

;; (test (MagickGetImageFilename w))
;; (test (MagickGetImageFormat w))
;; (test (MagickGetImageCompression w))
;; (test (MagickGetImageDispose w))
;; (test (MagickGetImageType w))
;; (test (MagickGetImageInterlaceScheme w))
;; (test (MagickGetImageIndex w))
;; (test (MagickGetImageSize w))
;; (test (MagickGetImageSignature w))
;; (test (MagickBlurImage w 2.0 1.0))
;; ;; (test (MagickReadImage w "~/html/images/eeli.jpg"))
;; ;; (test (MagickGetException w))
;; (test (MagickSwirlImage w 90.0))
;; (test (MagickWaveImage w 4.0 40.0))
;; (test (MagickCharcoalImage w 5.0 0.7))
;; (test (MagickGetImageCompose w))
;; (test (MagickGetImageColorspace w))
;; (test (MagickCommentImage w "This is my test image"))
;; (test (MagickWriteImage w "~/tmp/x.jpg"))
;; (test (MagickDisplayImage w #f))
;; (test (MagickDescribeImage w))
;; (test (MagickGetImageWidth w))
;; (test (MagickGetImageHeight w))
;; (test (MagickGetImageChannelDepth w 'RedChannel))
;; (test (MagickGetImageExtrema w))
;; (test (MagickGetImageChannelExtrema w 'RedChannel))
;; (test (MagickGetImageChannelMean w 'RedChannel))
;; (test (MagickGetImageColors w))
;; (test (MagickGetImageDelay w))
;; (test (MagickSetImageDelay w 20))
;; (test (MagickGetImageDelay w))
;; (test (MagickGetImageDepth w))
;; (test (MagickSetImageDepth w 2))
;; (test (MagickGetImageDepth w))
;; (test (MagickGetImageIterations w))
;; (test (MagickSetImageIterations w 4))
;; (test (MagickGetImageIterations w))
;; (test (MagickGetSamplingFactors w))
;; (test (MagickSetSamplingFactors w '(2.0 1.0 0.5)))
;; (test (MagickGetSamplingFactors w))
;; (test (MagickGetImageRenderingIntent w))
;; (test (MagickSetImageRenderingIntent w 'SaturationIntent))
;; (test (MagickGetImageRenderingIntent w))
;; (test (MagickGetImageUnits w))
;; (test (MagickSetImageUnits w 'PixelsPerInchResolution))
;; (test (MagickGetImageUnits w))
;; (test (MagickGetImageVirtualPixelMethod w))
;; (test (MagickSetImageVirtualPixelMethod w 'EdgeVirtualPixelMethod))
;; (test (MagickGetImageVirtualPixelMethod w))
;; (test (MagickGetImageWhitePoint w))
;; (test (MagickSetImageWhitePoint w 3.0 4.0))
;; (test (MagickGetImageWhitePoint w))
;; (test (MagickGetImageResolution w))
;; (test (MagickSetImageResolution w 33.0 33.0))
;; (test (MagickGetImageResolution w))
;; (test (MagickGetSize w))
;; (test (MagickSetSize w 20 20))
;; (test (MagickGetSize w))
;; (test (MagickGetImageProfile w "ICC"))

;; (test (MagickAdaptiveThresholdImage w 2 2 0))
;; (test (MagickAddNoiseImage w 'LaplacianNoise))
;; (test (MagickEmbossImage w 1.0 0.5))
;; (test (MagickEvaluateImage w 'MaxEvaluateOperator 30768.0))
;; (test (MagickEvaluateImage w 'MinEvaluateOperator 34768.0))
;; (test (MagickEvaluateImageChannel w 'RedChannel 'MaxEvaluateOperator 28768.0))
;; (test (MagickEvaluateImageChannel w 'RedChannel 'MinEvaluateOperator 36768.0))
;; (test (MagickGetImageGamma w))
;; (test (MagickGammaImage w 0.5))
;; (test (MagickSetImageGamma w 0.5))
;; (test (MagickGetImageGamma w))
;; (test (MagickGaussianBlurImage w 5.0 2.0))
;; (test (MagickGaussianBlurImageChannel w 'RedChannel 1.0 0.1))
;; (test (MagickGetImageRedPrimary w))
;; (test (MagickSetImageRedPrimary w 20.0 20.0))
;; (test (MagickGetImageRedPrimary w))
;; (test (MagickTransformImage w "120x120+10+10" "100x100+0+0"))
;; (test (MagickThresholdImage w 32768.0))
;; (test (MagickThresholdImageChannel w 'RedChannel 32768.0))
;; (test (MagickSpreadImage w 2.0))
;; (test (MagickOilPaintImage w 3.0))
;; (test (MagickSpliceImage w 100 100 50 50))
;; (test (MagickSolarizeImage w 2.0))
;; (test (MagickShaveImage w 20 50))
;; (test (MagickSharpenImage w 10.0 9.0))
;; (test (MagickPosterizeImage w 2 #t))
;; (test (MagickContrastImage w 20))
;; (test (MagickEdgeImage w 5.0))
;; (test (MagickImplodeImage w 0.5))

;; (test (MagickConvolveImage
;;        w '(( 0.0 -1.0  0.0) ; sharpen
;;            (-1.0  5.0 -1.0)
;;            ( 0.0 -1.0  0.0))))
;; (test (MagickConvolveImage ; sharpen++
;;        w '((-1.0 -1.0 -1.0)
;;            (-1.0  9.0 -1.0)
;;            (-1.0 -1.0 -1.0))))
;; (test (MagickConvolveImage ; blur
;;        w '(( 1.0  1.0  1.0)
;;            ( 1.0  1.0  1.0)
;;            ( 1.0  1.0  1.0))))
;; (test (MagickConvolveImage ; edge enhance
;;        w '(( 0.0  0.0  0.0)
;;            (-1.0  1.0  0.0)
;;            ( 0.0  0.0  0.0))))
;; (test (MagickConvolveImage ; edge enhance++
;;        w '((-1.0  0.0  1.0)
;;            (-1.0  0.0  1.0)
;;            (-1.0  0.0  1.0))))
;; (test (MagickConvolveImage ; edge detect
;;        w '(( 0.0  1.0  0.0)
;;            ( 1.0 -4.0  1.0)
;;            ( 0.0  1.0  0.0))))
;; (test (MagickConvolveImage ; emboss
;;        w '((-2.0 -1.0  0.0)
;;            (-1.0  1.0  1.0)
;;            ( 0.0  1.0  2.0))))
;; (test (MagickConvolveImageChannel
;;        w 'RedChannel '((1.0 0.0  0.0 0.0 1.0)
;;                        (0.0 0.0  0.0 0.0 0.0)
;;                        (0.0 0.0 -1.0 0.0 0.0)
;;                        (0.0 0.0  0.0 0.0 0.0)
;;                        (1.0 0.0  0.0 0.0 1.0))))

;; (define pixels (test (MagickGetImagePixels w 0 0 40 40 "RGB" 'ShortPixel)))
;; (test (MagickSetImagePixels
;;        w 0 0 "RGB" 'ShortPixel
;;        (let ([pixels (map (lambda (x) (append x x))
;;                           pixels)])
;;          (append pixels
;;                  (map (lambda (row)
;;                         (map (lambda (pixel)
;;                                (list (cadr pixel) (caddr pixel) (car pixel))
;;                                ;; (map (lambda (v) (- 65535 v)) pixel)
;;                                )
;;                              row))
;;                       pixels)))))

;; (test (MagickLabelImage w "FOO"))
;; (test (MagickLevelImage w 20000.0 1.0 45535.0))
;; (test (MagickMedianFilterImage w 2.0))
;; (test (MagickModulateImage w 100.0 100.0 40.0))
;; (test (MagickMotionBlurImage w 10.0 10.0 60.0))
;; (test (MagickNegateImage w #f))
;; (test (MagickNegateImageChannel w 'GreenChannel #f))
;; (test (MagickNormalizeImage w))
;; (test (MagickRaiseImage w 10 10 20 20 #f))

;; (MagickMinifyImage w) (MagickMinifyImage w) (MagickMinifyImage w)
;; (test (MagickResampleImage w 576.0 576.0 'UndefinedFilter 1.0))
;; (test (MagickResampleImage w 576.0 576.0 'BoxFilter 1.0))
;; (test (MagickResampleImage w 576.0 576.0 'TriangleFilter 1.0))
;; (test (MagickResampleImage w 576.0 576.0 'HermiteFilter 1.0))
;; (test (MagickResampleImage w 576.0 576.0 'HanningFilter 1.0))
;; (test (MagickResampleImage w 576.0 576.0 'HammingFilter 1.0))
;; (test (MagickResampleImage w 576.0 576.0 'BlackmanFilter 1.0))
;; (test (MagickResampleImage w 576.0 576.0 'GaussianFilter 1.0))
;; (test (MagickResampleImage w 576.0 576.0 'QuadraticFilter 1.0))
;; (test (MagickResampleImage w 576.0 576.0 'CubicFilter 1.0))
;; (test (MagickResampleImage w 576.0 576.0 'CatromFilter 1.0))
;; (test (MagickResampleImage w 576.0 576.0 'MitchellFilter 1.0))
;; (test (MagickResampleImage w 576.0 576.0 'LanczosFilter 1.0))
;; (test (MagickResampleImage w 576.0 576.0 'BesselFilter 1.0))
;; (test (MagickResampleImage w 576.0 576.0 'SincFilter 1.0))

;; (test (MagickOpaqueImage w "black" "yellow" 20000.0))
;; (test (MagickColorFloodfillImage w "yellow" 20000.0 "black" 0 0))
;; (test (MagickColorFloodfillImage w "yellow" 20000.0 #f 0 0))
;; (test (MagickColorFloodfillImage w '(65535 0 0) 20000.0 "black" 0 0))
;; (test (MagickColorFloodfillImage w '(65535 0 0 32737) 20000.0 "black" 0 0))

;; (test (MagickTransparentImage w "black" 16384 20000.0))
;; (test (MagickWriteImage w "~/tmp/x.png"))

;; (test (MagickResetIterator w))
;; (test (MagickGetImageProfile w "ICC"))
;; (test (MagickSetImageProfile w "ICC" "foo"))
;; (test (MagickGetImageProfile w "ICC"))

;; (test (MagickGetImageBackgroundColor w))

;; (test (MagickDisplayImage w))

;; (for-each
;;  (lambda (p) (MagickDisplayImage (test (MagickPreviewImages w p))))
;;  '(UndefinedPreview RotatePreview ShearPreview RollPreview HuePreview
;;    SaturationPreview BrightnessPreview GammaPreview SpiffPreview DullPreview
;;    GrayscalePreview QuantizePreview DespecklePreview ReduceNoisePreview
;;    AddNoisePreview SharpenPreview BlurPreview ThresholdPreview
;;    EdgeDetectPreview SpreadPreview SolarizePreview ShadePreview RaisePreview
;;    SegmentPreview SwirlPreview ImplodePreview WavePreview OilPaintPreview
;;    CharcoalDrawingPreview JPEGPreview))

;; (test (MagickDisplayImage
;;        (MagickFxImageChannel w 'AllChannels "(p[-4,-4].r+p[4,4].g)/2")))

;; (test (MagickMagnifyImage w))
;; (let ([ww (CloneMagickWand w)])
;;   (test (MagickMinifyImage ww))
;;   (test (MagickMinifyImage ww))
;;   (test (MagickMinifyImage ww))
;;   (test (MagickDisplayImage (MagickTextureImage w ww))))

;; (test (MagickChopImage w 100 100 10 10))
;; (test (MagickCropImage w 100 100 10 10))
;; (test (MagickDisplayImage w))

;; (define w1 (test (CloneMagickWand w)))
;; (test (MagickBlurImage w1 1.0 0.18))
;; (define t (cadr (test (MagickCompareImageChannels
;;                        w w1 'RedChannels 'MeanSquaredErrorMetric))))
;; (test (MagickDisplayImage t))

;; (test (MagickReadImage w "~/html/images/EliRegina.jpg"))
;; (define morph (test (MagickMorphImages w 20)))
;; (test (MagickWriteImage morph "~/tmp/x.gif"))
;; (MagickAnimateImages morph)

;; (let ([x (test (MagickWriteImageBlob w))])
;;   (with-output-to-file "~/tmp/x" (lambda () (display x)) 'truncate)
;;   (let ([ww (NewMagickWand)])
;;     (test (MagickReadImageBlob ww x))
;;     (MagickDisplayImage ww)))

;; (define w (test (NewMagickWand)))
;; (test (MagickReadImage w "~/html/images/spinlambda.gif"))
;; (test (MagickDisplayImage (test (MagickAppendImages w #f))))
;; (test (MagickDisplayImage (MagickAverageImages w)))
;; (test (MagickDisplayImage (test (MagickDeconstructImages w))))
;; (MagickAnimateImages w)

;; (let ([y (NewPixelWand "yellow")]
;;       [c (test (PixelGetQuantumColor "yellow"))]
;;       [r (NewPixelWand "red")]
;;       [rgb (lambda (p)
;;              (map (lambda (f) (f p))
;;                   (list PixelGetRedQuantum
;;                         PixelGetGreenQuantum
;;                         PixelGetBlueQuantum)))])
;;   (printf ">>> y = ~s\n" (rgb y))
;;   (printf ">>> r1 = ~s\n" (rgb r))
;;   (PixelSetQuantumColor r c)
;;   (printf ">>> r2 = ~s\n" (rgb r)))

;; (define i (test (NewPixelRegionIterator w 0 0 10 10)))
;; (test (PixelSetIteratorRow i 5))
;; (test (map PixelGetRedQuantum (PixelGetNextRow i)))
;; (test (map PixelGetRedQuantum (PixelGetNextRow i)))
;; (test (map PixelGetRedQuantum (PixelGetNextRow i)))

(define d (test (NewDrawingWand)))
;; (test (DrawGetTextEncoding d))
;; (test (MagickQueryFonts "Cou*"))
(test (DrawSetFont d "Courier-Bold"))
(test (DrawGetFont d))
(test (DrawSetFontSize d 96.0))
(test (DrawSetFontStretch d 'UltraCondensedStretch))
(test (DrawSetFontStyle d 'ObliqueStyle))
(test (DrawSetFontWeight d 24))
(test (DrawSetGravity d 'CenterGravity))
(test (DrawGetStrokeDashArray d))
(test (DrawSetStrokeDashArray d '(20.0 20.0)))
(test (DrawGetStrokeDashArray d))
(test (DrawSetStrokeColor d "red"))
(test (DrawSetStrokeAntialias d #t))
(test (DrawSetStrokeWidth d 5.0))
(test (DrawSetStrokeLineCap d 'RoundCap))
(test (DrawSetStrokeOpacity d 0.5))
;; (test (DrawLine d 0.0 0.0 200.0 200.0))
(define line '((10.0 10.0) (100.0 100.0) (100.0 10.0) (50.0 20.0)))
;; (test (DrawPolyline d line))
;; (test (DrawPolygon d line))
;; (test (DrawBezier d line))
;; (test (DrawLine d  0.0 0.0 100.0 100.0))
;; (test (DrawLine d  5.0 0.0 105.0 100.0))
;; (test (DrawLine d 10.0 0.0 110.0 100.0))
(test (DrawAffine d '(0.0 1.0 1.0 0.5 0.0 0.0)))
(test (DrawAnnotation d 0.0 0.0 "FOO"))
;; (test (DrawArc d 0.0 0.0 100.0 100.0 0.0 270.0))
;; (test (DrawCircle d 50.0 50.0 50.0 0.0))
(test (MagickDrawImage w d))
(test (MagickDisplayImage w))
