#include <ClanLib/core.h>
#include <ClanLib/display.h>
#include <ClanLib/gl.h>
#include <ClanLib/gui.h>

#ifdef WIN32
	#pragma warning (disable:4355)
#endif

#include "menu_gfx.h"
#include "credits_menu.h"
#include "../debug.h"
#include "../fonts.h"
#include "../config.h"
#include "../race_opengl.h"
#include "../race_text.h"

#define BIG_FONT Fonts::menu_big
#define SMALL_FONT Fonts::menu_small

CreditsMenu::CreditsMenu(CL_Component *parent, CL_StyleManager *style)
:
	CL_Component(
			CL_Rect(0, 0, CL_Display::get_width(), CL_Display::get_height()),
			parent,
			style),
		btn_back(   CL_Rect( 10, 100, 10 + 120, 100 + 30), "Back", this, style),
		scroll( CL_Rect( 720, 150, 720+20, 150+350), 0, 1000, false, this, style )
{
	RaceDebug::print( "CreditsMenu: constructor", 9 );
	
	slots.connect( sig_paint(), this, &CreditsMenu::on_paint );
	slots.connect( btn_back.sig_clicked(), this, &CreditsMenu::on_back );

	CL_String path = DATADIR;
	path += "resources/credits.res";
	res = new CL_ResourceManager( path, false );

	sludgefeast = CL_Surface( "sludgefeast", res );
	text = CL_String( "text", res );
}

CreditsMenu::~CreditsMenu()
{
	delete res;
}

// .=======================< >=======================.
// | on_* functions                                  |
// '=======================< >======================='

void CreditsMenu::on_back()
{
	CL_Component::quit();
}

void CreditsMenu::on_paint()
{
	RaceDebug::print( "CreditsMenu: on_paint()", 8 );

	MenuGfx::bg->put_screen(0,0);
	MenuGfx::submenu_frame_bg->put_screen(130,130);

	glEnable(GL_SCISSOR_TEST);

//	glScissor( 140, 600-140-390, 140+590, 600-140 );
	// down left x,y , width, heigth
	glScissor( 140, 600-388-140, 590, 390 );
	draw_text();
	
	glDisable(GL_SCISSOR_TEST);
}

void CreditsMenu::draw_text()
{
	CL_Display::push_translate_offset(140, 140);

	int offset = -scroll.get_value();
	int i=1;
	
	sludgefeast.put_screen( 40, (i*20)+offset );i+=16;
	SMALL_FONT->print_left( 40, (i*20)+offset, "Sludgefeast homepage: \n   http://www.barnard666.freeserve.co.uk" );i+=4;

	SMALL_FONT->print_left( 40, (i*20)+offset, text );

	CL_Display::pop_translate_offset();
}
