#include <ClanLib/gl.h>
#include <ClanLib/display.h>

#include "camera.h"
#include "game_data.h"

RaceCamera::RaceCamera()
{
	x = 4.0f;
	y = -13.0f;
	z = 15.5f;
}


void RaceCamera::update( float _x, float _y, float _z )
{
	x = _x;
//	y = _y - 13.0f;
//	y = _y + 13.0f;
//	y = _y + 11.5f;
	y = _y + 7.5f;
//	z = _z + 15.5f;
//	z = _z + 13.5f;
//	z = _z + 6.5f;
	z = _z + 11.5f;

	if( x < 5.0f ) x = 5.0f;
	if( x > 35.0f ) x = 35.0f;
	if( y < 10.0f ) y = 10.0f;
	if( y > 40.0f ) y = 40.0f;

	if( CL_Keyboard::get_keycode( CL_KEY_F10 ) )
	{
		std::cout << "Camera Debug info: update" << std::endl;
		std::cout << "x: " << x << std::endl;
		std::cout << "y: " << y << std::endl;
		std::cout << "z: " << z << std::endl;
	}
}


void RaceCamera::look_at( float cx, float cy, float cz )
{
	if( CL_Keyboard::get_keycode( CL_KEY_F10 ) )
	{
		std::cout << "Camera Debug info: look_at " << std::endl;
		std::cout << "cx: " << cx << std::endl;
		std::cout << "cy: " << cy << std::endl;
		std::cout << "cz: " << cz << std::endl;
	}

	gluLookAt( x,y,z, cx, cy, cz, 0,-1,0 );
}


